/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Appender;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.extensibility.EngineTaintListener;
import org.eclipse.incquery.tooling.ui.IncQueryGUIPlugin;
import org.eclipse.incquery.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ModelConnectorTreeViewerKey;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ObservablePatternMatcher;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;
import org.eclipse.ui.IEditorPart;

public class ObservablePatternMatcherRoot
extends EngineTaintListener {
    private final Map<String, ObservablePatternMatcher> matchers;
    private final List<ObservablePatternMatcher> sortedMatchers;
    private final ModelConnectorTreeViewerKey key;
    private final ILog logger = IncQueryGUIPlugin.getDefault().getLog();
    public static final String MATCHERS_ID = "matchers";

    public ObservablePatternMatcherRoot(ModelConnectorTreeViewerKey key) {
        this.matchers = new HashMap<String, ObservablePatternMatcher>();
        this.sortedMatchers = new LinkedList<ObservablePatternMatcher>();
        this.key = key;
        AdvancedIncQueryEngine engine = key.getEngine();
        if (engine == null) {
            key.setEngine(this.createEngine());
        }
        if (engine != null) {
            engine.getLogger().addAppender((Appender)this);
        }
    }

    private AdvancedIncQueryEngine createEngine() {
        boolean wildcardMode = IncQueryGUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.incquery.tooling.gui.queryexplorer.WildcardMode");
        boolean dynamicEMFMode = IncQueryGUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.incquery.tooling.gui.queryexplorer.DynamicEMFMode");
        try {
            AdvancedIncQueryEngine engine = AdvancedIncQueryEngine.createUnmanagedEngine((Notifier)this.key.getNotifier(), (boolean)wildcardMode, (boolean)dynamicEMFMode);
            return engine;
        }
        catch (IncQueryException e) {
            this.logger.log((IStatus)new Status(4, "org.eclipse.incquery.tooling.ui", "Could not retrieve IncQueryEngine for " + this.key.getNotifier(), (Throwable)e));
            return null;
        }
    }

    public void addMatcher(IncQueryMatcher<? extends IPatternMatch> matcher, String patternFqn, boolean generated, String exceptionMessage) {
        ObservablePatternMatcher pm = new ObservablePatternMatcher(this, matcher, patternFqn, generated, exceptionMessage);
        this.matchers.put(patternFqn, pm);
        if (generated) {
            this.sortedMatchers.add(0, pm);
        } else {
            this.sortedMatchers.add(pm);
        }
        if (QueryExplorer.getInstance() != null) {
            QueryExplorer.getInstance().getMatcherTreeViewer().refresh((Object)this);
        }
    }

    public void removeMatcher(String patternFqn) {
        ObservablePatternMatcher matcher = this.matchers.get(patternFqn);
        if (matcher != null) {
            this.sortedMatchers.remove(matcher);
            matcher.dispose();
            this.matchers.remove(patternFqn);
            if (QueryExplorer.getInstance() != null) {
                QueryExplorer.getInstance().getMatcherTreeViewer().refresh((Object)this);
            }
        }
    }

    public List<ObservablePatternMatcher> getMatchers() {
        return this.sortedMatchers;
    }

    public String getText() {
        return this.key.toString();
    }

    public void dispose() {
        for (ObservablePatternMatcher pm : this.matchers.values()) {
            pm.dispose();
        }
        AdvancedIncQueryEngine engine = this.key.getEngine();
        if (engine != null) {
            engine.getLogger().removeAppender((Appender)this);
        }
    }

    public boolean isTainted() {
        AdvancedIncQueryEngine engine = this.key.getEngine();
        return engine == null ? true : engine.isTainted();
    }

    public ModelConnectorTreeViewerKey getKey() {
        return this.key;
    }

    public IEditorPart getEditorPart() {
        return this.key.getEditorPart();
    }

    public Notifier getNotifier() {
        return this.key.getNotifier();
    }

    public void engineBecameTainted() {
        for (ObservablePatternMatcher matcher : this.matchers.values()) {
            matcher.stopMonitoring();
        }
    }

    public void registerPattern(final Pattern ... patterns) {
        try {
            AdvancedIncQueryEngine engine = this.key.getEngine();
            if (engine.getBaseIndex().isInWildcardMode()) {
                this.addMatchersForPatterns(patterns);
            } else {
                engine.getBaseIndex().coalesceTraversals((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ObservablePatternMatcherRoot.this.addMatchersForPatterns(patterns);
                        return null;
                    }
                });
            }
        }
        catch (IncQueryException ex) {
            this.logger.log((IStatus)new Status(4, "org.eclipse.incquery.tooling.ui", "Cannot initialize pattern matcher engine.", (Throwable)ex));
        }
        catch (InvocationTargetException e) {
            this.logger.log((IStatus)new Status(4, "org.eclipse.incquery.tooling.ui", "Error during pattern matcher construction: " + e.getCause().getMessage(), e.getCause()));
        }
    }

    private void addMatchersForPatterns(Pattern ... patterns) {
        Pattern[] patternArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern = patternArray[n2];
            IncQueryMatcher matcher = null;
            boolean isGenerated = QueryExplorerPatternRegistry.getInstance().isGenerated(pattern);
            String message = null;
            try {
                matcher = this.key.getEngine().getMatcher(pattern);
            }
            catch (Exception e) {
                this.logger.log((IStatus)new Status(4, "org.eclipse.incquery.tooling.ui", "Cannot initialize pattern matcher for pattern " + CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern), (Throwable)e));
                matcher = null;
                message = e instanceof IncQueryException ? ((IncQueryException)((Object)e)).getShortMessage() : e.getMessage();
            }
            this.addMatcher((IncQueryMatcher<? extends IPatternMatch>)matcher, CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern), isGenerated, message);
            ++n2;
        }
    }

    public void unregisterPattern(Pattern pattern) {
        this.removeMatcher(CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern));
    }

    public static ObservablePatternMatcherRoot createPatternMatcherRoot(ModelConnectorTreeViewerKey key) {
        ObservablePatternMatcherRoot root = new ObservablePatternMatcherRoot(key);
        List<Pattern> activePatterns = QueryExplorerPatternRegistry.getInstance().getActivePatterns();
        root.registerPattern(activePatterns.toArray(new Pattern[activePatterns.size()]));
        return root;
    }
}

