/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ObservablePatternMatcherRoot;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.patternsviewer.PatternComposite;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.patternsviewer.PatternLeaf;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;
import org.eclipse.jface.viewers.TreeSelection;

public class PatternUnregistrationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TreeSelection selection = (TreeSelection)QueryExplorer.getInstance().getPatternsViewer().getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof PatternLeaf) {
                PatternLeaf leaf = (PatternLeaf)element;
                this.unregisterPattern(leaf.getFullPatternNamePrefix());
            } else {
                PatternComposite composite = (PatternComposite)element;
                List<PatternLeaf> leaves = composite.getAllLeaves();
                for (PatternLeaf leaf : leaves) {
                    this.unregisterPattern(leaf.getFullPatternNamePrefix());
                }
            }
            ++n2;
        }
        QueryExplorer.getInstance().getPatternsViewerInput().getGenericPatternsRoot().purge();
        QueryExplorer.getInstance().getPatternsViewer().refresh();
        return null;
    }

    private void unregisterPattern(String patternFqn) {
        Pattern pattern = QueryExplorerPatternRegistry.getInstance().getPatternByFqn(patternFqn);
        if (!QueryExplorerPatternRegistry.getInstance().isGenerated(pattern)) {
            QueryExplorerPatternRegistry.getInstance().unregisterPattern(pattern);
            QueryExplorer.getInstance().getPatternsViewerInput().getGenericPatternsRoot().removeComponent(patternFqn);
            for (ObservablePatternMatcherRoot root : QueryExplorer.getInstance().getMatcherTreeViewerRoot().getRoots()) {
                root.unregisterPattern(pattern);
            }
            QueryExplorerPatternRegistry.getInstance().removeActivePattern(pattern);
        }
    }
}

