/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.handlers;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.flyout.FlyoutControlComposite;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.MatcherTreeViewerRoot;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ObservablePatternMatcherRoot;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.patternsviewer.PatternComponent;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.patternsviewer.PatternComposite;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.DisplayUtil;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;

public class RuntimeMatcherRegistrator
implements Runnable {
    private final IFile file;
    @Inject
    DisplayUtil dbUtil;

    public RuntimeMatcherRegistrator(IFile file) {
        this.file = file;
    }

    @Override
    public void run() {
        QueryExplorer queryExplorerInstance = QueryExplorer.getInstance();
        if (queryExplorerInstance != null) {
            MatcherTreeViewerRoot vr = queryExplorerInstance.getMatcherTreeViewerRoot();
            PatternComposite viewerInput = queryExplorerInstance.getPatternsViewerInput().getGenericPatternsRoot();
            this.openPatternsViewerIfNoPreviousPatterns(queryExplorerInstance);
            this.unregisterPatternsFromMatcherTreeViewer(vr);
            this.removeLabelsFromPatternRegistry(queryExplorerInstance, viewerInput);
            List<Pattern> newPatterns = this.registerPatternsFromPatternModel(vr);
            this.setCheckedStatesOnNewPatterns(queryExplorerInstance, viewerInput, newPatterns);
        }
    }

    private void setCheckedStatesOnNewPatterns(QueryExplorer queryExplorerInstance, PatternComposite viewerInput, List<Pattern> newPatterns) {
        ArrayList<PatternComponent> components = new ArrayList<PatternComponent>();
        for (Pattern pattern : newPatterns) {
            PatternComponent component = viewerInput.addComponent(CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern));
            components.add(component);
        }
        queryExplorerInstance.getPatternsViewer().refresh();
        for (PatternComponent component : components) {
            queryExplorerInstance.getPatternsViewer().setChecked((Object)component, true);
        }
        if (components.size() > 0) {
            ((PatternComponent)components.get(0)).getParent().propagateSelectionToTop((PatternComponent)components.get(0));
        }
    }

    private void removeLabelsFromPatternRegistry(QueryExplorer queryExplorerInstance, PatternComposite viewerInput) {
        List<Pattern> oldParsedModel = QueryExplorerPatternRegistry.getInstance().getRegisteredPatternsForFile(this.file);
        if (oldParsedModel != null) {
            for (Pattern pattern : oldParsedModel) {
                viewerInput.removeComponent(CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern));
            }
        }
        queryExplorerInstance.getPatternsViewerInput().getGenericPatternsRoot().purge();
        queryExplorerInstance.getPatternsViewer().refresh();
    }

    private List<Pattern> registerPatternsFromPatternModel(MatcherTreeViewerRoot vr) {
        PatternModel newParsedModel = this.dbUtil.parseEPM(this.file);
        List<Pattern> newPatterns = QueryExplorerPatternRegistry.getInstance().registerPatternModel(this.file, newParsedModel);
        List<Pattern> allActivePatterns = QueryExplorerPatternRegistry.getInstance().getActivePatterns();
        for (ObservablePatternMatcherRoot root : vr.getRoots()) {
            root.registerPattern(allActivePatterns.toArray(new Pattern[allActivePatterns.size()]));
        }
        return newPatterns;
    }

    private void unregisterPatternsFromMatcherTreeViewer(MatcherTreeViewerRoot vr) {
        List<Pattern> allActivePatterns = QueryExplorerPatternRegistry.getInstance().getActivePatterns();
        QueryExplorerPatternRegistry.getInstance().unregisterPatternModel(this.file);
        for (ObservablePatternMatcherRoot root : vr.getRoots()) {
            for (Pattern pattern : allActivePatterns) {
                root.unregisterPattern(pattern);
            }
            AdvancedIncQueryEngine engine = root.getKey().getEngine();
            if (engine == null) continue;
            engine.wipe();
        }
    }

    private void openPatternsViewerIfNoPreviousPatterns(QueryExplorer queryExplorerInstance) {
        if (QueryExplorerPatternRegistry.getInstance().isEmpty()) {
            FlyoutControlComposite flyout = queryExplorerInstance.getPatternsViewerFlyout();
            flyout.getPreferences().setState(0);
            flyout.layout();
        }
    }
}

