/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.builder;

import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.incquery.tooling.core.generator.genmodel.IEiqGenmodelProvider;

public class IncQueryProjectBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.incquery.tooling.core.projectbuilder";
    @Inject
    private IEiqGenmodelProvider genmodelProvider;

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (kind == 9 || kind == 10) {
            ChangeDetector visitor = new ChangeDetector(this.genmodelProvider.getGeneratorModelPath(this.getProject()));
            this.getDelta(this.getProject()).accept((IResourceDeltaVisitor)visitor);
            if (visitor.isChangeFound()) {
                this.getProject().accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        String extension = resource.getFileExtension();
                        if ("eiq".equals(extension)) {
                            resource.touch((IProgressMonitor)new NullProgressMonitor());
                        }
                        return false;
                    }
                });
            }
        }
        return null;
    }

    private static final class ChangeDetector
    implements IResourceDeltaVisitor {
        private final IPath path;
        private boolean changeFound = false;

        public ChangeDetector(IPath path) {
            this.path = path;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (this.path.equals((Object)delta.getFullPath())) {
                this.changeFound = true;
            }
            return !this.changeFound;
        }

        public boolean isChangeFound() {
            return this.changeFound;
        }
    }
}

