/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model.converters;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.list.ComputedList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.StringValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableValue;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.FormatSpecification;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.converters.FormatParser;

public class EdgeList
extends ComputedList {
    private String labelParameterName;
    private String sourceParameterName;
    private String destParameterName;
    private Multimap<Object, Item> itemMap;
    private FormatSpecification format;
    private IObservableList patternMatchList;

    public EdgeList(Annotation itemAnnotation, Annotation formatAnnotation, Multimap<Object, Item> itemMap, IObservableList patternMatchList) {
        Preconditions.checkArgument((boolean)"Edge".equals(itemAnnotation.getName()), (Object)"The converter should be initialized using a Edge annotation.");
        this.itemMap = itemMap;
        this.sourceParameterName = ((VariableValue)CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)itemAnnotation, (String)"source")).getValue().getVar();
        this.destParameterName = ((VariableValue)CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)itemAnnotation, (String)"target")).getValue().getVar();
        StringValue labelParam = (StringValue)CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)itemAnnotation, (String)"label");
        String string = this.labelParameterName = labelParam == null ? "" : labelParam.getValue();
        if (formatAnnotation != null) {
            this.format = FormatParser.parseFormatAnnotation(formatAnnotation);
        }
        this.patternMatchList = patternMatchList;
    }

    protected List<Edge> calculate() {
        ArrayList<Edge> edgeList = new ArrayList<Edge>();
        for (Object _match : this.patternMatchList) {
            IPatternMatch match = (IPatternMatch)_match;
            EObject sourceValue = (EObject)match.get(this.sourceParameterName);
            EObject destValue = (EObject)match.get(this.destParameterName);
            for (Object _sourceItem : this.itemMap.get((Object)sourceValue)) {
                Item sourceItem = (Item)_sourceItem;
                for (Object _destItem : this.itemMap.get((Object)destValue)) {
                    Item destItem = (Item)_destItem;
                    Edge edge = new Edge(sourceItem, destItem, match, this.labelParameterName);
                    edge.setSpecification(this.format);
                    edgeList.add(edge);
                }
            }
        }
        return edgeList;
    }
}

