/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.base.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multiset;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.NotifyingList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.incquery.runtime.base.api.DataTypeListener;
import org.eclipse.incquery.runtime.base.api.FeatureListener;
import org.eclipse.incquery.runtime.base.api.IEStructuralFeatureProcessor;
import org.eclipse.incquery.runtime.base.api.IncQueryBaseIndexChangeListener;
import org.eclipse.incquery.runtime.base.api.InstanceListener;
import org.eclipse.incquery.runtime.base.api.LightweightEObjectObserver;
import org.eclipse.incquery.runtime.base.api.NavigationHelper;
import org.eclipse.incquery.runtime.base.comprehension.EMFModelComprehension;
import org.eclipse.incquery.runtime.base.core.NavigationHelperContentAdapter;
import org.eclipse.incquery.runtime.base.core.NavigationHelperSetting;
import org.eclipse.incquery.runtime.base.core.NavigationHelperVisitor;
import org.eclipse.incquery.runtime.base.exception.IncQueryBaseException;

public class NavigationHelperImpl
implements NavigationHelper {
    protected boolean inWildcardMode;
    protected Set<EClass> directlyObservedClasses;
    protected Set<EClass> allObservedClasses = null;
    protected Set<EDataType> observedDataTypes;
    protected Set<EStructuralFeature> observedFeatures;
    protected Notifier notifier;
    protected Set<Notifier> modelRoots;
    private boolean expansionAllowed;
    protected NavigationHelperContentAdapter contentAdapter;
    private final Logger logger;
    private final Set<IncQueryBaseIndexChangeListener> baseIndexChangeListeners;
    private final Map<InstanceListener, Collection<EClass>> instanceListeners;
    private final Map<FeatureListener, Collection<EStructuralFeature>> featureListeners;
    private final Map<DataTypeListener, Collection<EDataType>> dataTypeListeners;
    private final Map<LightweightEObjectObserver, Collection<EObject>> lightweightObservers;
    protected boolean delayTraversals = false;
    protected Set<EClass> delayedClasses;
    protected Set<EStructuralFeature> delayedFeatures;
    protected Set<EDataType> delayedDataTypes;

    <T> Set<T> setMinus(Set<T> a, Set<T> b) {
        HashSet<T> result = new HashSet<T>(a);
        result.removeAll(b);
        return result;
    }

    <T extends EObject> Set<T> resolveAll(Set<T> a) {
        if (a == null) {
            a = Collections.emptySet();
        }
        HashSet<EObject> result = new HashSet<EObject>();
        for (EObject t : a) {
            if (t.eIsProxy()) {
                result.add(EcoreUtil.resolve((EObject)t, null));
                continue;
            }
            result.add(t);
        }
        return result;
    }

    @Override
    public boolean isInWildcardMode() {
        return this.inWildcardMode;
    }

    @Override
    public boolean isInDynamicEMFMode() {
        return this.contentAdapter.isDynamicModel();
    }

    public NavigationHelperImpl(Notifier emfRoot, boolean wildcardMode, boolean dynamicModel, Logger logger) throws IncQueryBaseException {
        this.logger = logger;
        assert (logger != null);
        this.instanceListeners = new HashMap<InstanceListener, Collection<EClass>>();
        this.featureListeners = new HashMap<FeatureListener, Collection<EStructuralFeature>>();
        this.dataTypeListeners = new HashMap<DataTypeListener, Collection<EDataType>>();
        this.lightweightObservers = new HashMap<LightweightEObjectObserver, Collection<EObject>>();
        this.directlyObservedClasses = new HashSet<EClass>();
        this.observedFeatures = new HashSet<EStructuralFeature>();
        this.observedDataTypes = new HashSet<EDataType>();
        this.contentAdapter = new NavigationHelperContentAdapter(this, dynamicModel);
        this.baseIndexChangeListeners = new HashSet<IncQueryBaseIndexChangeListener>();
        this.notifier = emfRoot;
        this.modelRoots = new HashSet<Notifier>();
        this.expansionAllowed = false;
        this.inWildcardMode = wildcardMode;
        if (emfRoot != null) {
            this.addRootInternal(emfRoot);
        }
    }

    public NavigationHelperContentAdapter getContentAdapter() {
        return this.contentAdapter;
    }

    public Set<EStructuralFeature> getObservedFeatures() {
        return this.observedFeatures;
    }

    @Override
    public void dispose() {
        this.ensureNoListenersForDispose();
        for (Notifier root : this.modelRoots) {
            this.contentAdapter.removeAdapter(root);
        }
    }

    @Override
    public Set<Object> getDataTypeInstances(EDataType type) {
        Map<Object, Integer> valMap = this.contentAdapter.getDataTypeMap(type);
        if (valMap != null) {
            return Collections.unmodifiableSet(valMap.keySet());
        }
        this.contentAdapter.maintainMetamodel((EClassifier)type);
        return Collections.emptySet();
    }

    @Override
    public Set<EStructuralFeature.Setting> findByAttributeValue(Object value) {
        HashSet<EStructuralFeature.Setting> retSet = new HashSet<EStructuralFeature.Setting>();
        Map valMap = this.contentAdapter.getValueToFeatureToHolderMap().row(value);
        for (Map.Entry entry : valMap.entrySet()) {
            for (EObject holder : (Set)entry.getValue()) {
                if (this.contentAdapter.isDynamicModel()) {
                    retSet.add(new NavigationHelperSetting(this.contentAdapter.getKnownFeature((String)entry.getKey()), holder, value));
                    continue;
                }
                retSet.add(new NavigationHelperSetting((EStructuralFeature)entry.getKey(), holder, value));
            }
        }
        return retSet;
    }

    @Override
    public Set<EStructuralFeature.Setting> findByAttributeValue(Object value, Collection<EAttribute> attributes) {
        HashSet<EStructuralFeature.Setting> retSet = new HashSet<EStructuralFeature.Setting>();
        Map valMap = this.contentAdapter.getValueToFeatureToHolderMap().row(value);
        for (EAttribute attr : attributes) {
            Object feature;
            Object object = feature = this.contentAdapter.isDynamicModel() ? NavigationHelperContentAdapter.getUniqueIdentifier((ETypedElement)attr) : attr;
            if (valMap.get(feature) != null) {
                for (EObject holder : (Set)valMap.get(feature)) {
                    retSet.add(new NavigationHelperSetting((EStructuralFeature)attr, holder, value));
                }
                continue;
            }
            this.contentAdapter.maintainMetamodel((EStructuralFeature)attr);
        }
        return retSet;
    }

    @Override
    public Set<EObject> findByAttributeValue(Object value, EAttribute attribute) {
        Object feature;
        Map valMap = this.contentAdapter.getValueToFeatureToHolderMap().row(value);
        Object object = feature = this.contentAdapter.isDynamicModel() ? NavigationHelperContentAdapter.getUniqueIdentifier((ETypedElement)attribute) : attribute;
        if (valMap.get(feature) == null) {
            this.contentAdapter.maintainMetamodel((EStructuralFeature)attribute);
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet((Set)valMap.get(feature));
    }

    @Override
    public void processAllFeatureInstances(EStructuralFeature feature, IEStructuralFeatureProcessor processor) {
        this.contentAdapter.maintainMetamodel(feature);
        Map instanceMap = this.contentAdapter.getValueToFeatureToHolderMap().column((Object)feature);
        for (Map.Entry entry : instanceMap.entrySet()) {
            for (EObject src : (Set)entry.getValue()) {
                processor.process(feature, src, entry.getKey());
            }
        }
    }

    @Override
    public Set<EStructuralFeature.Setting> getInverseReferences(EObject target) {
        HashSet<EStructuralFeature.Setting> retSet = new HashSet<EStructuralFeature.Setting>();
        Map valMap = this.contentAdapter.getValueToFeatureToHolderMap().row((Object)target);
        for (Map.Entry entry : valMap.entrySet()) {
            for (EObject source : (Set)entry.getValue()) {
                if (this.contentAdapter.isDynamicModel()) {
                    retSet.add(new NavigationHelperSetting(this.contentAdapter.getKnownFeature((String)entry.getKey()), source, target));
                    continue;
                }
                retSet.add(new NavigationHelperSetting((EStructuralFeature)entry.getKey(), source, target));
            }
        }
        return retSet;
    }

    @Override
    public Set<EStructuralFeature.Setting> getInverseReferences(EObject target, Collection<EReference> references) {
        HashSet<EStructuralFeature.Setting> retSet = new HashSet<EStructuralFeature.Setting>();
        Map valMap = this.contentAdapter.getValueToFeatureToHolderMap().row((Object)target);
        for (EReference ref : references) {
            Object feature;
            Object object = feature = this.contentAdapter.isDynamicModel() ? NavigationHelperContentAdapter.getUniqueIdentifier((ETypedElement)ref) : ref;
            if (valMap.get(feature) != null) {
                for (EObject source : (Set)valMap.get(feature)) {
                    retSet.add(new NavigationHelperSetting((EStructuralFeature)ref, source, target));
                }
                continue;
            }
            this.contentAdapter.maintainMetamodel((EStructuralFeature)ref);
        }
        return retSet;
    }

    @Override
    public Set<EObject> getInverseReferences(EObject target, EReference reference) {
        Object feature = this.contentAdapter.isDynamicModel() ? NavigationHelperContentAdapter.getUniqueIdentifier((ETypedElement)reference) : reference;
        Map valMap = this.contentAdapter.getValueToFeatureToHolderMap().row((Object)target);
        if (valMap.get(feature) == null) {
            this.contentAdapter.maintainMetamodel((EStructuralFeature)reference);
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet((Set)valMap.get(feature));
    }

    @Override
    public Set<EObject> getReferenceValues(EObject source, EReference reference) {
        Set<Object> targets = this.getFeatureTargets(source, (EStructuralFeature)reference);
        return targets;
    }

    @Override
    public Set<Object> getFeatureTargets(EObject source, EStructuralFeature _feature) {
        Object feature = this.contentAdapter.isDynamicModel() ? NavigationHelperContentAdapter.getUniqueIdentifier((ETypedElement)_feature) : _feature;
        Set valSet = (Set)this.contentAdapter.getHolderToFeatureToValueMap().get((Object)source, feature);
        if (valSet == null) {
            this.contentAdapter.maintainMetamodel(_feature);
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(valSet);
    }

    @Override
    public Map<EObject, Set<Object>> getFeatureInstances(EStructuralFeature _feature) {
        Object feature = this.contentAdapter.isDynamicModel() ? NavigationHelperContentAdapter.getUniqueIdentifier((ETypedElement)_feature) : _feature;
        Map valMap = this.contentAdapter.getHolderToFeatureToValueMap().column(feature);
        if (valMap == null) {
            this.contentAdapter.maintainMetamodel(_feature);
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(valMap);
    }

    @Override
    public Set<EObject> getDirectInstances(EClass type) {
        Set<EObject> valSet = this.contentAdapter.getInstanceSet(type);
        if (valSet == null) {
            this.contentAdapter.maintainMetamodel((EClassifier)type);
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(valSet);
    }

    @Override
    public Set<EObject> getAllInstances(EClass type) {
        HashSet<EObject> retSet = new HashSet<EObject>();
        Set<EClass> valSet = NavigationHelperContentAdapter.getSubTypeMap().get(type);
        if (valSet != null) {
            for (EClass c : valSet) {
                Set<EObject> instances = this.contentAdapter.getInstanceSet(c);
                if (instances == null) continue;
                retSet.addAll(instances);
            }
        } else {
            this.contentAdapter.maintainMetamodel((EClassifier)type);
        }
        Set<EObject> instances = this.contentAdapter.getInstanceSet(type);
        if (instances != null) {
            retSet.addAll(instances);
        }
        return retSet;
    }

    @Override
    public Set<EObject> findByFeatureValue(Object value, EStructuralFeature _feature) {
        Object feature = this.contentAdapter.isDynamicModel() ? NavigationHelperContentAdapter.getUniqueIdentifier((ETypedElement)_feature) : _feature;
        HashSet<EObject> retSet = new HashSet<EObject>();
        Map valMap = this.contentAdapter.getValueToFeatureToHolderMap().row(value);
        if (valMap.get(feature) != null) {
            retSet.addAll((Collection)valMap.get(feature));
        } else {
            this.contentAdapter.maintainMetamodel(_feature);
        }
        return retSet;
    }

    @Override
    public Set<EObject> getHoldersOfFeature(EStructuralFeature _feature) {
        Object feature = this.contentAdapter.isDynamicModel() ? NavigationHelperContentAdapter.getUniqueIdentifier((ETypedElement)_feature) : _feature;
        Multiset<EObject> holders = this.contentAdapter.getFeatureToHolderMap().get(feature);
        if (holders == null) {
            this.contentAdapter.maintainMetamodel(_feature);
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(holders.elementSet());
    }

    @Override
    public void addInstanceListener(Collection<EClass> classes, InstanceListener listener) {
        this.contentAdapter.maintainMetamodel(classes);
        Collection<EClass> registered = this.instanceListeners.get(listener);
        if (registered == null) {
            registered = new HashSet<EClass>();
            this.instanceListeners.put(listener, registered);
        }
        registered.addAll(classes);
    }

    @Override
    public void removeInstanceListener(Collection<EClass> classes, InstanceListener listener) {
        Collection<EClass> restriction = this.instanceListeners.get(listener);
        if (restriction != null) {
            restriction.removeAll(classes);
            if (restriction.size() == 0) {
                this.instanceListeners.remove(listener);
            }
        }
    }

    @Override
    public void addFeatureListener(Collection<EStructuralFeature> features, FeatureListener listener) {
        for (EStructuralFeature feature : features) {
            this.contentAdapter.maintainMetamodel(feature);
        }
        Collection<EStructuralFeature> registered = this.featureListeners.get(listener);
        if (registered == null) {
            registered = new HashSet<EStructuralFeature>();
            this.featureListeners.put(listener, registered);
        }
        registered.addAll(features);
    }

    @Override
    public void removeFeatureListener(Collection<EStructuralFeature> features, FeatureListener listener) {
        Collection<EStructuralFeature> restriction = this.featureListeners.get(listener);
        if (restriction != null) {
            restriction.removeAll(features);
            if (restriction.size() == 0) {
                this.featureListeners.remove(listener);
            }
        }
    }

    @Override
    public void addDataTypeListener(Collection<EDataType> types, DataTypeListener listener) {
        this.contentAdapter.maintainMetamodel(types);
        Collection<EDataType> registered = this.dataTypeListeners.get(listener);
        if (registered == null) {
            registered = new HashSet<EDataType>();
            this.dataTypeListeners.put(listener, registered);
        }
        registered.addAll(types);
    }

    @Override
    public void removeDataTypeListener(Collection<EDataType> types, DataTypeListener listener) {
        Collection<EDataType> restriction = this.dataTypeListeners.get(listener);
        if (restriction != null) {
            restriction.removeAll(types);
            if (restriction.size() == 0) {
                this.dataTypeListeners.remove(listener);
            }
        }
    }

    public Map<InstanceListener, Collection<EClass>> getInstanceListeners() {
        return this.instanceListeners;
    }

    public Map<FeatureListener, Collection<EStructuralFeature>> getFeatureListeners() {
        return this.featureListeners;
    }

    public Map<DataTypeListener, Collection<EDataType>> getDataTypeListeners() {
        return this.dataTypeListeners;
    }

    public Set<EDataType> getObservedDataTypes() {
        return this.observedDataTypes;
    }

    @Override
    public void addLightweightEObjectObserver(LightweightEObjectObserver observer, EObject observedObject) {
        Collection<EObject> observedObjects = this.lightweightObservers.get(observer);
        if (observedObjects == null) {
            observedObjects = new HashSet<EObject>();
            observedObjects.add(observedObject);
        }
        this.lightweightObservers.put(observer, observedObjects);
    }

    @Override
    public void removeLightweightEObjectObserver(LightweightEObjectObserver observer, EObject observedObject) {
        Collection<EObject> observedObjects = this.lightweightObservers.get(observer);
        if (observedObjects != null) {
            observedObjects.remove(observedObject);
            if (observedObjects.isEmpty()) {
                this.lightweightObservers.remove(observer);
            }
        }
    }

    public Map<LightweightEObjectObserver, Collection<EObject>> getLightweightObservers() {
        return this.lightweightObservers;
    }

    protected void notifyBaseIndexChangeListeners(boolean baseIndexChanged) {
        if (!this.baseIndexChangeListeners.isEmpty()) {
            for (IncQueryBaseIndexChangeListener listener : new ArrayList<IncQueryBaseIndexChangeListener>(this.baseIndexChangeListeners)) {
                try {
                    if (listener.onlyOnIndexChange() && !baseIndexChanged) continue;
                    listener.notifyChanged(baseIndexChanged);
                }
                catch (Exception ex) {
                    this.logger.fatal((Object)"EMF-IncQuery Base encountered an error in delivering notifications about changes. ", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void addBaseIndexChangeListener(IncQueryBaseIndexChangeListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"Cannot add null listener!");
        this.baseIndexChangeListeners.add(listener);
    }

    @Override
    public void removeBaseIndexChangeListener(IncQueryBaseIndexChangeListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"Cannot remove null listener!");
        this.baseIndexChangeListeners.remove(listener);
    }

    protected void considerForExpansion(EObject obj) {
        Resource eResource;
        if (this.expansionAllowed && (eResource = obj.eResource()) != null && eResource.getResourceSet() == null) {
            this.expandToAdditionalRoot((Notifier)eResource);
        }
    }

    protected void expandToAdditionalRoot(Notifier root) {
        if (this.modelRoots.add(root)) {
            if (root instanceof ResourceSet) {
                this.expansionAllowed = true;
            }
            this.contentAdapter.addAdapter(root);
            this.contentAdapter.notifyBaseIndexChangeListeners();
        }
    }

    public boolean isExpansionAllowed() {
        return this.expansionAllowed;
    }

    public Set<EClass> getDirectlyObservedClasses() {
        return this.directlyObservedClasses;
    }

    public boolean isObserved(EClass clazz) {
        return this.inWildcardMode || this.getAllObservedClasses().contains(clazz);
    }

    public Set<EClass> getAllObservedClasses() {
        if (this.allObservedClasses == null) {
            this.allObservedClasses = new HashSet<EClass>();
            for (EClass eClass : this.directlyObservedClasses) {
                this.allObservedClasses.add(eClass);
                Set<EClass> subTypes = NavigationHelperContentAdapter.getSubTypeMap().get(eClass);
                if (subTypes == null) continue;
                this.allObservedClasses.addAll(subTypes);
            }
        }
        return this.allObservedClasses;
    }

    @Override
    public void registerObservedTypes(Set<EClass> classes, Set<EDataType> dataTypes, Set<EStructuralFeature> features) {
        this.ensureNotInWildcardMode();
        if (classes != null || features != null || dataTypes != null) {
            final Set<EStructuralFeature> resolvedFeatures = this.resolveAll(features);
            final Set<EClass> resolvedClasses = this.resolveAll(classes);
            final Set<EDataType> resolvedDatatypes = this.resolveAll(dataTypes);
            this.contentAdapter.maintainMetamodel(resolvedClasses);
            this.contentAdapter.maintainMetamodel(resolvedDatatypes);
            for (EStructuralFeature feature : resolvedFeatures) {
                this.contentAdapter.maintainMetamodel(feature.getEType());
                this.contentAdapter.maintainMetamodel((EClassifier)feature.getEContainingClass());
            }
            try {
                this.coalesceTraversals(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        NavigationHelperImpl.this.delayedFeatures.addAll(resolvedFeatures);
                        NavigationHelperImpl.this.delayedDataTypes.addAll(resolvedDatatypes);
                        NavigationHelperImpl.this.delayedClasses.addAll(resolvedClasses);
                        return null;
                    }
                });
            }
            catch (InvocationTargetException ex) {
                this.processingError(ex.getCause(), "register en masse the observed EClasses " + resolvedClasses + " and EDatatypes " + resolvedDatatypes + " and EStructuralFeatures " + resolvedFeatures);
            }
            catch (Exception ex) {
                this.processingError(ex, "register en masse the observed EClasses " + resolvedClasses + " and EDatatypes " + resolvedDatatypes + " and EStructuralFeatures " + resolvedFeatures);
            }
        }
    }

    @Override
    public void unregisterObservedTypes(Set<EClass> classes, Set<EDataType> dataTypes, Set<EStructuralFeature> features) {
        this.unregisterEClasses(classes);
        this.unregisterEDataTypes(dataTypes);
        this.unregisterEStructuralFeatures(features);
    }

    @Override
    public void registerEStructuralFeatures(Set<EStructuralFeature> features) {
        this.ensureNotInWildcardMode();
        if (features != null) {
            final Set<EStructuralFeature> resolved = this.resolveAll(features);
            for (EStructuralFeature feature : resolved) {
                this.contentAdapter.maintainMetamodel(feature);
            }
            try {
                this.coalesceTraversals(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        NavigationHelperImpl.this.delayedFeatures.addAll(resolved);
                        return null;
                    }
                });
            }
            catch (InvocationTargetException ex) {
                this.processingError(ex.getCause(), "register the observed EStructuralFeatures: " + resolved);
            }
            catch (Exception ex) {
                this.processingError(ex, "register the observed EStructuralFeatures: " + resolved);
            }
        }
    }

    @Override
    public void unregisterEStructuralFeatures(Set<EStructuralFeature> features) {
        this.ensureNotInWildcardMode();
        if (features != null) {
            features = this.resolveAll(features);
            this.ensureNoListeners(features, this.featureListeners);
            this.observedFeatures.removeAll(features);
            this.delayedFeatures.removeAll(features);
            for (EStructuralFeature f : features) {
                this.contentAdapter.getValueToFeatureToHolderMap().column((Object)NavigationHelperContentAdapter.getUniqueIdentifier((ETypedElement)f)).clear();
            }
        }
    }

    @Override
    public void registerEClasses(Set<EClass> classes) {
        this.ensureNotInWildcardMode();
        if (classes != null) {
            final Set<EClass> resolvedClasses = this.resolveAll(classes);
            this.contentAdapter.maintainMetamodel(resolvedClasses);
            try {
                this.coalesceTraversals(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        NavigationHelperImpl.this.delayedClasses.addAll(resolvedClasses);
                        return null;
                    }
                });
            }
            catch (InvocationTargetException ex) {
                this.processingError(ex.getCause(), "register the observed EClasses: " + resolvedClasses);
            }
            catch (Exception ex) {
                this.processingError(ex, "register the observed EClasses: " + resolvedClasses);
            }
        }
    }

    protected void startObservingClasses(Set<EClass> classes) {
        this.directlyObservedClasses.addAll(classes);
        this.getAllObservedClasses().addAll(classes);
        for (EClass eClass : classes) {
            Set<EClass> subTypes = NavigationHelperContentAdapter.getSubTypeMap().get(eClass);
            if (subTypes == null) continue;
            this.allObservedClasses.addAll(subTypes);
        }
    }

    @Override
    public void unregisterEClasses(Set<EClass> classes) {
        this.ensureNotInWildcardMode();
        if (classes != null) {
            classes = this.resolveAll(classes);
            this.ensureNoListeners(classes, this.instanceListeners);
            this.directlyObservedClasses.removeAll(classes);
            this.allObservedClasses = null;
            this.delayedClasses.removeAll(classes);
            for (EClass c : classes) {
                this.contentAdapter.removeInstanceSet(c);
            }
        }
    }

    @Override
    public void registerEDataTypes(Set<EDataType> dataTypes) {
        this.ensureNotInWildcardMode();
        if (dataTypes != null) {
            final Set<EDataType> resolved = this.resolveAll(dataTypes);
            this.contentAdapter.maintainMetamodel(resolved);
            try {
                this.coalesceTraversals(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        NavigationHelperImpl.this.delayedDataTypes.addAll(resolved);
                        return null;
                    }
                });
            }
            catch (InvocationTargetException ex) {
                this.processingError(ex.getCause(), "register the observed EDataTypes: " + resolved);
            }
            catch (Exception ex) {
                this.processingError(ex, "register the observed EDataTypes: " + resolved);
            }
        }
    }

    @Override
    public void unregisterEDataTypes(Set<EDataType> dataTypes) {
        this.ensureNotInWildcardMode();
        if (dataTypes != null) {
            dataTypes = this.resolveAll(dataTypes);
            this.ensureNoListeners(dataTypes, this.dataTypeListeners);
            this.observedDataTypes.removeAll(dataTypes);
            this.delayedDataTypes.removeAll(dataTypes);
            for (EDataType dataType : dataTypes) {
                this.contentAdapter.removeDataTypeMap(dataType);
            }
        }
    }

    @Override
    public <V> V coalesceTraversals(Callable<V> callable) throws InvocationTargetException {
        V finalResult = null;
        if (this.delayTraversals) {
            try {
                finalResult = callable.call();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
            return finalResult;
        }
        boolean firstRun = true;
        while (callable != null) {
            this.delayedClasses = new HashSet<EClass>();
            this.delayedFeatures = new HashSet<EStructuralFeature>();
            this.delayedDataTypes = new HashSet<EDataType>();
            try {
                NavigationHelperVisitor.TraversingVisitor visitor;
                HashSet<EDataType> toGatherDataTypes;
                HashSet<EStructuralFeature> toGatherFeatures;
                HashSet<EClass> toGatherClasses;
                HashSet<EClass> oldClasses;
                boolean classesWarrantTraversal;
                try {
                    this.delayTraversals = true;
                    V result = callable.call();
                    if (firstRun) {
                        firstRun = false;
                        finalResult = result;
                    }
                }
                catch (Throwable throwable) {
                    this.delayTraversals = false;
                    callable = null;
                    this.delayedFeatures = this.setMinus(this.delayedFeatures, this.observedFeatures);
                    this.delayedClasses = this.setMinus(this.delayedClasses, this.directlyObservedClasses);
                    this.delayedDataTypes = this.setMinus(this.delayedDataTypes, this.observedDataTypes);
                    boolean bl = classesWarrantTraversal = !this.setMinus(this.delayedClasses, this.getAllObservedClasses()).isEmpty();
                    if (!(this.delayedClasses.isEmpty() && this.delayedFeatures.isEmpty() && this.delayedDataTypes.isEmpty())) {
                        oldClasses = new HashSet<EClass>(this.directlyObservedClasses);
                        this.startObservingClasses(this.delayedClasses);
                        this.observedFeatures.addAll(this.delayedFeatures);
                        this.observedDataTypes.addAll(this.delayedDataTypes);
                        toGatherClasses = new HashSet<EClass>(this.delayedClasses);
                        toGatherFeatures = new HashSet<EStructuralFeature>(this.delayedFeatures);
                        toGatherDataTypes = new HashSet<EDataType>(this.delayedDataTypes);
                        if (classesWarrantTraversal || !toGatherFeatures.isEmpty() || !toGatherDataTypes.isEmpty()) {
                            visitor = new NavigationHelperVisitor.TraversingVisitor(this, toGatherFeatures, toGatherClasses, oldClasses, toGatherDataTypes);
                            callable = new Callable<V>(visitor){
                                private final /* synthetic */ NavigationHelperVisitor val$visitor;
                                {
                                    this.val$visitor = navigationHelperVisitor;
                                }

                                @Override
                                public V call() throws Exception {
                                    NavigationHelperImpl.this.traverse(this.val$visitor);
                                    return null;
                                }
                            };
                        }
                    }
                    throw throwable;
                }
                this.delayTraversals = false;
                callable = null;
                this.delayedFeatures = this.setMinus(this.delayedFeatures, this.observedFeatures);
                this.delayedClasses = this.setMinus(this.delayedClasses, this.directlyObservedClasses);
                this.delayedDataTypes = this.setMinus(this.delayedDataTypes, this.observedDataTypes);
                boolean bl = classesWarrantTraversal = !this.setMinus(this.delayedClasses, this.getAllObservedClasses()).isEmpty();
                if (this.delayedClasses.isEmpty() && this.delayedFeatures.isEmpty() && this.delayedDataTypes.isEmpty()) continue;
                oldClasses = new HashSet<EClass>(this.directlyObservedClasses);
                this.startObservingClasses(this.delayedClasses);
                this.observedFeatures.addAll(this.delayedFeatures);
                this.observedDataTypes.addAll(this.delayedDataTypes);
                toGatherClasses = new HashSet<EClass>(this.delayedClasses);
                toGatherFeatures = new HashSet<EStructuralFeature>(this.delayedFeatures);
                toGatherDataTypes = new HashSet<EDataType>(this.delayedDataTypes);
                if (!classesWarrantTraversal && toGatherFeatures.isEmpty() && toGatherDataTypes.isEmpty()) continue;
                visitor = new NavigationHelperVisitor.TraversingVisitor(this, toGatherFeatures, toGatherClasses, oldClasses, toGatherDataTypes);
                callable = new /* invalid duplicate definition of identical inner class */;
            }
            catch (Exception e) {
                this.getLogger().fatal((Object)"EMF-IncQuery Base encountered an error while traversing the EMF model to gather new information. ", (Throwable)e);
                throw new InvocationTargetException(e);
            }
        }
        return finalResult;
    }

    private void traverse(NavigationHelperVisitor visitor) {
        for (Notifier root : this.modelRoots) {
            EMFModelComprehension.traverseModel(visitor, root);
        }
        this.contentAdapter.notifyBaseIndexChangeListeners();
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void addRoot(Notifier emfRoot) throws IncQueryBaseException {
        this.addRootInternal(emfRoot);
    }

    @Override
    public <T extends EObject> void cheapMoveTo(T element, EList<T> targetContainmentReferenceList) {
        if (element.eAdapters().contains((Object)this.contentAdapter) && targetContainmentReferenceList instanceof NotifyingList) {
            Object listNotifier = ((NotifyingList)targetContainmentReferenceList).getNotifier();
            if (listNotifier instanceof Notifier && ((Notifier)listNotifier).eAdapters().contains((Object)this.contentAdapter)) {
                this.contentAdapter.ignoreInsertionAndDeletion = element;
                try {
                    targetContainmentReferenceList.add(element);
                }
                finally {
                    this.contentAdapter.ignoreInsertionAndDeletion = null;
                }
            } else {
                targetContainmentReferenceList.add(element);
            }
        } else {
            targetContainmentReferenceList.add(element);
        }
    }

    @Override
    public void cheapMoveTo(EObject element, EObject parent, EReference containmentFeature) {
        this.contentAdapter.maintainMetamodel((EStructuralFeature)containmentFeature);
        if (containmentFeature.isMany()) {
            this.cheapMoveTo(element, (EList)parent.eGet((EStructuralFeature)containmentFeature));
        } else if (element.eAdapters().contains((Object)this.contentAdapter) && parent.eAdapters().contains((Object)this.contentAdapter)) {
            this.contentAdapter.ignoreInsertionAndDeletion = element;
            try {
                parent.eSet((EStructuralFeature)containmentFeature, (Object)element);
            }
            finally {
                this.contentAdapter.ignoreInsertionAndDeletion = null;
            }
        } else {
            parent.eSet((EStructuralFeature)containmentFeature, (Object)element);
        }
    }

    private void addRootInternal(Notifier emfRoot) throws IncQueryBaseException {
        if (!(emfRoot instanceof EObject || emfRoot instanceof Resource || emfRoot instanceof ResourceSet)) {
            throw new IncQueryBaseException("Emf navigation helper can only be attached on the contents of an EMF EObject, Resource, or ResourceSet.");
        }
        this.expandToAdditionalRoot(emfRoot);
    }

    @Override
    public Set<EClass> getAllCurrentClasses() {
        return this.contentAdapter.getAllCurrentClasses();
    }

    protected void processingError(Throwable ex, String task) {
        this.contentAdapter.processingFatal(ex, task);
    }

    private void ensureNotInWildcardMode() {
        if (this.inWildcardMode) {
            throw new IllegalStateException("Cannot register/unregister observed classes in wildcard mode");
        }
    }

    private <Type> void ensureNoListeners(Set<Type> observedTypes, Map<?, Collection<Type>> listenerRegistry) {
        for (Collection<Type> listenerTypes : listenerRegistry.values()) {
            if (Collections.disjoint(observedTypes, listenerTypes)) continue;
            throw new IllegalStateException("Cannot unregister observed types for which there are active listeners");
        }
    }

    private void ensureNoListenersForDispose() {
        if (!(this.baseIndexChangeListeners.isEmpty() && this.featureListeners.isEmpty() && this.dataTypeListeners.isEmpty() && this.instanceListeners.isEmpty())) {
            throw new IllegalStateException("Cannot dispose while there are active listeners");
        }
    }
}

