/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.basiclinear;

import java.util.Comparator;
import java.util.Set;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.construction.Stub;
import org.eclipse.incquery.runtime.rete.construction.psystem.DeferredPConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.EnumerablePConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.PConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.PVariable;
import org.eclipse.incquery.runtime.rete.construction.psystem.basicenumerables.ConstantValue;
import org.eclipse.incquery.runtime.rete.util.OrderingCompareAgent;

public class OrderingHeuristics<PatternDescription, StubHandle, Collector>
implements Comparator<PConstraint> {
    private Stub<StubHandle> stub;

    public OrderingHeuristics(Stub<StubHandle> stub) {
        this.stub = stub;
    }

    @Override
    public int compare(PConstraint o1, PConstraint o2) {
        return new OrderingCompareAgent<PConstraint>(o1, o2){

            @Override
            protected void doCompare() {
                boolean temp;
                boolean bl = temp = this.consider(1.preferTrue(OrderingHeuristics.this.isConstant((PConstraint)this.a), OrderingHeuristics.this.isConstant((PConstraint)this.b))) && this.consider(1.preferTrue(OrderingHeuristics.this.isReady((PConstraint)this.a), OrderingHeuristics.this.isReady((PConstraint)this.b)));
                if (!temp) {
                    return;
                }
                Set<PVariable> bound1 = OrderingHeuristics.this.boundVariables((PConstraint)this.a);
                Set<PVariable> bound2 = OrderingHeuristics.this.boundVariables((PConstraint)this.b);
                this.swallowBoolean(temp && this.consider(1.preferTrue(OrderingHeuristics.this.isBound((PConstraint)this.a, bound1), OrderingHeuristics.this.isBound((PConstraint)this.b, bound2))) && this.consider(1.preferMore(Integer.valueOf(OrderingHeuristics.this.degreeBound((PConstraint)this.a, bound1)), OrderingHeuristics.this.degreeBound((PConstraint)this.b, bound2))) && this.consider(1.preferLess(Integer.valueOf(OrderingHeuristics.this.degreeFree((PConstraint)this.a, bound1)), OrderingHeuristics.this.degreeFree((PConstraint)this.b, bound2))) && this.consider(1.preferLess(((PConstraint)this.a).toString(), ((PConstraint)this.b).toString())));
            }
        }.compare();
    }

    boolean isConstant(PConstraint o) {
        return o instanceof ConstantValue;
    }

    boolean isReady(PConstraint o) {
        return o instanceof EnumerablePConstraint || o instanceof DeferredPConstraint && ((DeferredPConstraint)o).isReadyAt(this.stub);
    }

    Set<PVariable> boundVariables(PConstraint o) {
        Set<PVariable> boundVariables = CollectionsFactory.getSet(o.getAffectedVariables());
        boundVariables.retainAll(this.stub.getVariablesIndex().keySet());
        return boundVariables;
    }

    boolean isBound(PConstraint o, Set<PVariable> boundVariables) {
        return boundVariables.size() == o.getAffectedVariables().size();
    }

    int degreeBound(PConstraint o, Set<PVariable> boundVariables) {
        return boundVariables.size();
    }

    int degreeFree(PConstraint o, Set<PVariable> boundVariables) {
        return o.getAffectedVariables().size() - boundVariables.size();
    }
}

