/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.index;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.incquery.runtime.base.itc.alg.incscc.IncSCCAlg;
import org.eclipse.incquery.runtime.base.itc.alg.misc.Tuple;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.index.IterableIndexer;
import org.eclipse.incquery.runtime.rete.index.StandardIndexer;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.Receiver;
import org.eclipse.incquery.runtime.rete.single.TransitiveClosureNode;
import org.eclipse.incquery.runtime.rete.tuple.FlatTuple;
import org.eclipse.incquery.runtime.rete.tuple.MaskedTuple;
import org.eclipse.incquery.runtime.rete.tuple.TupleMask;

public class TransitiveClosureNodeIndexer
extends StandardIndexer
implements IterableIndexer {
    private TransitiveClosureNode tcNode;
    private IncSCCAlg<Object> tcAlg;
    private Collection<org.eclipse.incquery.runtime.rete.tuple.Tuple> emptySet;

    public TransitiveClosureNodeIndexer(TupleMask mask, IncSCCAlg<Object> tcAlg, TransitiveClosureNode tcNode) {
        super(tcNode.getContainer(), mask);
        this.tcAlg = tcAlg;
        this.tcNode = tcNode;
        this.emptySet = Collections.emptySet();
        this.parent = tcNode;
    }

    @Override
    public Collection<org.eclipse.incquery.runtime.rete.tuple.Tuple> get(org.eclipse.incquery.runtime.rete.tuple.Tuple signature) {
        if (signature.getSize() == this.mask.sourceWidth) {
            if (this.mask.indices.length == 0) {
                return this.getSignatures();
            }
            if (this.mask.indices.length == 1) {
                Set<org.eclipse.incquery.runtime.rete.tuple.Tuple> retSet = CollectionsFactory.getSet();
                if (this.mask.indices[0] == 0) {
                    Object source = signature.get(0);
                    for (Object target : this.tcAlg.getAllReachableTargets(source)) {
                        retSet.add(new FlatTuple(source, target));
                    }
                    return retSet;
                }
                if (this.mask.indices[0] == 1) {
                    Object target = signature.get(1);
                    for (Object source : this.tcAlg.getAllReachableSources(target)) {
                        retSet.add(new FlatTuple(source, target));
                    }
                    return retSet;
                }
            } else {
                if (this.mask.indices[0] == 0 && this.mask.indices[1] == 1) {
                    Object source = signature.get(0);
                    Object target = signature.get(1);
                    FlatTuple singleton = new FlatTuple(new FlatTuple(source, target));
                    return this.tcAlg.isReachable(source, target) ? Collections.singleton(singleton) : this.emptySet;
                }
                if (this.mask.indices[0] == 1 && this.mask.indices[1] == 0) {
                    Object source = signature.get(1);
                    Object target = signature.get(0);
                    FlatTuple singleton = new FlatTuple(new FlatTuple(source, target));
                    return this.tcAlg.isReachable(source, target) ? Collections.singleton(singleton) : this.emptySet;
                }
            }
        }
        return null;
    }

    @Override
    public Collection<org.eclipse.incquery.runtime.rete.tuple.Tuple> getSignatures() {
        return this.asTupleCollection(this.tcAlg.getTcRelation());
    }

    @Override
    public Iterator<org.eclipse.incquery.runtime.rete.tuple.Tuple> iterator() {
        return this.asTupleCollection(this.tcAlg.getTcRelation()).iterator();
    }

    private Collection<org.eclipse.incquery.runtime.rete.tuple.Tuple> asTupleCollection(Collection<Tuple<Object>> tuples) {
        Set<org.eclipse.incquery.runtime.rete.tuple.Tuple> retSet = CollectionsFactory.getSet();
        for (Tuple<Object> tuple : tuples) {
            retSet.add(new FlatTuple(tuple.getSource(), tuple.getTarget()));
        }
        return retSet;
    }

    public void propagate(Direction direction, org.eclipse.incquery.runtime.rete.tuple.Tuple updateElement, boolean change) {
        this.propagate(direction, updateElement, new MaskedTuple(updateElement, this.mask), change);
    }

    @Override
    public Receiver getActiveNode() {
        return this.tcNode;
    }
}

