/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.CheckConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.Constraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.xtext.xbase.XExpression;

public class CheckExpressionUtil {
    public static String getExpressionUniqueID(Pattern pattern, XExpression xExpression) {
        return String.valueOf(CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern)) + "_" + CheckExpressionUtil.getExpressionUniqueNameInPattern(pattern, xExpression);
    }

    public static String getExpressionUniqueNameInPattern(Pattern pattern, XExpression xExpression) {
        int patternBodyNumber = 0;
        for (PatternBody patternBody : pattern.getBodies()) {
            ++patternBodyNumber;
            int checkConstraintNumber = 0;
            for (Constraint constraint : patternBody.getConstraints()) {
                if (!(constraint instanceof CheckConstraint)) continue;
                CheckConstraint checkConstraint = (CheckConstraint)constraint;
                ++checkConstraintNumber;
                if (!xExpression.equals(checkConstraint.getExpression())) continue;
                return String.valueOf(patternBodyNumber) + "_" + checkConstraintNumber;
            }
        }
        return null;
    }

    public static IFile getIFile(Pattern pattern) {
        Resource resource;
        if (pattern != null && (resource = pattern.eResource()) != null) {
            URI uri = resource.getURI();
            uri = resource.getResourceSet().getURIConverter().normalize(uri);
            String scheme = uri.scheme();
            if ("platform".equals(scheme) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
                StringBuffer platformResourcePath = new StringBuffer();
                int j = 1;
                int size = uri.segmentCount();
                while (j < size) {
                    platformResourcePath.append('/');
                    platformResourcePath.append(uri.segment(j));
                    ++j;
                }
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath.toString()));
            }
        }
        return null;
    }
}

