package org.eclipse.incquery.tooling.generator.model.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.tooling.generator.model.generatorModel.Configuration;
import org.eclipse.incquery.tooling.generator.model.generatorModel.GeneratorModelPackage;
import org.eclipse.incquery.tooling.generator.model.generatorModel.GeneratorModelReference;
import org.eclipse.incquery.tooling.generator.model.generatorModel.IncQueryGeneratorModel;
import org.eclipse.incquery.tooling.generator.model.generatorModel.Property;
import org.eclipse.incquery.tooling.generator.model.services.GeneratorModelGrammarAccess;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic.Acceptor;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider.INodesForEObjectProvider;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class GeneratorModelSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private GeneratorModelGrammarAccess grammarAccess;
	
	public void createSequence(EObject context, EObject semanticObject) {
		if(semanticObject.eClass().getEPackage() == GeneratorModelPackage.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case GeneratorModelPackage.CONFIGURATION:
				if(context == grammarAccess.getConfigurationRule()) {
					sequence_Configuration(context, (Configuration) semanticObject); 
					return; 
				}
				else break;
			case GeneratorModelPackage.GENERATOR_MODEL_REFERENCE:
				if(context == grammarAccess.getGeneratorModelReferenceRule()) {
					sequence_GeneratorModelReference(context, (GeneratorModelReference) semanticObject); 
					return; 
				}
				else break;
			case GeneratorModelPackage.INC_QUERY_GENERATOR_MODEL:
				if(context == grammarAccess.getIncQueryGeneratorModelRule()) {
					sequence_IncQueryGeneratorModel(context, (IncQueryGeneratorModel) semanticObject); 
					return; 
				}
				else break;
			case GeneratorModelPackage.PROPERTY:
				if(context == grammarAccess.getPropertyRule()) {
					sequence_Property(context, (Property) semanticObject); 
					return; 
				}
				else break;
			}
		if (errorAcceptor != null) errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Constraint:
	 *     (name=ID property+=Property*)
	 */
	protected void sequence_Configuration(EObject context, Configuration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     genmodel=[GenModel|STRING]
	 */
	protected void sequence_GeneratorModelReference(EObject context, GeneratorModelReference semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, GeneratorModelPackage.Literals.GENERATOR_MODEL_REFERENCE__GENMODEL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, GeneratorModelPackage.Literals.GENERATOR_MODEL_REFERENCE__GENMODEL));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getGeneratorModelReferenceAccess().getGenmodelGenModelSTRINGTerminalRuleCall_1_0_1(), semanticObject.getGenmodel());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     (genmodels+=GeneratorModelReference* configuration+=Configuration*)
	 */
	protected void sequence_IncQueryGeneratorModel(EObject context, IncQueryGeneratorModel semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (key=ID value=STRING)
	 */
	protected void sequence_Property(EObject context, Property semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, GeneratorModelPackage.Literals.PROPERTY__KEY) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, GeneratorModelPackage.Literals.PROPERTY__KEY));
			if(transientValues.isValueTransient(semanticObject, GeneratorModelPackage.Literals.PROPERTY__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, GeneratorModelPackage.Literals.PROPERTY__VALUE));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getPropertyAccess().getKeyIDTerminalRuleCall_0_0(), semanticObject.getKey());
		feeder.accept(grammarAccess.getPropertyAccess().getValueSTRINGTerminalRuleCall_2_0(), semanticObject.getValue());
		feeder.finish();
	}
}
