/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.validation.runtime;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.validation.runtime.Constraint;
import org.eclipse.incquery.validation.runtime.ConstraintAdapter;
import org.eclipse.incquery.validation.runtime.ValidationPartListener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;

public final class ValidationUtil {
    private static Logger logger = Logger.getLogger(ValidationUtil.class);
    private static Map<IWorkbenchPage, Set<IEditorPart>> pageMap = new HashMap<IWorkbenchPage, Set<IEditorPart>>();
    private static Set<String> genericEditorIds = Sets.newHashSet((Object[])new String[]{"org.eclipse.emf.ecore.presentation.XMLReflectiveEditorID", "org.eclipse.emf.ecore.presentation.ReflectiveEditorID", "org.eclipse.emf.genericEditor"});
    private static Map<IEditorPart, ConstraintAdapter> adapterMap = new HashMap<IEditorPart, ConstraintAdapter>();
    private static Multimap<String, Constraint<IPatternMatch>> editorConstraintMap;

    private ValidationUtil() {
    }

    public static synchronized Map<IEditorPart, ConstraintAdapter> getAdapterMap() {
        return adapterMap;
    }

    public static synchronized Multimap<String, Constraint<IPatternMatch>> getEditorConstraintMap() {
        if (editorConstraintMap == null) {
            editorConstraintMap = ValidationUtil.loadConstraintsFromExtensions();
        }
        return editorConstraintMap;
    }

    public static int getSeverity(String severity) {
        if (severity != null) {
            if (severity.matches("error")) {
                return 2;
            }
            if (severity.matches("warning")) {
                return 1;
            }
        }
        return 0;
    }

    public static synchronized boolean isConstraintsRegisteredForEditorId(String editorId) {
        return ValidationUtil.getEditorConstraintMap().containsKey((Object)editorId);
    }

    public static synchronized Set<Constraint<IPatternMatch>> getConstraintsForEditorId(String editorId) {
        if (genericEditorIds.contains(editorId)) {
            return ImmutableSet.copyOf((Collection)ValidationUtil.getEditorConstraintMap().values());
        }
        HashSet<Constraint<IPatternMatch>> set = new HashSet<Constraint<IPatternMatch>>(ValidationUtil.getEditorConstraintMap().get((Object)editorId));
        set.addAll(ValidationUtil.getEditorConstraintMap().get((Object)"*"));
        return set;
    }

    private static synchronized Multimap<String, Constraint<IPatternMatch>> loadConstraintsFromExtensions() {
        HashMultimap result = HashMultimap.create();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("org.eclipse.incquery.validation.runtime.constraint");
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                if (ce.getName().equals("constraint")) {
                    ValidationUtil.processConstraintConfigurationElement((Multimap<String, Constraint<IPatternMatch>>)result, ce);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    private static void processConstraintConfigurationElement(Multimap<String, Constraint<IPatternMatch>> result, IConfigurationElement ce) {
        try {
            ArrayList<String> ids = new ArrayList<String>();
            IConfigurationElement[] iConfigurationElementArray = ce.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id;
                IConfigurationElement child = iConfigurationElementArray[n2];
                if (child.getName().equals("enabledForEditor") && (id = child.getAttribute("editorId")) != null && !id.equals("")) {
                    ids.add(id);
                }
                ++n2;
            }
            Object o = ce.createExecutableExtension("class");
            if (o instanceof Constraint) {
                if (ids.isEmpty()) {
                    ids.add("*");
                }
                for (String id : ids) {
                    result.put((Object)id, (Object)((Constraint)o));
                }
            }
        }
        catch (CoreException e) {
            logger.error((Object)"Error loading EMF-IncQuery Validation Constraint", (Throwable)e);
        }
    }

    public static synchronized void addNotifier(IEditorPart editorPart, Notifier notifier) {
        adapterMap.put(editorPart, new ConstraintAdapter(editorPart, notifier, logger));
    }

    public static void registerEditorPart(IEditorPart editorPart) {
        IWorkbenchPage page = editorPart.getSite().getPage();
        if (pageMap.containsKey(page)) {
            pageMap.get(page).add(editorPart);
        } else {
            HashSet<IEditorPart> editorParts = new HashSet<IEditorPart>();
            editorParts.add(editorPart);
            pageMap.put(page, editorParts);
            page.addPartListener((IPartListener)ValidationPartListener.getInstance());
        }
    }

    public static void unregisterEditorPart(IEditorPart editorPart) {
        IWorkbenchPage page = editorPart.getSite().getPage();
        if (pageMap.containsKey(page)) {
            pageMap.get(page).remove(editorPart);
            if (pageMap.get(page).size() == 0) {
                pageMap.remove(page);
                page.removePartListener((IPartListener)ValidationPartListener.getInstance());
            }
        }
    }
}

