/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.index;

import java.util.Collection;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.matchers.tuple.TupleMask;
import org.eclipse.incquery.runtime.rete.index.DefaultIndexerListener;
import org.eclipse.incquery.runtime.rete.index.Indexer;
import org.eclipse.incquery.runtime.rete.index.IterableIndexer;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.network.StandardNode;
import org.eclipse.incquery.runtime.rete.traceability.TraceInfo;

public abstract class DualInputNode
extends StandardNode {
    protected IterableIndexer primarySlot;
    protected Indexer secondarySlot;
    protected TupleMask complementerSecondaryMask;
    protected boolean coincidence;

    public IterableIndexer getPrimarySlot() {
        return this.primarySlot;
    }

    public Indexer getSecondarySlot() {
        return this.secondarySlot;
    }

    public DualInputNode(ReteContainer reteContainer, TupleMask complementerSecondaryMask) {
        super(reteContainer);
        this.complementerSecondaryMask = complementerSecondaryMask;
    }

    public void connectToIndexers(IterableIndexer primarySlot, Indexer secondarySlot) {
        this.primarySlot = primarySlot;
        this.secondarySlot = secondarySlot;
        this.coincidence = primarySlot.equals(secondarySlot);
        final DualInputNode me = this;
        if (!this.coincidence) {
            primarySlot.attachListener(new DefaultIndexerListener(this){

                @Override
                public void notifyIndexerUpdate(Direction direction, Tuple updateElement, Tuple signature, boolean change) {
                    DualInputNode.this.notifyUpdate(Side.PRIMARY, direction, updateElement, signature, change);
                }

                public String toString() {
                    return "primary@" + me;
                }
            });
            secondarySlot.attachListener(new DefaultIndexerListener(this){

                @Override
                public void notifyIndexerUpdate(Direction direction, Tuple updateElement, Tuple signature, boolean change) {
                    DualInputNode.this.notifyUpdate(Side.SECONDARY, direction, updateElement, signature, change);
                }

                public String toString() {
                    return "secondary@" + me;
                }
            });
        } else {
            primarySlot.attachListener(new DefaultIndexerListener(this){

                @Override
                public void notifyIndexerUpdate(Direction direction, Tuple updateElement, Tuple signature, boolean change) {
                    DualInputNode.this.notifyUpdate(Side.BOTH, direction, updateElement, signature, change);
                }

                public String toString() {
                    return "both@" + me;
                }
            });
        }
    }

    protected Collection<Tuple> retrieveOpposites(Side side, Tuple signature) {
        Collection<Tuple> opposites = this.getSlot(side.opposite()).get(signature);
        return opposites;
    }

    protected Tuple unify(Tuple left, Tuple right) {
        return this.complementerSecondaryMask.combine(left, right, true, true);
    }

    protected Tuple unify(Side side, Tuple ps, Tuple opposite) {
        switch (side) {
            case PRIMARY: {
                return this.unify(ps, opposite);
            }
            case SECONDARY: {
                return this.unify(opposite, ps);
            }
            case BOTH: {
                return this.unify(ps, opposite);
            }
        }
        return null;
    }

    public abstract void notifyUpdate(Side var1, Direction var2, Tuple var3, Tuple var4, boolean var5);

    public abstract Tuple calibrate(Tuple var1, Tuple var2);

    public void setComplementerSecondaryMask(TupleMask complementerSecondaryMask) {
        this.complementerSecondaryMask = complementerSecondaryMask;
    }

    protected Indexer getSlot(Side side) {
        if (side == Side.SECONDARY) {
            return this.secondarySlot;
        }
        return this.primarySlot;
    }

    @Override
    public void assignTraceInfo(TraceInfo traceInfo) {
        super.assignTraceInfo(traceInfo);
        if (traceInfo.propagateToIndexerParent()) {
            if (this.primarySlot != null) {
                this.primarySlot.acceptPropagatedTraceInfo(traceInfo);
            }
            if (this.secondarySlot != null) {
                this.secondarySlot.acceptPropagatedTraceInfo(traceInfo);
            }
        }
    }

    public static enum Side {
        PRIMARY,
        SECONDARY,
        BOTH;


        public Side opposite() {
            switch (this) {
                case PRIMARY: {
                    return SECONDARY;
                }
                case SECONDARY: {
                    return PRIMARY;
                }
                case BOTH: {
                    return BOTH;
                }
            }
            return BOTH;
        }
    }
}

