/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.index;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.incquery.runtime.base.itc.alg.incscc.IncSCCAlg;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.matchers.tuple.TupleMask;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.index.IterableIndexer;
import org.eclipse.incquery.runtime.rete.index.StandardIndexer;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.Receiver;
import org.eclipse.incquery.runtime.rete.single.TransitiveClosureNode;
import org.eclipse.incquery.runtime.rete.tuple.MaskedTuple;

public class TransitiveClosureNodeIndexer
extends StandardIndexer
implements IterableIndexer {
    private TransitiveClosureNode tcNode;
    private IncSCCAlg<Object> tcAlg;
    private Collection<Tuple> emptySet;

    public TransitiveClosureNodeIndexer(TupleMask mask, IncSCCAlg<Object> tcAlg, TransitiveClosureNode tcNode) {
        super(tcNode.getContainer(), mask);
        this.tcAlg = tcAlg;
        this.tcNode = tcNode;
        this.emptySet = Collections.emptySet();
        this.parent = tcNode;
    }

    @Override
    public Collection<Tuple> get(Tuple signature) {
        if (signature.getSize() == this.mask.sourceWidth) {
            if (this.mask.indices.length == 0) {
                return this.getSignatures();
            }
            if (this.mask.indices.length == 1) {
                Set<Tuple> retSet = CollectionsFactory.getSet();
                if (this.mask.indices[0] == 0) {
                    Object source = signature.get(0);
                    for (Object target : this.tcAlg.getAllReachableTargets(source)) {
                        retSet.add((Tuple)new FlatTuple(new Object[]{source, target}));
                    }
                    return retSet;
                }
                if (this.mask.indices[0] == 1) {
                    Object target = signature.get(1);
                    for (Object source : this.tcAlg.getAllReachableSources(target)) {
                        retSet.add((Tuple)new FlatTuple(new Object[]{source, target}));
                    }
                    return retSet;
                }
            } else {
                if (this.mask.indices[0] == 0 && this.mask.indices[1] == 1) {
                    Object source = signature.get(0);
                    Object target = signature.get(1);
                    FlatTuple singleton = new FlatTuple(new Object[]{new FlatTuple(new Object[]{source, target})});
                    return this.tcAlg.isReachable(source, target) ? Collections.singleton(singleton) : this.emptySet;
                }
                if (this.mask.indices[0] == 1 && this.mask.indices[1] == 0) {
                    Object source = signature.get(1);
                    Object target = signature.get(0);
                    FlatTuple singleton = new FlatTuple(new Object[]{new FlatTuple(new Object[]{source, target})});
                    return this.tcAlg.isReachable(source, target) ? Collections.singleton(singleton) : this.emptySet;
                }
            }
        }
        return null;
    }

    @Override
    public Collection<Tuple> getSignatures() {
        return this.asTupleCollection(this.tcAlg.getTcRelation());
    }

    @Override
    public Iterator<Tuple> iterator() {
        return this.asTupleCollection(this.tcAlg.getTcRelation()).iterator();
    }

    private Collection<Tuple> asTupleCollection(Collection<org.eclipse.incquery.runtime.base.itc.alg.misc.Tuple<Object>> tuples) {
        Set<Tuple> retSet = CollectionsFactory.getSet();
        for (org.eclipse.incquery.runtime.base.itc.alg.misc.Tuple<Object> tuple : tuples) {
            retSet.add((Tuple)new FlatTuple(new Object[]{tuple.getSource(), tuple.getTarget()}));
        }
        return retSet;
    }

    public void propagate(Direction direction, Tuple updateElement, boolean change) {
        this.propagate(direction, updateElement, new MaskedTuple(updateElement, this.mask), change);
    }

    @Override
    public Receiver getActiveNode() {
        return this.tcNode;
    }
}

