/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IMatchUpdateListener;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.MatchUpdateAdapter;
import org.eclipse.incquery.runtime.evm.api.event.Event;
import org.eclipse.incquery.runtime.evm.api.event.EventHandler;
import org.eclipse.incquery.runtime.evm.api.event.EventRealm;
import org.eclipse.incquery.runtime.evm.api.event.EventSource;
import org.eclipse.incquery.runtime.evm.api.event.EventSourceSpecification;
import org.eclipse.incquery.runtime.evm.notification.IAttributeMonitorListener;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEvent;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventRealm;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventSourceSpecification;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventTypeEnum;
import org.eclipse.incquery.runtime.exception.IncQueryException;

public class IncQueryEventSource<Match extends IPatternMatch>
implements EventSource<Match> {
    private final IncQueryEventRealm realm;
    private final IncQueryEventSourceSpecification<Match> sourceDefinition;
    private final IncQueryMatcher<Match> matcher;
    private IAttributeMonitorListener<Match> attributeMonitorListener;
    private final Set<EventHandler<Match>> handlers;
    private IMatchUpdateListener<Match> matchUpdateListener;

    protected IncQueryEventSource(IncQueryEventRealm realm, IncQueryEventSourceSpecification<Match> sourceDefinition) throws IncQueryException {
        IncQueryMatcher _matcher;
        Preconditions.checkArgument((realm != null ? 1 : 0) != 0, (Object)"Cannot create event source for null realm!");
        Preconditions.checkArgument((sourceDefinition != null ? 1 : 0) != 0, (Object)"Cannot create event source for null source definition!");
        this.realm = realm;
        this.sourceDefinition = sourceDefinition;
        IQuerySpecification<IncQueryMatcher<Match>> factory = sourceDefinition.getQuerySpecification();
        this.matcher = _matcher = factory.getMatcher(realm.getEngine());
        this.handlers = Sets.newHashSet();
    }

    @Override
    public EventSourceSpecification<Match> getSourceSpecification() {
        return this.sourceDefinition;
    }

    public IncQueryMatcher<Match> getMatcher() {
        return this.matcher;
    }

    @Override
    public EventRealm getRealm() {
        return this.realm;
    }

    protected boolean addHandler(EventHandler<Match> handler) {
        Preconditions.checkArgument((handler != null ? 1 : 0) != 0, (Object)"Handler cannot be null!");
        this.resendEventsForExistingMatches(handler);
        if (this.handlers.isEmpty()) {
            ((AdvancedIncQueryEngine)this.matcher.getEngine()).addMatchUpdateListener(this.matcher, this.matchUpdateListener, false);
        }
        return this.handlers.add(handler);
    }

    protected boolean removeHandler(EventHandler<Match> handler) {
        Preconditions.checkArgument((handler != null ? 1 : 0) != 0, (Object)"Handler cannot be null!");
        boolean removed = this.handlers.remove(handler);
        if (this.handlers.isEmpty()) {
            ((AdvancedIncQueryEngine)this.matcher.getEngine()).removeMatchUpdateListener(this.matcher, this.matchUpdateListener);
        }
        return removed;
    }

    public void notifyHandlers(Event<Match> event) {
        for (EventHandler<Match> handler : this.handlers) {
            handler.handleEvent(event);
        }
    }

    protected void prepareSource() {
        this.attributeMonitorListener = (IAttributeMonitorListener)Preconditions.checkNotNull(this.prepareAttributeMonitorListener(), (Object)"Prepared attribute monitor listener is null!");
        this.matchUpdateListener = (IMatchUpdateListener)Preconditions.checkNotNull(this.prepareMatchUpdateListener(), (Object)"Prepared match update listener is null!");
    }

    protected IAttributeMonitorListener<Match> prepareAttributeMonitorListener() {
        return new IAttributeMonitorListener<Match>(){

            @Override
            public void notifyUpdate(Match atom) {
                IncQueryEventSource.this.notifyHandlers(new IncQueryEvent(IncQueryEventTypeEnum.MATCH_UPDATES, atom));
            }
        };
    }

    protected IMatchUpdateListener<Match> prepareMatchUpdateListener() {
        IMatchProcessor matchAppearProcessor = new IMatchProcessor<Match>(){

            public void process(Match match) {
                IncQueryEventSource.this.notifyHandlers(new IncQueryEvent(IncQueryEventTypeEnum.MATCH_APPEARS, match));
            }
        };
        IMatchProcessor matchDisppearProcessor = new IMatchProcessor<Match>(){

            public void process(Match match) {
                IncQueryEventSource.this.notifyHandlers(new IncQueryEvent(IncQueryEventTypeEnum.MATCH_DISAPPEARS, match));
            }
        };
        return new MatchUpdateAdapter(matchAppearProcessor, matchDisppearProcessor);
    }

    private void resendEventsForExistingMatches(final EventHandler<Match> handler) {
        this.matcher.forEachMatch(new IMatchProcessor<Match>(){

            public void process(Match match) {
                handler.handleEvent(new IncQueryEvent(IncQueryEventTypeEnum.MATCH_APPEARS, match));
            }
        });
    }

    @Override
    public void dispose() {
        ((AdvancedIncQueryEngine)this.matcher.getEngine()).removeMatchUpdateListener(this.matcher, this.matchUpdateListener);
        for (EventHandler<Match> handler : this.handlers) {
            handler.dispose();
        }
        this.handlers.clear();
    }

    public IAttributeMonitorListener<Match> getAttributeMonitorListener() {
        Preconditions.checkState((this.attributeMonitorListener != null ? 1 : 0) != 0, (Object)"Event source not prepared yet!");
        return this.attributeMonitorListener;
    }
}

