/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.querybasedfeatures.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.incquery.runtime.base.api.BaseIndexOptions;
import org.eclipse.incquery.runtime.base.comprehension.EMFModelComprehension;
import org.eclipse.incquery.runtime.base.comprehension.EMFVisitor;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;

public class DerivedFeatureAdapter
extends AdapterImpl {
    private final InternalEObject source;
    private final EStructuralFeature derivedFeature;
    private final DerivedFeatureEMFVisitor visitor = new DerivedFeatureEMFVisitor();
    private Object currentValue;
    private Object oldValue;
    private EClassifier type;
    private EMFModelComprehension comprehension;
    private final List<EStructuralFeature> localFeatures = new ArrayList<EStructuralFeature>();
    private final List<DependentFeaturePath> featurePaths = new ArrayList<DependentFeaturePath>();

    public DerivedFeatureAdapter(EObject source, EStructuralFeature derivedFeature, EStructuralFeature navigationFeature, EStructuralFeature dependantFeature, EStructuralFeature localFeature) {
        this(source, derivedFeature);
        this.comprehension = new EMFModelComprehension(new BaseIndexOptions());
        this.addNavigatedDependencyInternal(navigationFeature, dependantFeature);
        this.addLocalDependencyInternal(localFeature);
    }

    public DerivedFeatureAdapter(EObject source, EStructuralFeature derivedFeature, EStructuralFeature navigationFeature, EStructuralFeature dependantFeature) {
        this(source, derivedFeature);
        this.addNavigatedDependencyInternal(navigationFeature, dependantFeature);
    }

    public DerivedFeatureAdapter(EObject source, EStructuralFeature derivedFeature, EStructuralFeature localFeature) {
        this(source, derivedFeature);
        this.addLocalDependencyInternal(localFeature);
    }

    public DerivedFeatureAdapter(EObject source, EStructuralFeature derivedFeature) {
        this.source = (InternalEObject)source;
        this.derivedFeature = derivedFeature;
        source.eAdapters().add((Object)this);
    }

    public void addNavigatedDependency(EStructuralFeature navigationFeature, EStructuralFeature dependantFeature) {
        if (navigationFeature == null || dependantFeature == null) {
            return;
        }
        if (!this.source.eClass().getEAllStructuralFeatures().contains((Object)navigationFeature)) {
            return;
        }
        if (!(navigationFeature.getEType() instanceof EClass) || !dependantFeature.getEContainingClass().isSuperTypeOf((EClass)navigationFeature.getEType())) {
            return;
        }
        this.addNavigatedDependencyInternal(navigationFeature, dependantFeature);
    }

    public void addLocalDependency(EStructuralFeature localFeature) {
        if (localFeature == null) {
            return;
        }
        if (!this.source.eClass().getEAllStructuralFeatures().contains((Object)localFeature)) {
            return;
        }
        this.addLocalDependencyInternal(localFeature);
    }

    private void addNavigatedDependencyInternal(EStructuralFeature navigationFeature, EStructuralFeature dependantFeature) {
        this.featurePaths.add(new DependentFeaturePath(navigationFeature, dependantFeature));
    }

    private void addLocalDependencyInternal(EStructuralFeature localFeature) {
        this.localFeatures.add(localFeature);
    }

    public void notifyChanged(Notification notification) {
        for (DependentFeaturePath path : this.featurePaths) {
            if (!notification.getFeature().equals(path.getNavigationFeature())) continue;
            switch (notification.getEventType()) {
                case 1: {
                    EObject newValue = (EObject)notification.getNewValue();
                    EObject tempOldValue = (EObject)notification.getOldValue();
                    if (tempOldValue != null) {
                        tempOldValue.eAdapters().remove((Object)path.getDependantAdapter());
                    } else {
                        IncQueryLoggingUtil.getDefaultLogger().debug((Object)"[DerivedFeatureAdapter] oldValue is not set");
                    }
                    if (newValue != null) {
                        newValue.eAdapters().add((Object)path.getDependantAdapter());
                        break;
                    }
                    IncQueryLoggingUtil.getDefaultLogger().debug((Object)"[DerivedFeatureAdapter] new value is not set");
                    break;
                }
                case 3: {
                    EObject added = (EObject)notification.getNewValue();
                    added.eAdapters().add((Object)path.getDependantAdapter());
                    break;
                }
                case 5: {
                    EObject newValueCollection = (EObject)notification.getNewValue();
                    for (Object newElement : (Collection)newValueCollection) {
                        ((Notifier)newElement).eAdapters().add((Object)path.getDependantAdapter());
                    }
                    break;
                }
                case 4: {
                    EObject removed = (EObject)notification.getOldValue();
                    removed.eAdapters().remove((Object)path.getDependantAdapter());
                    break;
                }
                case 6: {
                    EObject oldValueCollection = (EObject)notification.getOldValue();
                    for (Object oldElement : (Collection)oldValueCollection) {
                        ((Notifier)oldElement).eAdapters().remove((Object)path.getDependantAdapter());
                    }
                    break;
                }
                case 2: {
                    EObject unset = (EObject)notification.getOldValue();
                    unset.eAdapters().remove((Object)path.getDependantAdapter());
                    break;
                }
                case 0: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                default: {
                    IncQueryLoggingUtil.getDefaultLogger().debug((Object)("[DerivedFeatureAdapter] Unhandled notification: " + notification.getEventType()));
                    return;
                }
            }
            this.refreshDerivedFeature();
        }
        if (this.localFeatures.contains(notification.getFeature())) {
            this.refreshDerivedFeature();
        }
    }

    private void refreshDerivedFeature() {
        try {
            if (this.source.eNotificationRequired()) {
                if (this.type == null) {
                    this.type = this.derivedFeature.getEType();
                }
                if (this.derivedFeature.isMany()) {
                    this.oldValue = this.currentValue != null ? new HashSet((Collection)this.currentValue) : new HashSet();
                    this.currentValue = new HashSet();
                    Collection targets = (Collection)this.source.eGet(this.derivedFeature);
                    for (Object target : targets) {
                        this.comprehension.traverseFeature((EMFVisitor)this.visitor, (EObject)this.source, this.derivedFeature, target);
                    }
                    if (this.currentValue instanceof Collection && this.oldValue instanceof Collection) {
                        ((Collection)this.oldValue).removeAll((Collection)this.currentValue);
                        if (((Collection)this.oldValue).size() > 0) {
                            this.sendRemoveManyNotification((EObject)this.source, this.derivedFeature, this.oldValue);
                        }
                    }
                } else {
                    Object target = this.source.eGet(this.derivedFeature);
                    this.comprehension.traverseFeature((EMFVisitor)this.visitor, (EObject)this.source, this.derivedFeature, target);
                }
            }
        }
        catch (Exception ex) {
            IncQueryLoggingUtil.getDefaultLogger().error((Object)("The derived feature adapter encountered an error in processing the EMF model. This happened while maintaining the derived feature " + this.derivedFeature.getName() + " of object " + this.source), (Throwable)ex);
        }
    }

    private void sendSetNotification(EObject source, EStructuralFeature feature, Object oldTarget, Object target) {
        source.eNotify((Notification)new ENotificationImpl((InternalEObject)source, 1, feature, oldTarget, target));
    }

    private void sendAddNotification(EObject source, EStructuralFeature feature, Object target) {
        source.eNotify((Notification)new ENotificationImpl((InternalEObject)source, 3, feature, null, target));
    }

    private void sendRemoveManyNotification(EObject source, EStructuralFeature feature, Object oldTarget) {
        source.eNotify((Notification)new ENotificationImpl((InternalEObject)source, 6, feature, oldTarget, null));
    }

    private void sendNotificationForEReference(EObject source, EReference feature, EObject target) {
        if (feature.isMany() && this.oldValue instanceof Collection && this.currentValue instanceof Collection) {
            if (!((Collection)this.oldValue).contains(target)) {
                this.sendAddNotification(source, (EStructuralFeature)feature, target);
            }
            ((Collection)this.currentValue).add(target);
        } else {
            this.sendSetNotification(source, (EStructuralFeature)feature, this.currentValue, target);
        }
    }

    private void storeSingleValue(EAttribute feature, Object target) {
        if (feature.isChangeable()) {
            if (target instanceof EObject) {
                this.currentValue = EcoreUtil.copy((EObject)((EObject)target));
            }
        } else {
            this.currentValue = target;
        }
    }

    private class DependentFeaturePath {
        private EStructuralFeature dependantFeature = null;
        private EStructuralFeature navigationFeature = null;
        private final AdapterImpl dependantAdapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getFeature().equals(DependentFeaturePath.this.dependantFeature)) {
                    DerivedFeatureAdapter.this.refreshDerivedFeature();
                }
            }
        };

        public DependentFeaturePath(EStructuralFeature navigationFeature, EStructuralFeature dependantFeature) {
            this.dependantFeature = dependantFeature;
            this.navigationFeature = navigationFeature;
        }

        public AdapterImpl getDependantAdapter() {
            return this.dependantAdapter;
        }

        public EStructuralFeature getDependantFeature() {
            return this.dependantFeature;
        }

        public EStructuralFeature getNavigationFeature() {
            return this.navigationFeature;
        }
    }

    protected class DerivedFeatureEMFVisitor
    extends EMFVisitor {
        public DerivedFeatureEMFVisitor() {
            super(true);
        }

        public void visitAttribute(EObject source, EAttribute feature, Object target) {
            DerivedFeatureAdapter.this.sendSetNotification(source, (EStructuralFeature)feature, DerivedFeatureAdapter.this.currentValue, target);
            DerivedFeatureAdapter.this.storeSingleValue(feature, target);
        }

        public void visitElement(EObject source) {
        }

        public void visitNonContainmentReference(EObject source, EReference feature, EObject target) {
            DerivedFeatureAdapter.this.sendNotificationForEReference(source, feature, target);
        }

        public void visitInternalContainment(EObject source, EReference feature, EObject target) {
            DerivedFeatureAdapter.this.sendNotificationForEReference(source, feature, target);
        }

        public boolean pruneSubtrees(EObject source) {
            return true;
        }
    }
}

