/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.incquery.databinding.runtime.collection.ObservablePatternMatchList;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.evm.api.RuleEngine;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.extensibility.QuerySpecificationRegistry;

public class ViewerDataFilter {
    public static ViewerDataFilter UNFILTERED = new ViewerDataFilter();
    private Map<Pattern, IPatternMatch> filterDefinitions;

    public ViewerDataFilter() {
        this.filterDefinitions = Maps.newHashMap();
    }

    public ViewerDataFilter(Map<Pattern, IPatternMatch> filters) {
        this.filterDefinitions = Maps.newHashMap(filters);
    }

    public static ViewerDataFilter cloneFilter(ViewerDataFilter other) {
        return new ViewerDataFilter(other.filterDefinitions);
    }

    public void addFilter(Pattern pattern, IPatternMatch match) {
        Preconditions.checkArgument((!this.filterDefinitions.containsKey(pattern) ? 1 : 0) != 0, (Object)("Filter already defined for pattern " + pattern.getName()));
        this.filterDefinitions.put(pattern, match);
    }

    public void removeFilter(Pattern pattern) {
        Preconditions.checkArgument((boolean)this.filterDefinitions.containsKey(pattern), (Object)("Filter undefined for pattern " + pattern.getName()));
        this.filterDefinitions.remove(pattern);
    }

    public boolean isFiltered(Pattern pattern) {
        return this.filterDefinitions.containsKey(pattern);
    }

    public IPatternMatch getFilter(Pattern pattern) {
        return this.filterDefinitions.get(pattern);
    }

    public MatchList<IPatternMatch> getObservableList(Pattern pattern, RuleEngine engine) {
        IQuerySpecification querySpecification = QuerySpecificationRegistry.getOrCreateQuerySpecification((Pattern)pattern);
        MatchList<IPatternMatch> obslist = this.isFiltered(pattern) ? new MatchList<IPatternMatch>(querySpecification, engine, this.getFilter(pattern)) : new MatchList(querySpecification, engine);
        return obslist;
    }

    static final class MatchList<Match extends IPatternMatch>
    extends ObservablePatternMatchList<Match> {
        public <Matcher extends IncQueryMatcher<Match>> MatchList(IQuerySpecification<Matcher> querySpecification, RuleEngine engine, Match filter) {
            super(querySpecification, engine, filter);
        }

        public <Matcher extends IncQueryMatcher<Match>> MatchList(IQuerySpecification<Matcher> querySpecification, RuleEngine engine) {
            super(querySpecification, engine);
        }

        public RuleSpecification<Match> getSpecification() {
            return super.getSpecification();
        }
    }
}

