/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.notification;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.incquery.runtime.evm.notification.IAttributeMonitorListener;

public abstract class AttributeMonitor<Atom> {
    private List<IAttributeMonitorListener<Atom>> listeners = new ArrayList<IAttributeMonitorListener<Atom>>();

    public void addAttributeMonitorListener(IAttributeMonitorListener<Atom> listener) {
        this.listeners.add(listener);
    }

    public void removeAttributeMonitorListener(IAttributeMonitorListener<Atom> listener) {
        this.listeners.remove(listener);
    }

    public abstract void registerFor(Atom var1);

    public abstract void unregisterForAll();

    public abstract void unregisterFor(Atom var1);

    protected void notifyListeners(Atom atom) {
        for (IAttributeMonitorListener<Atom> listener : this.listeners) {
            listener.notifyUpdate(atom);
        }
    }

    public void dispose() {
        this.unregisterForAll();
    }
}

