/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.index;

import java.util.Collection;
import org.eclipse.incquery.runtime.rete.index.DualInputNode;
import org.eclipse.incquery.runtime.rete.index.Indexer;
import org.eclipse.incquery.runtime.rete.index.IterableIndexer;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.tuple.Tuple;

public class ExistenceNode
extends DualInputNode {
    protected boolean negative;

    public ExistenceNode(ReteContainer reteContainer, IterableIndexer primarySlot, Indexer secondarySlot, boolean negative) {
        super(reteContainer, primarySlot, secondarySlot, null);
        this.negative = negative;
    }

    @Override
    public Tuple calibrate(Tuple primary, Tuple secondary) {
        return primary;
    }

    @Override
    public void notifyUpdate(DualInputNode.Side side, Direction direction, Tuple updateElement, Tuple signature, boolean change) {
        switch (side) {
            case PRIMARY: {
                if (!(this.retrieveOpposites(side, signature) != null ^ this.negative)) break;
                this.propagateUpdate(direction, updateElement);
                break;
            }
            case SECONDARY: {
                Collection<Tuple> opposites;
                if (!change || (opposites = this.retrieveOpposites(side, signature)) == null) break;
                for (Tuple opposite : opposites) {
                    this.propagateUpdate(this.negative ? direction.opposite() : direction, opposite);
                }
                break;
            }
            case BOTH: {
                if (this.negative) break;
                this.propagateUpdate(direction, updateElement);
            }
        }
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        this.reteContainer.flushUpdates();
        for (Tuple signature : this.primarySlot.getSignatures()) {
            Collection<Tuple> primaries = this.primarySlot.get(signature);
            Collection<Tuple> opposites = this.secondarySlot.get(signature);
            if (!(opposites != null ^ this.negative)) continue;
            collector.addAll(primaries);
        }
    }
}

