/**
 * Copyright (c) 2011 Zoltan Ujhelyi, Mark Czotter, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Zoltan Ujhelyi, Mark Czotter - initial API and implementation
 *    Andras Okros - minor changes
 */
package org.eclipse.incquery.patternlanguage.emf.jvmmodel;

import com.google.inject.Inject;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.emf.jvmmodel.JavadocInferrer;
import org.eclipse.incquery.patternlanguage.emf.jvmmodel.PatternGroupClassInferrer;
import org.eclipse.incquery.patternlanguage.emf.jvmmodel.PatternMatchClassInferrer;
import org.eclipse.incquery.patternlanguage.emf.jvmmodel.PatternMatchProcessorClassInferrer;
import org.eclipse.incquery.patternlanguage.emf.jvmmodel.PatternMatcherClassInferrer;
import org.eclipse.incquery.patternlanguage.emf.jvmmodel.PatternMatcherClassMethodInferrer;
import org.eclipse.incquery.patternlanguage.emf.jvmmodel.PatternQuerySpecificationClassInferrer;
import org.eclipse.incquery.patternlanguage.emf.specification.SpecificationBuilder;
import org.eclipse.incquery.patternlanguage.emf.util.EMFJvmTypesBuilder;
import org.eclipse.incquery.patternlanguage.emf.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.incquery.patternlanguage.emf.util.IErrorFeedback;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.AbstractModelInferrer;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociator;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * <p>Infers a JVM model from the source model.</p>
 * 
 * <p>The JVM model should contain all elements that would appear in the Java code
 * which is generated from the source model. Other models link against the JVM model rather than the source model.</p>
 */
@SuppressWarnings("all")
public class EMFPatternLanguageJvmModelInferrer extends AbstractModelInferrer {
  private final static String JVM_MODEL_INFERRER_PREFIX = "org.eclipse.incquery.patternlanguage.emf.inferrer";
  
  public final static String INVALID_PATTERN_MODEL_CODE = (EMFPatternLanguageJvmModelInferrer.JVM_MODEL_INFERRER_PREFIX + ".invalid.patternmodel");
  
  public final static String INVALID_TYPEREF_CODE = (EMFPatternLanguageJvmModelInferrer.JVM_MODEL_INFERRER_PREFIX + ".invalid.typeref");
  
  public final static String SPECIFICATION_BUILDER_CODE = (EMFPatternLanguageJvmModelInferrer.JVM_MODEL_INFERRER_PREFIX + ".specification.builder");
  
  @Inject
  private Logger logger;
  
  @Inject
  private IErrorFeedback errorFeedback;
  
  /**
   * convenience API to build and initialize JvmTypes and their members.
   */
  @Inject
  @Extension
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  @Extension
  private PatternMatchClassInferrer _patternMatchClassInferrer;
  
  @Inject
  @Extension
  private PatternMatcherClassInferrer _patternMatcherClassInferrer;
  
  @Inject
  @Extension
  private PatternMatcherClassMethodInferrer _patternMatcherClassMethodInferrer;
  
  @Inject
  @Extension
  private PatternQuerySpecificationClassInferrer _patternQuerySpecificationClassInferrer;
  
  @Inject
  @Extension
  private PatternMatchProcessorClassInferrer _patternMatchProcessorClassInferrer;
  
  @Inject
  @Extension
  private PatternGroupClassInferrer _patternGroupClassInferrer;
  
  @Inject
  @Extension
  private JavadocInferrer _javadocInferrer;
  
  @Inject
  @Extension
  private TypeReferences _typeReferences;
  
  @Inject
  @Extension
  private IJvmModelAssociator associator;
  
  /**
   * Is called for each Pattern instance in a resource.
   * 
   * @param pattern - the model to create one or more JvmDeclaredTypes from.
   * @param acceptor - each created JvmDeclaredType without a container should be passed to the acceptor in order get attached to the
   *                   current resource.
   * @param isPreLinkingPhase - whether the method is called in a pre linking phase, i.e. when the global index isn't fully updated. You
   *        must not rely on linking using the index if iPrelinkingPhase is <code>true</code>
   */
  public void infer(final Pattern pattern, final IJvmDeclaredTypeAcceptor acceptor, final SpecificationBuilder builder, final boolean isPrelinkingPhase) {
    boolean _isPrivate = CorePatternLanguageHelper.isPrivate(pattern);
    final boolean isPublic = (!_isPrivate);
    try {
      boolean _and = false;
      String _name = pattern.getName();
      boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(_name);
      boolean _not = (!_isNullOrEmpty);
      if (!_not) {
        _and = false;
      } else {
        _and = isPublic;
      }
      if (_and) {
        this.inferPublic(pattern, acceptor, builder, isPrelinkingPhase);
      } else {
        String _name_1 = pattern.getName();
        boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty(_name_1);
        boolean _not_1 = (!_isNullOrEmpty_1);
        if (_not_1) {
          this.inferPrivate(pattern, acceptor, builder, isPrelinkingPhase);
        }
      }
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        this.logger.error(("Exception during Jvm Model Infer for: " + pattern), e);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  public void inferPublic(final Pattern pattern, final IJvmDeclaredTypeAcceptor acceptor, final SpecificationBuilder builder, final boolean isPrelinkingPhase) {
    String _name = pattern.getName();
    String _plus = ("Inferring Jvm Model for pattern" + _name);
    this.logger.debug(_plus);
    final String packageName = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
    final String utilPackageName = this._eMFPatternLanguageJvmModelInferrerUtil.getUtilPackageName(pattern);
    String _matchClassName = this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
    final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
      public void apply(final JvmGenericType it) {
        it.setPackageName(packageName);
        EList<JvmTypeReference> _superTypes = it.getSuperTypes();
        JvmTypeReference _newTypeRef = EMFPatternLanguageJvmModelInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, BasePatternMatch.class);
        EMFPatternLanguageJvmModelInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _newTypeRef);
      }
    };
    final JvmGenericType matchClass = this._eMFJvmTypesBuilder.toClass(pattern, _matchClassName, _function);
    final JvmParameterizedTypeReference matchClassRef = this._typeReferences.createTypeRef(matchClass);
    String _matcherClassName = this._eMFPatternLanguageJvmModelInferrerUtil.matcherClassName(pattern);
    final Procedure1<JvmGenericType> _function_1 = new Procedure1<JvmGenericType>() {
      public void apply(final JvmGenericType it) {
        it.setPackageName(packageName);
        EList<JvmTypeReference> _superTypes = it.getSuperTypes();
        JvmTypeReference _cloneWithProxies = EMFPatternLanguageJvmModelInferrer.this._eMFJvmTypesBuilder.cloneWithProxies(matchClassRef);
        JvmTypeReference _newTypeRef = EMFPatternLanguageJvmModelInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, BaseMatcher.class, _cloneWithProxies);
        EMFPatternLanguageJvmModelInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _newTypeRef);
      }
    };
    final JvmGenericType matcherClass = this._eMFJvmTypesBuilder.toClass(pattern, _matcherClassName, _function_1);
    final JvmParameterizedTypeReference matcherClassRef = this._typeReferences.createTypeRef(matcherClass);
    final JvmDeclaredType querySpecificationClass = this._patternQuerySpecificationClassInferrer.inferQuerySpecificationClass(pattern, isPrelinkingPhase, utilPackageName, matcherClassRef);
    final JvmParameterizedTypeReference querySpecificationClassRef = this._typeReferences.createTypeRef(querySpecificationClass);
    final JvmDeclaredType processorClass = this._patternMatchProcessorClassInferrer.inferProcessorClass(pattern, isPrelinkingPhase, utilPackageName, matchClassRef);
    IJvmDeclaredTypeAcceptor.IPostIndexingInitializing<JvmDeclaredType> _accept = acceptor.<JvmDeclaredType>accept(querySpecificationClass);
    final Procedure1<JvmDeclaredType> _function_2 = new Procedure1<JvmDeclaredType>() {
      public void apply(final JvmDeclaredType it) {
        EMFPatternLanguageJvmModelInferrer.this._patternQuerySpecificationClassInferrer.initializePublicSpecification(it, pattern, matcherClassRef, matchClassRef, builder);
      }
    };
    _accept.initializeLater(_function_2);
    IJvmDeclaredTypeAcceptor.IPostIndexingInitializing<JvmDeclaredType> _accept_1 = acceptor.<JvmDeclaredType>accept(processorClass);
    final Procedure1<JvmDeclaredType> _function_3 = new Procedure1<JvmDeclaredType>() {
      public void apply(final JvmDeclaredType it) {
        EMFPatternLanguageJvmModelInferrer.this._patternMatchProcessorClassInferrer.inferProcessorClassMethods(processorClass, pattern, matchClassRef);
      }
    };
    _accept_1.initializeLater(_function_3);
    IJvmDeclaredTypeAcceptor.IPostIndexingInitializing<JvmGenericType> _accept_2 = acceptor.<JvmGenericType>accept(matchClass);
    final Procedure1<JvmGenericType> _function_4 = new Procedure1<JvmGenericType>() {
      public void apply(final JvmGenericType it) {
        CharSequence _javadocMatchClass = EMFPatternLanguageJvmModelInferrer.this._javadocInferrer.javadocMatchClass(pattern);
        String _string = _javadocMatchClass.toString();
        EMFPatternLanguageJvmModelInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
        it.setAbstract(true);
        EMFPatternLanguageJvmModelInferrer.this._patternMatchClassInferrer.inferMatchClassFields(it, pattern);
        EMFPatternLanguageJvmModelInferrer.this._patternMatchClassInferrer.inferMatchClassConstructors(it, pattern);
        EMFPatternLanguageJvmModelInferrer.this._patternMatchClassInferrer.inferMatchClassGetters(it, pattern);
        EMFPatternLanguageJvmModelInferrer.this._patternMatchClassInferrer.inferMatchClassSetters(it, pattern);
        EMFPatternLanguageJvmModelInferrer.this._patternMatchClassInferrer.inferMatchClassMethods(it, pattern, querySpecificationClassRef);
        EMFPatternLanguageJvmModelInferrer.this._patternMatchClassInferrer.inferMatchInnerClasses(it, pattern);
      }
    };
    _accept_2.initializeLater(_function_4);
    IJvmDeclaredTypeAcceptor.IPostIndexingInitializing<JvmGenericType> _accept_3 = acceptor.<JvmGenericType>accept(matcherClass);
    final Procedure1<JvmGenericType> _function_5 = new Procedure1<JvmGenericType>() {
      public void apply(final JvmGenericType it) {
        CharSequence _javadocMatcherClass = EMFPatternLanguageJvmModelInferrer.this._javadocInferrer.javadocMatcherClass(pattern);
        String _string = _javadocMatcherClass.toString();
        EMFPatternLanguageJvmModelInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
        EMFPatternLanguageJvmModelInferrer.this._patternMatcherClassInferrer.inferStaticMethods(it, pattern, matcherClass);
        EMFPatternLanguageJvmModelInferrer.this._patternMatcherClassInferrer.inferFields(it, pattern);
        EMFPatternLanguageJvmModelInferrer.this._patternMatcherClassInferrer.inferConstructors(it, pattern);
        EMFPatternLanguageJvmModelInferrer.this._patternMatcherClassMethodInferrer.inferMethods(it, pattern, matchClassRef);
      }
    };
    _accept_3.initializeLater(_function_5);
    EList<JvmMember> _members = matcherClass.getMembers();
    JvmTypeReference _cloneWithProxies = this._eMFJvmTypesBuilder.cloneWithProxies(matcherClassRef);
    JvmTypeReference _newTypeRef = this._eMFJvmTypesBuilder.newTypeRef(pattern, IQuerySpecification.class, _cloneWithProxies);
    final Procedure1<JvmOperation> _function_6 = new Procedure1<JvmOperation>() {
      public void apply(final JvmOperation it) {
        it.setVisibility(JvmVisibility.PUBLIC);
        it.setStatic(true);
        CharSequence _javadocQuerySpecificationMethod = EMFPatternLanguageJvmModelInferrer.this._javadocInferrer.javadocQuerySpecificationMethod(pattern);
        String _string = _javadocQuerySpecificationMethod.toString();
        EMFPatternLanguageJvmModelInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
        EList<JvmTypeReference> _exceptions = it.getExceptions();
        JvmTypeReference _newTypeRef = EMFPatternLanguageJvmModelInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IncQueryException.class);
        EMFPatternLanguageJvmModelInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _newTypeRef);
        final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
          public void apply(final ITreeAppendable it) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("return ");
            it.append(_builder);
            EMFPatternLanguageJvmModelInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.serialize(it, querySpecificationClassRef, pattern);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(".instance();");
            it.append(_builder_1);
          }
        };
        EMFPatternLanguageJvmModelInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
      }
    };
    JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(matcherClass, "querySpecification", _newTypeRef, _function_6);
    this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
    this.associator.associatePrimary(pattern, matcherClass);
    this.associator.associate(pattern, matcherClass);
    this.associator.associate(pattern, querySpecificationClass);
    this.associator.associate(pattern, processorClass);
  }
  
  public void inferPrivate(final Pattern pattern, final IJvmDeclaredTypeAcceptor acceptor, final SpecificationBuilder builder, final boolean isPrelinkingPhase) {
    String _name = pattern.getName();
    String _plus = ("Inferring Jvm Model for private pattern " + _name);
    this.logger.debug(_plus);
    final String utilPackageName = this._eMFPatternLanguageJvmModelInferrerUtil.getUtilPackageName(pattern);
    JvmTypeReference _typeForName = this._typeReferences.getTypeForName(IPatternMatch.class, pattern);
    final JvmTypeReference matcherClassRef = this._typeReferences.getTypeForName(IncQueryMatcher.class, pattern, _typeForName);
    final JvmDeclaredType querySpecificationClass = this._patternQuerySpecificationClassInferrer.inferQuerySpecificationClass(pattern, isPrelinkingPhase, utilPackageName, matcherClassRef);
    this.associator.associatePrimary(pattern, querySpecificationClass);
    IJvmDeclaredTypeAcceptor.IPostIndexingInitializing<JvmDeclaredType> _accept = acceptor.<JvmDeclaredType>accept(querySpecificationClass);
    final Procedure1<JvmDeclaredType> _function = new Procedure1<JvmDeclaredType>() {
      public void apply(final JvmDeclaredType it) {
        EMFPatternLanguageJvmModelInferrer.this._patternQuerySpecificationClassInferrer.initializePrivateSpecification(it, pattern, matcherClassRef, null, builder);
      }
    };
    _accept.initializeLater(_function);
  }
  
  /**
   * Is called for each Pattern instance in a resource.
   * 
   * @param pattern - the model to create one or more JvmDeclaredTypes from.
   * @param acceptor - each created JvmDeclaredType without a container should be passed to the acceptor in order get attached to the
   *                   current resource.
   * @param isPreLinkingPhase - whether the method is called in a pre linking phase, i.e. when the global index isn't fully updated. You
   *        must not rely on linking using the index if iPrelinkingPhase is <code>true</code>
   */
  protected void _infer(final PatternModel model, final IJvmDeclaredTypeAcceptor acceptor, final boolean isPrelinkingPhase) {
    try {
      final SpecificationBuilder builder = new SpecificationBuilder();
      final JvmGenericType groupClass = this._patternGroupClassInferrer.inferPatternGroupClass(model);
      EList<Pattern> _patterns = model.getPatterns();
      for (final Pattern pattern : _patterns) {
        this.infer(pattern, acceptor, builder, isPrelinkingPhase);
      }
      IJvmDeclaredTypeAcceptor.IPostIndexingInitializing<JvmGenericType> _accept = acceptor.<JvmGenericType>accept(groupClass);
      final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
        public void apply(final JvmGenericType it) {
          EMFPatternLanguageJvmModelInferrer.this._patternGroupClassInferrer.initializePatternGroup(it, model);
        }
      };
      _accept.initializeLater(_function);
      String _modelFileName = this._eMFPatternLanguageJvmModelInferrerUtil.modelFileName(model);
      String _plus = ("Inferring Jvm Model for Pattern model " + _modelFileName);
      this.logger.debug(_plus);
      this.associator.associatePrimary(model, groupClass);
    } catch (final Throwable _t) {
      if (_t instanceof IllegalArgumentException) {
        final IllegalArgumentException e = (IllegalArgumentException)_t;
        String _message = e.getMessage();
        this.errorFeedback.reportErrorNoLocation(model, _message, EMFPatternLanguageJvmModelInferrer.INVALID_PATTERN_MODEL_CODE, Severity.ERROR, IErrorFeedback.JVMINFERENCE_ERROR_TYPE);
      } else if (_t instanceof Exception) {
        final Exception e_1 = (Exception)_t;
        this.logger.error(("Exception during Jvm Model Infer for pattern model: " + model), e_1);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  public void infer(final EObject model, final IJvmDeclaredTypeAcceptor acceptor, final boolean isPrelinkingPhase) {
    if (model instanceof PatternModel) {
      _infer((PatternModel)model, acceptor, isPrelinkingPhase);
      return;
    } else if (model != null) {
      _infer(model, acceptor, isPrelinkingPhase);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(model, acceptor, isPrelinkingPhase).toString());
    }
  }
}
