/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.databinding.runtime.adapter;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.incquery.databinding.runtime.adapter.DatabindingAdapter;
import org.eclipse.incquery.databinding.runtime.adapter.DatabindingAdapterUtil;
import org.eclipse.incquery.databinding.runtime.adapter.ObservableDefinition;
import org.eclipse.incquery.databinding.runtime.api.IncQueryObservables;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IPatternMatch;

public class GenericDatabindingAdapter
extends DatabindingAdapter<IPatternMatch> {
    private final Map<String, ObservableDefinition> parameterMap;

    public GenericDatabindingAdapter(Pattern pattern) {
        this.parameterMap = DatabindingAdapterUtil.calculateObservableValues(pattern);
    }

    @Override
    public String[] getParameterNames() {
        return this.parameterMap.keySet().toArray(new String[this.parameterMap.keySet().size()]);
    }

    @Override
    public IObservableValue getObservableParameter(IPatternMatch match, String parameterName) {
        if (this.parameterMap.size() > 0) {
            ObservableDefinition def = this.parameterMap.get(parameterName);
            String expression = def.getExpression();
            switch (def.getType()) {
                case OBSERVABLE_FEATURE: {
                    return IncQueryObservables.getObservableValue(match, expression);
                }
                case OBSERVABLE_LABEL: {
                    return IncQueryObservables.getObservableLabelFeature(match, expression);
                }
            }
        }
        return null;
    }

    public IValueProperty getProperty(String parameterName) {
        Preconditions.checkArgument((boolean)this.parameterMap.containsKey(parameterName), (Object)"Invalid parameter name");
        ObservableDefinition def = this.parameterMap.get(parameterName);
        switch (def.getType()) {
            case OBSERVABLE_FEATURE: {
                return new DatabindingAdapter.MatcherProperty(this, def.getExpression());
            }
            case OBSERVABLE_LABEL: {
                return new DatabindingAdapter.MatcherLabelProperty(this, def.getExpression());
            }
        }
        return null;
    }
}

