/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.index;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.incquery.runtime.matchers.tuple.LeftInheritanceTuple;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.matchers.tuple.TupleMask;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.index.DefaultIndexerListener;
import org.eclipse.incquery.runtime.rete.index.ProjectionIndexer;
import org.eclipse.incquery.runtime.rete.index.StandardIndexer;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.Node;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.network.StandardNode;
import org.eclipse.incquery.runtime.rete.traceability.TraceInfo;

public abstract class AggregatorNode
extends StandardNode {
    ProjectionIndexer projection;
    AggregatorNode me = this;
    int sourceWidth;
    Map<Tuple, Object> mainAggregates = CollectionsFactory.getMap();
    AggregatorOuterIndexer aggregatorOuterIndexer = null;
    AggregatorOuterIdentityIndexer[] aggregatorOuterIdentityIndexers = null;

    public AggregatorNode(ReteContainer reteContainer) {
        super(reteContainer);
    }

    public void initializeWith(ProjectionIndexer projection) {
        this.projection = projection;
        this.sourceWidth = projection.getMask().indices.length;
        for (Tuple signature : projection.getSignatures()) {
            this.mainAggregates.put(signature, this.aggregateGroup(signature, projection.get(signature)));
        }
        projection.attachListener(new DefaultIndexerListener(this){

            @Override
            public void notifyIndexerUpdate(Direction direction, Tuple updateElement, Tuple signature, boolean change) {
                AggregatorNode.this.aggregateUpdate(direction, updateElement, signature, change);
            }
        });
    }

    public abstract Object aggregateGroup(Tuple var1, Collection<Tuple> var2);

    public Object aggregateGroupAfterUpdate(Tuple signature, Collection<Tuple> currentGroup, Object oldAggregate, Direction direction, Tuple updateElement, boolean change) {
        return this.aggregateGroup(signature, currentGroup);
    }

    protected Tuple aggregateAndPack(Tuple signature, Collection<Tuple> group) {
        return this.packResult(signature, this.aggregateGroup(signature, group));
    }

    public AggregatorOuterIndexer getAggregatorOuterIndexer() {
        if (this.aggregatorOuterIndexer == null) {
            this.aggregatorOuterIndexer = new AggregatorOuterIndexer();
        }
        return this.aggregatorOuterIndexer;
    }

    public AggregatorOuterIdentityIndexer getAggregatorOuterIdentityIndexer(int resultPositionInSignature) {
        if (this.aggregatorOuterIdentityIndexers == null) {
            this.aggregatorOuterIdentityIndexers = new AggregatorOuterIdentityIndexer[this.sourceWidth + 1];
        }
        if (this.aggregatorOuterIdentityIndexers[resultPositionInSignature] == null) {
            this.aggregatorOuterIdentityIndexers[resultPositionInSignature] = new AggregatorOuterIdentityIndexer(resultPositionInSignature);
        }
        return this.aggregatorOuterIdentityIndexers[resultPositionInSignature];
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        for (Tuple signature : this.mainAggregates.keySet()) {
            collector.add(this.packResult(signature, this.mainAggregates.get(signature)));
        }
    }

    protected Tuple packResult(Tuple signature, Object result) {
        Object[] resultArray = new Object[]{result};
        return new LeftInheritanceTuple(signature, resultArray);
    }

    protected void aggregateUpdate(Direction direction, Tuple updateElement, Tuple signature, boolean change) {
        Object newAggregate;
        Collection<Tuple> currentGroup = this.projection.get(signature);
        Object oldAggregate = this.mainAggregates.get(signature);
        Object safeOldAggregate = oldAggregate == null ? this.aggregateGroup(signature, null) : oldAggregate;
        boolean empty = currentGroup == null || currentGroup.isEmpty();
        Object object = newAggregate = empty ? null : this.aggregateGroupAfterUpdate(signature, currentGroup, safeOldAggregate, direction, updateElement, change);
        if (!empty) {
            this.mainAggregates.put(signature, newAggregate);
        } else {
            this.mainAggregates.remove(signature);
        }
        Tuple oldTuple = this.packResult(signature, safeOldAggregate);
        Tuple newTuple = this.packResult(signature, newAggregate == null ? this.aggregateGroup(signature, null) : newAggregate);
        if (oldAggregate != null) {
            this.propagateUpdate(Direction.REVOKE, oldTuple);
        }
        if (newAggregate != null) {
            this.propagateUpdate(Direction.INSERT, newTuple);
        }
        if (this.aggregatorOuterIndexer != null) {
            this.aggregatorOuterIndexer.propagate(signature, oldTuple, newTuple);
        }
        if (this.aggregatorOuterIdentityIndexers != null) {
            AggregatorOuterIdentityIndexer[] aggregatorOuterIdentityIndexerArray = this.aggregatorOuterIdentityIndexers;
            int n = this.aggregatorOuterIdentityIndexers.length;
            int n2 = 0;
            while (n2 < n) {
                AggregatorOuterIdentityIndexer aggregatorOuterIdentityIndexer = aggregatorOuterIdentityIndexerArray[n2];
                if (aggregatorOuterIdentityIndexer != null) {
                    aggregatorOuterIdentityIndexer.propagate(signature, oldTuple, newTuple);
                }
                ++n2;
            }
        }
    }

    private Object getAggregate(Tuple signature) {
        Object aggregate = this.mainAggregates.get(signature);
        return aggregate == null ? this.aggregateGroup(signature, null) : aggregate;
    }

    @Override
    public void assignTraceInfo(TraceInfo traceInfo) {
        super.assignTraceInfo(traceInfo);
        if (traceInfo.propagateToIndexerParent() && this.projection != null) {
            this.projection.acceptPropagatedTraceInfo(traceInfo);
        }
    }

    class AggregatorOuterIdentityIndexer
    extends StandardIndexer {
        int resultPositionInSignature;
        TupleMask pruneResult;
        TupleMask reorder;

        public AggregatorOuterIdentityIndexer(int resultPositionInSignature) {
            super(AggregatorNode.this.me.reteContainer, TupleMask.displace((int)AggregatorNode.this.sourceWidth, (int)resultPositionInSignature, (int)(AggregatorNode.this.sourceWidth + 1)));
            this.parent = AggregatorNode.this.me;
            this.resultPositionInSignature = resultPositionInSignature;
            this.pruneResult = TupleMask.omit((int)resultPositionInSignature, (int)(AggregatorNode.this.sourceWidth + 1));
            this.reorder = resultPositionInSignature == AggregatorNode.this.sourceWidth ? null : this.mask;
        }

        @Override
        public Collection<Tuple> get(Tuple signatureWithResult) {
            Tuple prunedSignature = this.pruneResult.transform(signatureWithResult);
            Object result = AggregatorNode.this.getAggregate(prunedSignature);
            if (signatureWithResult.get(this.resultPositionInSignature).equals(result)) {
                return Collections.singleton(signatureWithResult);
            }
            return null;
        }

        public void propagate(Tuple signature, Tuple oldTuple, Tuple newTuple) {
            this.propagate(Direction.INSERT, this.reorder(newTuple), signature, true);
            this.propagate(Direction.REVOKE, this.reorder(oldTuple), signature, true);
        }

        private Tuple reorder(Tuple signatureWithResult) {
            Tuple transformed = this.reorder == null ? signatureWithResult : this.reorder.transform(signatureWithResult);
            return transformed;
        }

        @Override
        public Node getActiveNode() {
            return AggregatorNode.this.projection.getActiveNode();
        }
    }

    class AggregatorOuterIndexer
    extends StandardIndexer {
        public AggregatorOuterIndexer() {
            super(AggregatorNode.this.me.reteContainer, TupleMask.omit((int)AggregatorNode.this.sourceWidth, (int)(AggregatorNode.this.sourceWidth + 1)));
            this.parent = AggregatorNode.this.me;
        }

        @Override
        public Collection<Tuple> get(Tuple signature) {
            return Collections.singleton(AggregatorNode.this.packResult(signature, AggregatorNode.this.getAggregate(signature)));
        }

        public void propagate(Tuple signature, Tuple oldTuple, Tuple newTuple) {
            this.propagate(Direction.INSERT, newTuple, signature, false);
            this.propagate(Direction.REVOKE, oldTuple, signature, false);
        }

        @Override
        public Node getActiveNode() {
            return AggregatorNode.this.projection.getActiveNode();
        }
    }
}

