/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.extensions.jface;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.viewers.runtime.IncQueryViewerSupport;
import org.eclipse.incquery.viewers.runtime.extensions.IncQueryViewersViewSupport;
import org.eclipse.incquery.viewers.runtime.extensions.SelectionHelper;
import org.eclipse.incquery.viewers.runtime.extensions.ViewersComponentConfiguration;
import org.eclipse.incquery.viewers.runtime.model.IncQueryViewerDataModel;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IViewPart;

public class IncQueryViewersJFaceViewSupport
extends IncQueryViewersViewSupport
implements ISelectionProvider {
    protected StructuredViewer jfaceViewer;
    SelectionHelper selectionHelper = new SelectionHelper();

    public IncQueryViewersJFaceViewSupport(IViewPart _owner, ViewersComponentConfiguration _config, IModelConnectorTypeEnum _scope, StructuredViewer _jfaceViewer) {
        super(_owner, _config, _scope);
        this.jfaceViewer = _jfaceViewer;
    }

    @Override
    protected void init() {
        super.init();
        this.jfaceViewer.addSelectionChangedListener(this.selectionHelper.trickyListener);
    }

    @Override
    public void dispose() {
        this.jfaceViewer.removeSelectionChangedListener(this.selectionHelper.trickyListener);
        super.dispose();
    }

    @Override
    protected void bindModel() {
        IncQueryEngine engine;
        Assert.isNotNull((Object)this.configuration);
        Assert.isNotNull(this.configuration.getPatterns());
        if (this.state != null && !this.state.isDisposed()) {
            this.state.dispose();
        }
        if ((engine = this.getEngine()) != null) {
            this.configuration.setModel(engine.getEMFRoot());
            this.state = IncQueryViewerDataModel.newViewerState(engine, this.configuration.getPatterns(), this.configuration.getFilter(), (Collection<ViewerState.ViewerStateFeature>)ImmutableSet.of((Object)((Object)ViewerState.ViewerStateFeature.EDGE), (Object)((Object)ViewerState.ViewerStateFeature.CONTAINMENT)));
            if (this.jfaceViewer instanceof AbstractListViewer) {
                IncQueryViewerSupport.bind((AbstractListViewer)this.jfaceViewer, this.state);
            } else if (this.jfaceViewer instanceof AbstractTreeViewer) {
                IncQueryViewerSupport.bind((AbstractTreeViewer)this.jfaceViewer, this.state);
            }
        }
    }

    @Override
    protected void unbindModel() {
        if (this.jfaceViewer != null && this.jfaceViewer.getInput() != null) {
            this.jfaceViewer.setInput(null);
        }
        if (this.state != null && !this.state.isDisposed()) {
            this.state.dispose();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionHelper.selectionChangedListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selectionHelper.unwrapElements_ViewersElementsToEObjects(this.jfaceViewer.getSelection());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionHelper.selectionChangedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.jfaceViewer.setSelection(this.selectionHelper.unwrapElements_EObjectsToViewersElements(selection, this.state));
    }

    @Override
    protected void filteredSelectionChanged(List<Notifier> eObjects) {
        super.filteredSelectionChanged(eObjects);
        this.setSelection((ISelection)new StructuredSelection(eObjects));
    }
}

