/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.rewriters;

import java.util.List;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PBodyCopier;

public class FlattenerCopier
extends PBodyCopier {
    private List<PositivePatternCall> flattenedCalls;
    private List<PBody> calledBodies;

    public FlattenerCopier(PQuery query, List<PositivePatternCall> flattenedCalls, List<PBody> calledBodies) {
        super(query);
        this.flattenedCalls = flattenedCalls;
        this.calledBodies = calledBodies;
    }

    @Override
    protected void copyPositivePatternCallConstraint(PositivePatternCall positivePatternCall) {
        if (!this.flattenedCalls.contains(positivePatternCall)) {
            super.copyPositivePatternCallConstraint(positivePatternCall);
        } else {
            for (PBody calledBody : this.calledBodies) {
                if (!positivePatternCall.getReferredQuery().equals(calledBody.getPattern())) continue;
                List<ExportedParameter> symbolicParameters = calledBody.getSymbolicParameters();
                Object[] elements = positivePatternCall.getVariablesTuple().getElements();
                int i = 0;
                while (i < elements.length) {
                    this.createEqualityConstraint((PVariable)elements[i], symbolicParameters.get(i).getAffectedVariables().iterator().next());
                    ++i;
                }
            }
        }
    }

    private void createEqualityConstraint(PVariable pVariable1, PVariable pVariable2) {
        new Equality(this.body, (PVariable)this.variableMapping.get(pVariable1), (PVariable)this.variableMapping.get(pVariable2));
    }
}

