/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.spi.client.deployment;

import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentDescription {
    private String name;
    private boolean managed = true;
    private int order = 0;
    private boolean testable = true;
    private TargetDescription target = TargetDescription.DEFAULT;
    private ProtocolDescription protocol = ProtocolDescription.DEFAULT;
    private Archive<?> archive;
    private Descriptor descriptor;
    private Archive<?> testableArchive;
    private Class<? extends Exception> expectedException;

    public DeploymentDescription(String name, Archive<?> archive) {
        this(name);
        Validate.notNull(archive, "Archive must be specified");
        this.archive = archive;
    }

    public DeploymentDescription(String name, Descriptor descriptor) {
        this(name);
        Validate.notNull(descriptor, "Descriptor must be specified");
        this.descriptor = descriptor;
    }

    private DeploymentDescription(String name) {
        Validate.notNull(name, "Name must be specified");
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DeploymentDescription setOrder(int order) {
        this.order = order;
        return this;
    }

    public int getOrder() {
        return this.order;
    }

    public DeploymentDescription setTarget(TargetDescription target) {
        Validate.notNull(target, "TargetDescription must be specified");
        this.target = target;
        return this;
    }

    public TargetDescription getTarget() {
        return this.target;
    }

    public DeploymentDescription setProtocol(ProtocolDescription protocol) {
        this.protocol = protocol;
        return this;
    }

    public ProtocolDescription getProtocol() {
        return this.protocol;
    }

    public DeploymentDescription shouldBeManaged(boolean startup) {
        this.managed = startup;
        return this;
    }

    public boolean managed() {
        return this.managed;
    }

    public DeploymentDescription shouldBeTestable(boolean testable) {
        if (!this.isArchiveDeployment()) {
            throw new IllegalArgumentException("A non ArchiveDeployment can not be testable: " + this.getName());
        }
        this.testable = testable;
        return this;
    }

    public boolean testable() {
        return this.testable;
    }

    public Archive<?> getTestableArchive() {
        return this.testableArchive;
    }

    public DeploymentDescription setTestableArchive(Archive<?> testableArchive) {
        this.testableArchive = testableArchive;
        return this;
    }

    public Class<? extends Exception> getExpectedException() {
        return this.expectedException;
    }

    public DeploymentDescription setExpectedException(Class<? extends Exception> expectedException) {
        this.expectedException = expectedException;
        return this;
    }

    public Archive<?> getArchive() {
        return this.archive;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean isDescriptorDeployment() {
        return this.descriptor != null;
    }

    public boolean isArchiveDeployment() {
        return this.archive != null;
    }

    public String toString() {
        return this.getName();
    }
}

