/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Field;
import java.util.List;
import org.assertj.core.api.SoftProxies;
import org.assertj.core.internal.Failures;

public class AbstractSoftAssertions {
    protected final SoftProxies proxies = new SoftProxies();

    public <T, V> V proxy(Class<V> assertClass, Class<T> actualClass, T actual) {
        return this.proxies.create(assertClass, actualClass, actual);
    }

    public void fail(String failureMessage) {
        AssertionError error = Failures.instance().failure(failureMessage);
        this.proxies.collectError((Throwable)((Object)error));
    }

    public void fail(String failureMessage, Object ... args) {
        AssertionError error = Failures.instance().failure(String.format(failureMessage, args));
        this.proxies.collectError((Throwable)((Object)error));
    }

    public void fail(String failureMessage, Throwable realCause) {
        AssertionError error = Failures.instance().failure(failureMessage);
        ((Throwable)((Object)error)).initCause(realCause);
        this.proxies.collectError((Throwable)((Object)error));
    }

    public void failBecauseExceptionWasNotThrown(Class<? extends Throwable> throwableClass) {
        this.shouldHaveThrown(throwableClass);
    }

    public void shouldHaveThrown(Class<? extends Throwable> throwableClass) {
        AssertionError error = Failures.instance().expectedThrowableNotThrown(throwableClass);
        this.proxies.collectError((Throwable)((Object)error));
    }

    public List<Throwable> errorsCollected() {
        return this.addLineNumberToErrorMessages(this.proxies.errorsCollected());
    }

    public boolean wasSuccess() {
        return this.proxies.wasSuccess();
    }

    private List<Throwable> addLineNumberToErrorMessages(List<Throwable> errors) {
        for (Throwable error : errors) {
            this.addLineNumberToErrorMessage(error);
        }
        return errors;
    }

    private void addLineNumberToErrorMessage(Throwable error) {
        StackTraceElement testStackTraceElement = this.getFirstStackTraceElementFromTest(error.getStackTrace());
        if (testStackTraceElement != null) {
            this.changeErrorMessage(error, this.buildErrorMessageWithLineNumber(error.getMessage(), testStackTraceElement));
        }
    }

    private String buildErrorMessageWithLineNumber(String originalErrorMessage, StackTraceElement testStackTraceElement) {
        String testClassName = this.simpleClassNameOf(testStackTraceElement);
        String testName = testStackTraceElement.getMethodName();
        int lineNumber = testStackTraceElement.getLineNumber();
        return String.format("%s%nat %s.%s(%s.java:%s)", originalErrorMessage, testClassName, testName, testClassName, lineNumber);
    }

    private void changeErrorMessage(Throwable error, String errorMessageWithLineNumber) {
        try {
            Field field = Throwable.class.getDeclaredField("detailMessage");
            field.setAccessible(true);
            field.set(error, errorMessageWithLineNumber);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String simpleClassNameOf(StackTraceElement testStackTraceElement) {
        String className = testStackTraceElement.getClassName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private StackTraceElement getFirstStackTraceElementFromTest(StackTraceElement[] stacktrace) {
        for (StackTraceElement element : stacktrace) {
            String className = element.getClassName();
            if (className.startsWith("sun.reflect") || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("org.junit.") || className.startsWith("org.eclipse.jdt.internal.junit.") || className.startsWith("org.eclipse.jdt.internal.junit4.") || className.startsWith("org.apache.maven.surefire") || className.startsWith("org.assertj.core.internal.cglib.proxy") || className.startsWith("org.assertj")) continue;
            return element;
        }
        return null;
    }
}

