/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import java.util.Set;
import javax.validation.Validator;
import javax.validation.constraints.NotBlank;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class NotBlankConstraintTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)NotBlankConstraintTest.webArchiveBuilder().withTestClass(NotBlankConstraintTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-notblank", id="a")})
    public void testNotBlankConstraint() {
        Validator validator = this.getValidator();
        NotBlankDummyEntity foo = new NotBlankDummyEntity();
        Set constraintViolations = validator.validate((Object)foo, new Class[0]);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, NotBlank.class);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("name"));
        foo.name = "";
        constraintViolations = validator.validate((Object)foo, new Class[0]);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, NotBlank.class);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("name"));
        foo.name = " ";
        constraintViolations = validator.validate((Object)foo, new Class[0]);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, NotBlank.class);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("name"));
        foo.name = "\t";
        constraintViolations = validator.validate((Object)foo, new Class[0]);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, NotBlank.class);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("name"));
        foo.name = "\n";
        constraintViolations = validator.validate((Object)foo, new Class[0]);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, NotBlank.class);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("name"));
        foo.name = "john doe";
        constraintViolations = validator.validate((Object)foo, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-notblank", id="a")})
    public void testNotBlankConstraintOnStringBuilder() {
        Validator validator = this.getValidator();
        NotBlankStringBuilderDummyEntity foo = new NotBlankStringBuilderDummyEntity();
        Set constraintViolations = validator.validate((Object)foo, new Class[0]);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, NotBlank.class);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("name"));
        foo.name = new StringBuilder(" ");
        constraintViolations = validator.validate((Object)foo, new Class[0]);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, NotBlank.class);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("name"));
        foo.name = new StringBuilder("john doe");
        constraintViolations = validator.validate((Object)foo, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
    }

    private class NotBlankStringBuilderDummyEntity {
        @NotBlank
        private StringBuilder name;

        private NotBlankStringBuilderDummyEntity() {
        }
    }

    private class NotBlankDummyEntity {
        @NotBlank
        private String name;

        private NotBlankDummyEntity() {
        }
    }
}

