/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.frame;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import jdk.incubator.http.internal.common.ByteBufferReference;
import jdk.incubator.http.internal.common.Log;
import jdk.incubator.http.internal.common.Utils;
import jdk.incubator.http.internal.frame.ContinuationFrame;
import jdk.incubator.http.internal.frame.DataFrame;
import jdk.incubator.http.internal.frame.GoAwayFrame;
import jdk.incubator.http.internal.frame.HeadersFrame;
import jdk.incubator.http.internal.frame.Http2Frame;
import jdk.incubator.http.internal.frame.MalformedFrame;
import jdk.incubator.http.internal.frame.PingFrame;
import jdk.incubator.http.internal.frame.PriorityFrame;
import jdk.incubator.http.internal.frame.PushPromiseFrame;
import jdk.incubator.http.internal.frame.ResetFrame;
import jdk.incubator.http.internal.frame.SettingsFrame;
import jdk.incubator.http.internal.frame.WindowUpdateFrame;

public class FramesDecoder {
    private final FrameProcessor frameProcessor;
    private final int maxFrameSize;
    private ByteBufferReference currentBuffer;
    private final Queue<ByteBufferReference> tailBuffers = new ArrayDeque<ByteBufferReference>();
    private int tailSize = 0;
    private boolean slicedToDataFrame = false;
    private final List<ByteBufferReference> prepareToRelease = new ArrayList<ByteBufferReference>();
    private boolean frameHeaderParsed = false;
    private int frameLength;
    private int frameType;
    private int frameFlags;
    private int frameStreamid;

    public FramesDecoder(FrameProcessor frameProcessor) {
        this(frameProcessor, 16384);
    }

    public FramesDecoder(FrameProcessor frameProcessor, int n) {
        this.frameProcessor = frameProcessor;
        this.maxFrameSize = Math.min(Math.max(16384, n), 0xFFFFFF);
    }

    public void decode(ByteBufferReference byteBufferReference) throws IOException {
        Http2Frame http2Frame;
        int n = byteBufferReference.get().remaining();
        if (n > 0) {
            if (this.currentBuffer == null) {
                this.currentBuffer = byteBufferReference;
            } else {
                this.tailBuffers.add(byteBufferReference);
                this.tailSize += n;
            }
        }
        while ((http2Frame = this.nextFrame()) != null) {
            this.frameProcessor.processFrame(http2Frame);
            this.frameProcessed();
        }
    }

    private Http2Frame nextFrame() throws IOException {
        block6: {
            Http2Frame http2Frame;
            do {
                if (this.currentBuffer == null) {
                    return null;
                }
                if (!this.frameHeaderParsed) {
                    if (this.currentBuffer.get().remaining() + this.tailSize >= 9) {
                        this.parseFrameHeader();
                        if (this.frameLength > this.maxFrameSize) {
                            return new MalformedFrame(6, "Frame type(" + this.frameType + ") " + "length(" + this.frameLength + ") exceeds MAX_FRAME_SIZE(" + this.maxFrameSize + ")");
                        }
                        this.frameHeaderParsed = true;
                    } else {
                        return null;
                    }
                }
                if (this.frameLength != 0 && (this.currentBuffer == null || this.currentBuffer.get().remaining() + this.tailSize < this.frameLength)) break block6;
                http2Frame = this.parseFrameBody();
                this.frameHeaderParsed = false;
            } while (http2Frame == null);
            return http2Frame;
        }
        return null;
    }

    private void frameProcessed() {
        this.prepareToRelease.forEach(ByteBufferReference::clear);
        this.prepareToRelease.clear();
    }

    private void parseFrameHeader() throws IOException {
        int n = this.getInt();
        this.frameLength = n >> 8;
        this.frameType = n & 0xFF;
        this.frameFlags = this.getByte();
        this.frameStreamid = this.getInt() & Integer.MAX_VALUE;
    }

    private void nextBuffer() {
        if (!this.currentBuffer.get().hasRemaining()) {
            if (!this.slicedToDataFrame) {
                this.prepareToRelease.add(this.currentBuffer);
            }
            this.slicedToDataFrame = false;
            this.currentBuffer = this.tailBuffers.poll();
            if (this.currentBuffer != null) {
                this.tailSize -= this.currentBuffer.get().remaining();
            }
        }
    }

    public int getByte() {
        ByteBuffer byteBuffer = this.currentBuffer.get();
        int n = byteBuffer.get() & 0xFF;
        this.nextBuffer();
        return n;
    }

    public int getShort() {
        ByteBuffer byteBuffer = this.currentBuffer.get();
        if (byteBuffer.remaining() >= 2) {
            int n = byteBuffer.getShort() & 0xFFFF;
            this.nextBuffer();
            return n;
        }
        int n = this.getByte();
        n = (n << 8) + this.getByte();
        return n;
    }

    public int getInt() {
        ByteBuffer byteBuffer = this.currentBuffer.get();
        if (byteBuffer.remaining() >= 4) {
            int n = byteBuffer.getInt();
            this.nextBuffer();
            return n;
        }
        int n = this.getByte();
        n = (n << 8) + this.getByte();
        n = (n << 8) + this.getByte();
        n = (n << 8) + this.getByte();
        return n;
    }

    public byte[] getBytes(int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n > 0) {
            ByteBuffer byteBuffer = this.currentBuffer.get();
            int n3 = Math.min(n, byteBuffer.remaining());
            byteBuffer.get(byArray, n2, n3);
            n2 += n3;
            n -= n3;
            this.nextBuffer();
        }
        return byArray;
    }

    private ByteBufferReference[] getBuffers(boolean bl, int n) {
        ArrayList<ByteBufferReference> arrayList = new ArrayList<ByteBufferReference>();
        while (n > 0) {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = this.currentBuffer.get();
            int n2 = byteBuffer2.remaining();
            int n3 = Math.min(n2, n);
            if (bl) {
                byteBuffer = Utils.slice(byteBuffer2, n3);
                this.slicedToDataFrame = true;
            } else {
                byteBuffer = Utils.slice(byteBuffer2, n3);
            }
            arrayList.add(ByteBufferReference.of(byteBuffer));
            n -= n3;
            this.nextBuffer();
        }
        return arrayList.toArray(new ByteBufferReference[0]);
    }

    public void skipBytes(int n) {
        while (n > 0) {
            ByteBuffer byteBuffer = this.currentBuffer.get();
            int n2 = byteBuffer.remaining();
            int n3 = Math.min(n2, n);
            byteBuffer.position(byteBuffer.position() + n3);
            n -= n2;
            this.nextBuffer();
        }
    }

    private Http2Frame parseFrameBody() throws IOException {
        assert (this.frameHeaderParsed);
        switch (this.frameType) {
            case 0: {
                return this.parseDataFrame(this.frameLength, this.frameStreamid, this.frameFlags);
            }
            case 1: {
                return this.parseHeadersFrame(this.frameLength, this.frameStreamid, this.frameFlags);
            }
            case 2: {
                return this.parsePriorityFrame(this.frameLength, this.frameStreamid, this.frameFlags);
            }
            case 3: {
                return this.parseResetFrame(this.frameLength, this.frameStreamid, this.frameFlags);
            }
            case 4: {
                return this.parseSettingsFrame(this.frameLength, this.frameStreamid, this.frameFlags);
            }
            case 5: {
                return this.parsePushPromiseFrame(this.frameLength, this.frameStreamid, this.frameFlags);
            }
            case 6: {
                return this.parsePingFrame(this.frameLength, this.frameStreamid, this.frameFlags);
            }
            case 7: {
                return this.parseGoAwayFrame(this.frameLength, this.frameStreamid, this.frameFlags);
            }
            case 8: {
                return this.parseWindowUpdateFrame(this.frameLength, this.frameStreamid, this.frameFlags);
            }
            case 9: {
                return this.parseContinuationFrame(this.frameLength, this.frameStreamid, this.frameFlags);
            }
        }
        Log.logTrace("Unknown incoming frame type: {0}", this.frameType);
        this.skipBytes(this.frameLength);
        return null;
    }

    private Http2Frame parseDataFrame(int n, int n2, int n3) {
        if (n2 == 0) {
            return new MalformedFrame(1, "zero streamId for DataFrame");
        }
        int n4 = 0;
        if ((n3 & 8) != 0) {
            n4 = this.getByte();
            if (n4 >= n) {
                return new MalformedFrame(1, "the length of the padding is the length of the frame payload or greater");
            }
            --n;
        }
        DataFrame dataFrame = new DataFrame(n2, n3, this.getBuffers(true, n - n4), n4);
        this.skipBytes(n4);
        return dataFrame;
    }

    private Http2Frame parseHeadersFrame(int n, int n2, int n3) {
        if (n2 == 0) {
            return new MalformedFrame(1, "zero streamId for HeadersFrame");
        }
        int n4 = 0;
        if ((n3 & 8) != 0) {
            n4 = this.getByte();
            --n;
        }
        boolean bl = (n3 & 0x20) != 0;
        boolean bl2 = false;
        int n5 = 0;
        int n6 = 0;
        if (bl) {
            int n7 = this.getInt();
            bl2 = (n7 & Integer.MIN_VALUE) != 0;
            n5 = n7 & Integer.MAX_VALUE;
            n6 = this.getByte();
            n -= 5;
        }
        if (n < n4) {
            return new MalformedFrame(1, "Padding exceeds the size remaining for the header block");
        }
        HeadersFrame headersFrame = new HeadersFrame(n2, n3, this.getBuffers(false, n - n4), n4);
        this.skipBytes(n4);
        if (bl) {
            headersFrame.setPriority(n5, bl2, n6);
        }
        return headersFrame;
    }

    private Http2Frame parsePriorityFrame(int n, int n2, int n3) {
        if (n2 == 0) {
            return new MalformedFrame(1, "zero streamId for PriorityFrame");
        }
        if (n != 5) {
            this.skipBytes(n);
            return new MalformedFrame(6, n2, "PriorityFrame length is " + n + ", expected 5");
        }
        int n4 = this.getInt();
        int n5 = this.getByte();
        return new PriorityFrame(n2, n4 & Integer.MAX_VALUE, (n4 & Integer.MIN_VALUE) != 0, n5);
    }

    private Http2Frame parseResetFrame(int n, int n2, int n3) {
        if (n2 == 0) {
            return new MalformedFrame(1, "zero streamId for ResetFrame");
        }
        if (n != 4) {
            return new MalformedFrame(6, "ResetFrame length is " + n + ", expected 4");
        }
        return new ResetFrame(n2, this.getInt());
    }

    private Http2Frame parseSettingsFrame(int n, int n2, int n3) {
        if (n2 != 0) {
            return new MalformedFrame(1, "non-zero streamId for SettingsFrame");
        }
        if ((1 & n3) != 0 && n > 0) {
            return new MalformedFrame(6, "ACK SettingsFrame is not empty");
        }
        if (n % 6 != 0) {
            return new MalformedFrame(6, "invalid SettingsFrame size: " + n);
        }
        SettingsFrame settingsFrame = new SettingsFrame(n3);
        int n4 = n / 6;
        for (int i = 0; i < n4; ++i) {
            int n5 = this.getShort();
            int n6 = this.getInt();
            if (n5 <= 0 || n5 > 6) continue;
            settingsFrame.setParameter(n5, n6);
        }
        return settingsFrame;
    }

    private Http2Frame parsePushPromiseFrame(int n, int n2, int n3) {
        if (n2 == 0) {
            return new MalformedFrame(1, "zero streamId for PushPromiseFrame");
        }
        int n4 = 0;
        if ((n3 & 8) != 0) {
            n4 = this.getByte();
            --n;
        }
        int n5 = this.getInt() & Integer.MAX_VALUE;
        if ((n -= 4) < n4) {
            return new MalformedFrame(1, "Padding exceeds the size remaining for the PushPromiseFrame");
        }
        PushPromiseFrame pushPromiseFrame = new PushPromiseFrame(n2, n3, n5, this.getBuffers(false, n - n4), n4);
        this.skipBytes(n4);
        return pushPromiseFrame;
    }

    private Http2Frame parsePingFrame(int n, int n2, int n3) {
        if (n2 != 0) {
            return new MalformedFrame(1, "non-zero streamId for PingFrame");
        }
        if (n != 8) {
            return new MalformedFrame(6, "PingFrame length is " + n + ", expected 8");
        }
        return new PingFrame(n3, this.getBytes(8));
    }

    private Http2Frame parseGoAwayFrame(int n, int n2, int n3) {
        if (n2 != 0) {
            return new MalformedFrame(1, "non-zero streamId for GoAwayFrame");
        }
        if (n < 8) {
            return new MalformedFrame(6, "Invalid GoAway frame size");
        }
        int n4 = this.getInt() & Integer.MAX_VALUE;
        int n5 = this.getInt();
        byte[] byArray = this.getBytes(n - 8);
        if (byArray.length > 0) {
            Log.logError("GoAway debugData " + new String(byArray), new Object[0]);
        }
        return new GoAwayFrame(n4, n5, byArray);
    }

    private Http2Frame parseWindowUpdateFrame(int n, int n2, int n3) {
        if (n != 4) {
            return new MalformedFrame(6, "WindowUpdateFrame length is " + n + ", expected 4");
        }
        return new WindowUpdateFrame(n2, this.getInt() & Integer.MAX_VALUE);
    }

    private Http2Frame parseContinuationFrame(int n, int n2, int n3) {
        if (n2 == 0) {
            return new MalformedFrame(1, "zero streamId for ContinuationFrame");
        }
        return new ContinuationFrame(n2, n3, this.getBuffers(false, n));
    }

    @FunctionalInterface
    public static interface FrameProcessor {
        public void processFrame(Http2Frame var1) throws IOException;
    }
}

