/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReaderEntryTranslator;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AggregateLDIFReaderEntryTranslator
implements LDIFReaderEntryTranslator {
    private final List<LDIFReaderEntryTranslator> translators;

    public AggregateLDIFReaderEntryTranslator(LDIFReaderEntryTranslator ... translators) {
        this(StaticUtils.toList(translators));
    }

    public AggregateLDIFReaderEntryTranslator(Collection<? extends LDIFReaderEntryTranslator> translators) {
        this.translators = translators == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<LDIFReaderEntryTranslator>(translators));
    }

    @Override
    public Entry translate(Entry original, long firstLineNumber) throws LDIFException {
        if (original == null) {
            return null;
        }
        Entry e = original;
        for (LDIFReaderEntryTranslator t : this.translators) {
            e = t.translate(e, firstLineNumber);
            if (e != null) continue;
            return null;
        }
        return e;
    }
}

