/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.core.impl;

import java.util.Stack;
import org.jboss.arquillian.core.impl.SecurityActions;
import org.jboss.arquillian.core.spi.ObserverMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeLogger {
    private static final String ARQUILLIAN_DEBUG_PROPERTY = "arquillian.debug";
    static Boolean DEBUG = Boolean.valueOf(SecurityActions.getProperty("arquillian.debug"));
    private ThreadLocal<Stack<Object>> eventStack;

    void clear() {
        if (this.eventStack != null) {
            this.eventStack.remove();
        }
    }

    void debug(ObserverMethod method, boolean interceptor) {
        if (DEBUG.booleanValue()) {
            System.out.println(this.indent() + "(" + (interceptor ? "I" : "O") + ") " + method.getMethod().getDeclaringClass().getSimpleName() + "." + method.getMethod().getName());
        }
    }

    void debugExtension(Class<?> extension) {
        if (DEBUG.booleanValue()) {
            System.out.println(this.indent() + "(X) " + extension.getName());
        }
    }

    void debug(Object event, boolean push) {
        if (DEBUG.booleanValue()) {
            if (push) {
                System.out.println(this.indent() + "(E) " + this.getEventName(event));
                this.eventStack.get().push(event);
            } else if (!this.eventStack.get().isEmpty()) {
                this.eventStack.get().pop();
            }
        }
    }

    private String getEventName(Object object) {
        Class<?> eventClass = object.getClass();
        if (eventClass.isAnonymousClass() && eventClass.getInterfaces().length == 1 && !eventClass.getInterfaces()[0].getName().startsWith("java")) {
            return eventClass.getInterfaces()[0].getSimpleName();
        }
        return eventClass.getSimpleName();
    }

    private String indent() {
        if (this.eventStack == null) {
            this.eventStack = new ThreadLocal<Stack<Object>>(){

                @Override
                protected Stack<Object> initialValue() {
                    return new Stack<Object>();
                }
            };
        }
        int size = this.eventStack.get().size();
        StringBuilder sb = new StringBuilder(size * 2);
        for (int i = 0; i < size; ++i) {
            sb.append("\t");
        }
        return sb.toString();
    }
}

