/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.spi.TestClass;

public final class RunModeUtils {
    private static Logger log = Logger.getLogger(RunModeUtils.class.getName());

    private RunModeUtils() {
    }

    public static boolean isRunAsClient(org.jboss.arquillian.container.spi.client.deployment.Deployment deployment, TestClass testClass, Method testMethod) {
        boolean runAsClient = true;
        if (deployment != null) {
            runAsClient = !deployment.getDescription().testable();
            boolean bl = runAsClient = deployment.isDeployed() ? runAsClient : true;
            if (testMethod.isAnnotationPresent(RunAsClient.class)) {
                runAsClient = true;
            } else if (testClass.isAnnotationPresent(RunAsClient.class)) {
                runAsClient = true;
            }
        }
        return runAsClient;
    }

    public static boolean isRunAsClientAndCheck(org.jboss.arquillian.container.spi.client.deployment.Deployment deployment, TestClass testClass, Method testMethod) {
        Method[] methods;
        boolean runAsClient = RunModeUtils.isRunAsClient(deployment, testClass, testMethod);
        if (runAsClient && deployment == null && (methods = testClass.getMethods(Deployment.class)).length > 0 && !testMethod.isAnnotationPresent(RunAsClient.class) && !testClass.isAnnotationPresent(RunAsClient.class)) {
            OperateOnDeployment onDeployment = (OperateOnDeployment)testClass.getAnnotation(OperateOnDeployment.class);
            String deploymentName = onDeployment == null ? "_DEFAULT_" : onDeployment.value();
            for (Method m : methods) {
                Deployment deploymentAnnotation = m.getAnnotation(Deployment.class);
                if (!deploymentAnnotation.name().equals(deploymentName) || !deploymentAnnotation.testable()) continue;
                log.warning("The test method " + testClass.getJavaClass().getCanonicalName() + "#" + testMethod.getName() + " will run on the client side,because the " + deploymentName + " deployment is not deployed." + " Please deploy the deployment or mark the test as a client test");
            }
        }
        return runAsClient;
    }

    public static boolean isLocalContainer(Container container) {
        if (container == null || container.getDeployableContainer() == null || container.getDeployableContainer().getDefaultProtocol() == null) {
            return false;
        }
        return "Local".equals(container.getDeployableContainer().getDefaultProtocol().getName());
    }
}

