/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.tck.tests.binding.base;

import javax.inject.Inject;
import javax.mvc.Controller;
import javax.mvc.Models;
import javax.mvc.binding.BindingError;
import javax.mvc.binding.BindingResult;
import javax.mvc.binding.ValidationError;
import javax.validation.Valid;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.mvcspec.tck.tests.binding.base.BindingBaseForm;

@Controller
@Path(value="binding/base")
public class BindingBaseController {
    @Inject
    private Models models;
    @Inject
    private BindingResult bindingResult;

    @GET
    public String render() {
        return "binding/base/form.jsp";
    }

    @POST
    public String submit(@BeanParam @Valid BindingBaseForm form) {
        if (this.bindingResult.isFailed()) {
            String message = this.bindingResult.getAllErrors().stream().map(error -> {
                if (error instanceof BindingError) {
                    return "Binding error: " + error.getMessage();
                }
                if (error instanceof ValidationError) {
                    return "Validation error: " + error.getMessage();
                }
                throw new IllegalStateException("Unsupported type: " + error.getClass().getName());
            }).findFirst().orElseThrow(() -> new IllegalStateException("Binding failed but no error found"));
            this.models.put("message", (Object)message);
        } else {
            this.models.put("message", (Object)("You are " + form.getAge() + " years old."));
        }
        return "binding/base/result.jsp";
    }
}

