/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.mvc.tests.security.xss;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import ee.jakarta.tck.mvc.tests.security.xss.EncodersController;
import ee.jakarta.tck.mvc.util.Archives;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class EncodersTest {
    @ArquillianResource
    private URL baseUrl;
    private WebClient webClient;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(EncodersController.class).addView("<html><span id='injected'>${injectedEncoders != null}</span><span id='el'>${mvc.encoders != null}</span></html>", "access.jsp").addView("${mvc.encoders.html(value)}", "encode-html.jsp").addView("${mvc.encoders.js(value)}", "encode-js.jsp").build();
    }

    @Before
    public void before() {
        this.webClient = new WebClient();
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setRedirectEnabled(false);
    }

    @Test
    @SpecAssertion(section="cross-site-scripting", id="xss-encoders-obj")
    public void encodersInjectable() throws IOException {
        HtmlPage page = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/xss/access");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getElementById("injected").getTextContent(), (Matcher)CoreMatchers.equalTo((Object)"true"));
    }

    @Test
    @SpecAssertion(section="cross-site-scripting", id="xss-encoders-obj")
    public void encodersAvailableFromEl() throws IOException {
        HtmlPage page = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/xss/access");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getElementById("el").getTextContent(), (Matcher)CoreMatchers.equalTo((Object)"true"));
    }

    @Test
    @SpecAssertion(section="cross-site-scripting", id="xss-escaping")
    public void encodesHtml() throws IOException {
        Page page = this.webClient.getPage(this.baseUrl.toString() + "mvc/xss/encode-html");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.equalTo((Object)"&amp;&lt;&gt;&#34;&#39;"));
    }

    @Test
    @SpecAssertion(section="cross-site-scripting", id="xss-escaping")
    public void encodesJavaScript() throws IOException {
        Page page = this.webClient.getPage(this.baseUrl.toString() + "mvc/xss/encode-js");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.equalTo((Object)"\\b\\t\\n\\f\\r\\/\\\\\\x22\\x26\\x27"));
    }
}

