/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.negativeinteger.minexclusive.minexclusive_4;

import jakarta.xml.bind.*;
import java.math.BigInteger;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class minExclusive4_GetSetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        minExclusive4_GetSetCTTests test = new minExclusive4_GetSetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status GetSet001( ) {
        String[] xmlDocNames = {
            "minExclusive-4-1.xml", "minExclusive-4-2.xml", "minExclusive-4-3.xml",
            "minExclusive-4-4.xml", "minExclusive-4-5.xml"
        };
        BigInteger[] expectedValues = {new BigInteger("-88651049463528008853"), new BigInteger("-72628749707594154675"), 
                                       new BigInteger("-56017316398920478594"), new BigInteger("-62818800226061165759"), 
                                       new BigInteger("-1")};
        BigInteger[] anExpectedValues = {new BigInteger("-88651049463528008853"), new BigInteger("-7262874970759415467"), 
                                         new BigInteger("-5601731639892047859"), new BigInteger("-6281880022606116575"), 
                                         new BigInteger("-1")};
        
        for (int i = 0; i < xmlDocNames.length; ++i){
            JAXBElement<BigInteger> elemObj = (JAXBElement<BigInteger>)unmarshal(xmlDocNames[i]);
            if (!elemObj.getValue().equals(expectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.getValue() != " + expectedValues[i]);
            }
            elemObj.setValue(anExpectedValues[i]);
            if (!elemObj.getValue().equals(anExpectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.setValue(" + anExpectedValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anExpectedValues[i]);
            }
        }
        return Status.passed("OKAY");
    }

    public Status GetSet002( ) {
        BigInteger[] setValues = {new BigInteger("-88651049463528008853"), new BigInteger("-72628749707594154675"), 
                                  new BigInteger("-56017316398920478594"), new BigInteger("-62818800226061165759"), 
                                  new BigInteger("-1")};
        BigInteger[] anSetValues = {new BigInteger("-88651049463528008853"), new BigInteger("-7262874970759415467"), 
                                    new BigInteger("-5601731639892047859"), new BigInteger("-6281880022606116575"), 
                                    new BigInteger("-2")};
        JAXBElement<BigInteger> elemObj = null;
        for (int i = 0; i < setValues.length; ++i){
            
                elemObj = (JAXBElement<BigInteger>)(new ObjectFactory()).createNISTSchemaNegativeIntegerMinExclusive4(setValues[i]);
            
            if (!elemObj.getValue().equals(setValues[i])){
                return Status.failed("dynamically created JAXBElement<BigInteger>, elemObj.getValue() != " + setValues[i]);
            }
            elemObj.setValue(anSetValues[i]);
            if (!elemObj.getValue().equals(anSetValues[i])){
                return Status.failed("dynamically created JAXBElement<BigInteger>, elemObj.setValue(" + anSetValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anSetValues[i]);
            }
        }
        return Status.passed("OKAY");
    }


}

