/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */


/*
 *  @(#)MarshalException.test.xml	1.1 02/11/04 Evgueni Rouban
 * Generated from : api/jakarta_xml/bind/MarshalException/MarshalException.test.xml
 *
 * General tests of constructors and methods
 * General tests of constructors and methods.
 */

package javasoft.sqe.tests.api.jakarta.xml.bind.MarshalException;

import jakarta.xml.bind.MarshalException;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.lib.MultiTest;


public class MarshalExceptionTests extends MultiTest {

    static final String msg = "test message";
    static final String err = "error code";
    static final Throwable linkedException = new Throwable();

    /* standalone interface */
    public static void main(String argv[]) {
        MarshalExceptionTests test = new MarshalExceptionTests();
        test.run(argv, System.err, System.out).exit();
    }

    /**
     * Assertion testing
     * for public MarshalException(java.lang.String message),
     * Construct a MarshalException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor001() {
        MarshalException me = new MarshalException(msg);
        if (me.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + me.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public MarshalException(java.lang.String message),
     * The errorCode will default to null..
     * <br><b>Expected results</b>: errorCode is null
     */
    public Status Ctor002() {
        MarshalException me = new MarshalException(msg);
        if (me.getErrorCode() != null) {
            return Status.failed("getErrorCode() != null: \""
                               + me.getErrorCode() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public MarshalException(java.lang.String message),
     * The linkedException will default to null..
     * <br><b>Expected results</b>: linkedException is null
     */
    public Status Ctor003() {
        MarshalException me = new MarshalException(msg);
        if (me.getLinkedException() != null) {
            return Status.failed("getLinkedException() != null: \""
                               + me.getLinkedException() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public MarshalException(java.lang.String message, java.lang.String errorCode),
     * Construct a MarshalException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor004() {
        MarshalException me = new MarshalException(msg, err);
        if (me.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + me.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public MarshalException(java.lang.String message, java.lang.String errorCode),
     * Construct a MarshalException with the specified errorCode..
     * <br><b>Expected results</b>: the errorCode is what set
     */
    public Status Ctor005() {
        MarshalException me = new MarshalException(msg, err);
        if (me.getErrorCode() != err) {
            return Status.failed("getErrorCode() != err: \""
                               + me.getErrorCode() + "\", expected is \"" + err + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public MarshalException(java.lang.String message, java.lang.String errorCode),
     * The linkedException will default to null..
     * <br><b>Expected results</b>: linkedException is null
     */
    public Status Ctor006() {
        MarshalException me = new MarshalException(msg, err);
        if (me.getLinkedException() != null) {
            return Status.failed("getLinkedException() != null: \""
                               + me.getLinkedException() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public MarshalException(java.lang.String message, java.lang.String errorCode, java.lang.Throwable exception),
     * Construct a MarshalException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor007() {
        MarshalException me = new MarshalException(msg, err, linkedException);
        if (me.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + me.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public MarshalException(java.lang.String message, java.lang.String errorCode, java.lang.Throwable exception),
     * Construct a MarshalException with the specified errorCode..
     * <br><b>Expected results</b>: the errorCode is what set
     */
    public Status Ctor008() {
        MarshalException me = new MarshalException(msg, err, linkedException);
        if (me.getErrorCode() != err) {
            return Status.failed("getErrorCode() != err: \""
                               + me.getErrorCode() + "\", expected is \"" + err + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public MarshalException(java.lang.String message, java.lang.String errorCode, java.lang.Throwable exception),
     * Construct a MarshalException with the specified linkedException..
     * <br><b>Expected results</b>: linkedException is what set
     */
    public Status Ctor009() {
        MarshalException me = new MarshalException(msg, err, linkedException);
        if (me.getLinkedException() != linkedException) {
            return Status.failed("getLinkedException() != linkedException: \""
                               + me.getLinkedException() + "\", expected is \"" + linkedException + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public MarshalException(java.lang.String message, java.lang.Throwable exception),
     * Construct a MarshalException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor010() {
        MarshalException me = new MarshalException(msg, linkedException);
        if (me.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + me.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public MarshalException(java.lang.String message, java.lang.Throwable exception),
     * The errorCode will default to null..
     * <br><b>Expected results</b>: errorCode is null
     */
    public Status Ctor011() {
        MarshalException me = new MarshalException(msg, linkedException);
        if (me.getErrorCode() != null) {
            return Status.failed("getErrorCode() != null: \""
                               + me.getErrorCode() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public MarshalException(java.lang.String message, java.lang.Throwable exception),
     * Construct a MarshalException with the specified linkedException..
     * <br><b>Expected results</b>: linkedException is what set
     */
    public Status Ctor012() {
        MarshalException me = new MarshalException(msg, linkedException);
        if (me.getLinkedException() != linkedException) {
            return Status.failed("getLinkedException() != linkedException: \""
                               + me.getLinkedException() + "\", expected is \"" + linkedException + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public MarshalException(java.lang.Throwable exception),
     * The detail message will default to null..
     * <br><b>Expected results</b>: the message is null
     */
    public Status Ctor013() {
        MarshalException me = new MarshalException(linkedException);
        if (me.getMessage() != null) {
            return Status.failed("getMessage() != null: \""
                               + me.getMessage() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public MarshalException(java.lang.Throwable exception),
     * The errorCode will default to null..
     * <br><b>Expected results</b>: errorCode is null
     */
    public Status Ctor014() {
        MarshalException me = new MarshalException(linkedException);
        if (me.getErrorCode() != null) {
            return Status.failed("getErrorCode() != null: \""
                               + me.getErrorCode() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public MarshalException(java.lang.Throwable exception),
     * Construct a MarshalException with the specified linkedException..
     * <br><b>Expected results</b>: linkedException is what set
     */
    public Status Ctor015() {
        MarshalException me = new MarshalException(linkedException);
        if (me.getLinkedException() != linkedException) {
            return Status.failed("getLinkedException() != linkedException: \""
                               + me.getLinkedException() + "\", expected is \"" + linkedException + "\"");
        }

        return Status.passed("OKAY");
    }
}
