/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.unsignedbyte.maxinclusive.maxinclusive_5;

import jakarta.xml.bind.*;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class maxInclusive5_GetSetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        maxInclusive5_GetSetCTTests test = new maxInclusive5_GetSetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status GetSet001( ) {
        String[] xmlDocNames = {
            "maxInclusive-5-1.xml", "maxInclusive-5-2.xml", "maxInclusive-5-3.xml",
            "maxInclusive-5-4.xml", "maxInclusive-5-5.xml"
        };
        short[] expectedValues = {(short)0, (short)185, (short)173, (short)124, (short)255};
        short[] anExpectedValues = {(short)1, (short)54, (short)255, (short)0, (short)254};
        
        for (int i = 0; i < xmlDocNames.length; ++i){
            JAXBElement<Short> elemObj = (JAXBElement<Short>)unmarshal(xmlDocNames[i]);
            if (elemObj.getValue() != expectedValues[i]){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.getValue() != " + expectedValues[i]);
            }
            elemObj.setValue(anExpectedValues[i]);
            if (elemObj.getValue() != anExpectedValues[i]){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.setValue(" + anExpectedValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anExpectedValues[i]);
            }
        }
        return Status.passed("OKAY");
    }

    public Status GetSet002( ) {
        short[] setValues = {(short)0, (short)185, (short)173, (short)124, (short)255};
        short[] anSetValues = {(short)1, (short)54, (short)255, (short)0, (short)254};

        JAXBElement<Short> elemObj = null;
        for (int i = 0; i < setValues.length; ++i){
            
                elemObj = (JAXBElement<Short>)(new ObjectFactory()).createNISTSchemaUnsignedByteMaxInclusive5(setValues[i]);
            
            if (elemObj.getValue() != setValues[i]){
                return Status.failed("dynamically created JAXBElement<Short>, elemObj.getValue() != " + setValues[i]);
            }
            elemObj.setValue(anSetValues[i]);
            if (elemObj.getValue() != anSetValues[i]){
                return Status.failed("dynamically created JAXBElement<Short>, elemObj.setValue(" + anSetValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anSetValues[i]);
            }
        }
        return Status.passed("OKAY");
    }


}

