/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.lib;

import com.sun.javatest.Status;
import java.io.PrintWriter;

public class MultiStatus {
    private int iTestCases = 0;
    private int iPassed = 0;
    private int iFail = 0;
    private int iError = 0;
    private int iBad = 0;
    private String firstTestCase = "";
    private PrintWriter out = null;

    public MultiStatus() {
    }

    public MultiStatus(PrintWriter out) {
        this.out = out;
    }

    public static Status overallStatus(String[] testIDs, Status[] status, PrintWriter out) {
        if (testIDs.length != status.length) {
            return Status.failed("mismatched array sizes; test cases: " + testIDs.length + " statuses: " + status.length);
        }
        MultiStatus ms = new MultiStatus(out);
        for (int i = 0; i < status.length; ++i) {
            ms.add(testIDs[i], status[i]);
        }
        return ms.getStatus();
    }

    public static Status overallStatus(String[] testIDs, Status ... status) {
        return MultiStatus.overallStatus(testIDs, status, null);
    }

    public int getTestCount() {
        return this.iTestCases;
    }

    public void add(String testID, Status status) {
        if (this.out != null) {
            this.out.println(testID + ": " + status);
        }
        ++this.iTestCases;
        if (status != null) {
            int t = status.getType();
            switch (t) {
                case 0: {
                    ++this.iPassed;
                    break;
                }
                case 1: {
                    ++this.iFail;
                    break;
                }
                case 2: {
                    ++this.iError;
                    break;
                }
                default: {
                    ++this.iBad;
                }
            }
            if (t != 0 && this.firstTestCase.isEmpty()) {
                this.firstTestCase = testID;
            }
        }
    }

    public Status getStatus() {
        String summary;
        if (this.out != null) {
            this.out.flush();
        }
        if (this.iTestCases == 0) {
            summary = "No tests cases found (or all test cases excluded.)";
        } else {
            summary = "test cases: " + this.iTestCases;
            if (this.iPassed > 0) {
                summary = this.iPassed == this.iTestCases ? summary + "; all passed" : summary + "; passed: " + this.iPassed;
            }
            if (this.iFail > 0) {
                summary = this.iFail == this.iTestCases ? summary + "; all failed" : summary + "; failed: " + this.iFail;
            }
            if (this.iError > 0) {
                summary = this.iError == this.iTestCases ? summary + "; all had an error" : summary + "; error: " + this.iError;
            }
            if (this.iBad > 0) {
                summary = this.iBad == this.iTestCases ? summary + "; all bad" : summary + "; bad status: " + this.iBad;
            }
        }
        if (this.iBad > 0) {
            return Status.error(summary + "; first bad test case result found: " + this.firstTestCase);
        }
        if (this.iError > 0) {
            return Status.error(summary + "; first test case with error: " + this.firstTestCase);
        }
        if (this.iFail > 0) {
            return Status.failed(summary + "; first test case failure: " + this.firstTestCase);
        }
        return Status.passed(summary);
    }
}

