/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.gradle.plugin;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jkube.gradle.plugin.KubernetesExtension;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.common.util.ResourceClassifier;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;
import org.eclipse.jkube.kit.resource.helm.HelmConfig;
import org.gradle.api.provider.Property;

public abstract class OpenShiftExtension
extends KubernetesExtension {
    public static final Path DEFAULT_OPENSHIFT_MANIFEST = Paths.get("META-INF", "jkube", "openshift.yml");
    private static final Path DEFAULT_OPENSHIFT_TEMPLATE = Paths.get("META-INF", "jkube", "openshift");
    private static final String DEFAULT_OPENSHIFT_PULLSECRET = "pullsecret-jkube";
    private static final String DEFAULT_S2I_BUILDNAME_SUFFIX = "-s2i";
    public static final String DEFAULT_BUILD_OUTPUT_KIND = "ImageStreamTag";

    public abstract Property<File> getOpenShiftManifest();

    public abstract Property<String> getOpenshiftPullSecret();

    public abstract Property<String> getS2iBuildNameSuffix();

    public abstract Property<Boolean> getS2iImageStreamLookupPolicyLocal();

    public abstract Property<String> getBuildOutputKind();

    public abstract Property<String> getOpenshiftPushSecret();

    public abstract Property<File> getImageStreamManifest();

    public RuntimeMode getRuntimeMode() {
        return RuntimeMode.OPENSHIFT;
    }

    public boolean isDockerAccessRequired() {
        return false;
    }

    public PlatformMode getPlatformMode() {
        return PlatformMode.openshift;
    }

    public ResourceClassifier getResourceClassifier() {
        return ResourceClassifier.OPENSHIFT;
    }

    public File getManifest(KitLogger kitLogger, KubernetesClient kubernetesClient) {
        if (OpenshiftHelper.isOpenShift((KubernetesClient)kubernetesClient)) {
            return this.getKubernetesManifestOrDefault();
        }
        return super.getKubernetesManifestOrDefault();
    }

    public JKubeBuildStrategy getBuildStrategyOrDefault() {
        return this.getProperty("jkube.build.strategy", JKubeBuildStrategy::valueOf).orElse(this.buildStrategy != null ? this.buildStrategy : JKubeBuildStrategy.s2i);
    }

    public String getOpenshiftPullSecretOrDefault() {
        return this.getOrDefaultString("jkube.build.pullSecret", this::getOpenshiftPullSecret, DEFAULT_OPENSHIFT_PULLSECRET);
    }

    public String getS2iBuildNameSuffixOrDefault() {
        return this.getOrDefaultString("jkube.s2i.buildNameSuffix", this::getS2iBuildNameSuffix, DEFAULT_S2I_BUILDNAME_SUFFIX);
    }

    public boolean getS2iImageStreamLookupPolicyLocalOrDefault() {
        return this.getOrDefaultBoolean("jkube.s2i.imageStreamLookupPolicyLocal", this::getS2iImageStreamLookupPolicyLocal, true);
    }

    public String getBuildOutputKindOrDefault() {
        return this.getOrDefaultString("jkube.build.buildOutput.kind", this::getBuildOutputKind, DEFAULT_BUILD_OUTPUT_KIND);
    }

    public boolean getProcessTemplatesLocallyOrDefault() {
        return this.getOrDefaultBoolean("jkube.deploy.processTemplatesLocally", () -> ((OpenShiftExtension)this).getProcessTemplatesLocally(), false);
    }

    public boolean isSupportOAuthClients() {
        return true;
    }

    public HelmConfig.HelmType getDefaultHelmType() {
        return HelmConfig.HelmType.OPENSHIFT;
    }

    public File getKubernetesTemplateOrDefault() {
        return this.getOrDefaultFile("jkube.kubernetesTemplate", () -> ((OpenShiftExtension)this).getKubernetesTemplate(), this.javaProject.getOutputDirectory().toPath().resolve(DEFAULT_OPENSHIFT_TEMPLATE).toFile());
    }

    public File getKubernetesManifestOrDefault() {
        return this.getOrDefaultFile("jkube.openshiftManifest", this::getOpenShiftManifest, this.javaProject.getOutputDirectory().toPath().resolve(DEFAULT_OPENSHIFT_MANIFEST).toFile());
    }

    public File getImageStreamManifestOrDefault() {
        return this.getOrDefaultFile("jkube.openshiftImageStreamManifest", this::getImageStreamManifest, this.javaProject.getBuildDirectory().toPath().resolve(Paths.get(this.javaProject.getArtifactId() + "-is.yml", new String[0])).toFile());
    }
}

