/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.gradle.plugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jkube.gradle.plugin.AbstractJKubePlugin;
import org.eclipse.jkube.gradle.plugin.OpenShiftExtension;
import org.eclipse.jkube.gradle.plugin.task.KubernetesApplyTask;
import org.eclipse.jkube.gradle.plugin.task.KubernetesBuildTask;
import org.eclipse.jkube.gradle.plugin.task.KubernetesConfigViewTask;
import org.eclipse.jkube.gradle.plugin.task.KubernetesHelmTask;
import org.eclipse.jkube.gradle.plugin.task.KubernetesLogTask;
import org.eclipse.jkube.gradle.plugin.task.KubernetesRemoteDevTask;
import org.eclipse.jkube.gradle.plugin.task.KubernetesResourceTask;
import org.eclipse.jkube.gradle.plugin.task.OpenShiftApplyTask;
import org.eclipse.jkube.gradle.plugin.task.OpenShiftBuildTask;
import org.eclipse.jkube.gradle.plugin.task.OpenShiftDebugTask;
import org.eclipse.jkube.gradle.plugin.task.OpenShiftHelmPushTask;
import org.eclipse.jkube.gradle.plugin.task.OpenShiftHelmTask;
import org.eclipse.jkube.gradle.plugin.task.OpenShiftPushTask;
import org.eclipse.jkube.gradle.plugin.task.OpenShiftResourceTask;
import org.eclipse.jkube.gradle.plugin.task.OpenShiftUndeployTask;
import org.eclipse.jkube.gradle.plugin.task.OpenShiftWatchTask;
import org.gradle.api.Project;
import org.gradle.api.Task;

public class OpenShiftPlugin
extends AbstractJKubePlugin<OpenShiftExtension> {
    public OpenShiftPlugin() {
        super("openshift", OpenShiftExtension.class);
    }

    public Map<String, Collection<Class<? extends Task>>> getTaskPrecedence() {
        HashMap<String, Collection<Class<? extends Task>>> ret = new HashMap<String, Collection<Class<? extends Task>>>();
        ret.put("ocApply", Arrays.asList(KubernetesResourceTask.class, OpenShiftResourceTask.class));
        ret.put("ocDebug", Arrays.asList(KubernetesBuildTask.class, OpenShiftBuildTask.class, KubernetesResourceTask.class, OpenShiftResourceTask.class, KubernetesApplyTask.class, OpenShiftApplyTask.class));
        ret.put("ocPush", Arrays.asList(KubernetesBuildTask.class, OpenShiftBuildTask.class));
        ret.put("ocHelm", Arrays.asList(KubernetesResourceTask.class, OpenShiftResourceTask.class));
        ret.put("ocHelmPush", Arrays.asList(KubernetesHelmTask.class, OpenShiftHelmTask.class));
        return ret;
    }

    protected void jKubeApply(Project project) {
        this.register(project, "ocApply", OpenShiftApplyTask.class);
        this.register(project, "ocBuild", OpenShiftBuildTask.class);
        this.register(project, "ocConfigView", KubernetesConfigViewTask.class);
        this.register(project, "ocDebug", OpenShiftDebugTask.class);
        this.register(project, "ocLog", KubernetesLogTask.class);
        this.register(project, "ocPush", OpenShiftPushTask.class);
        this.register(project, "ocResource", OpenShiftResourceTask.class);
        this.register(project, "ocUndeploy", OpenShiftUndeployTask.class);
        this.register(project, "ocHelm", OpenShiftHelmTask.class);
        this.register(project, "ocHelmPush", OpenShiftHelmPushTask.class);
        this.register(project, "ocRemoteDev", KubernetesRemoteDevTask.class);
        this.register(project, "ocWatch", OpenShiftWatchTask.class);
    }
}

