/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.gradle.plugin.task;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.inject.Inject;
import org.eclipse.jkube.gradle.plugin.OpenShiftExtension;
import org.eclipse.jkube.gradle.plugin.task.KubernetesResourceTask;
import org.eclipse.jkube.gradle.plugin.task.OpenShiftJKubeTask;
import org.eclipse.jkube.kit.build.service.docker.config.handler.ImageConfigResolver;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;

public class OpenShiftResourceTask
extends KubernetesResourceTask
implements OpenShiftJKubeTask {
    @Inject
    public OpenShiftResourceTask(Class<? extends OpenShiftExtension> extensionClass) {
        super(extensionClass);
        this.setDescription("Generates or copies the OpenShift JSON file and attaches it to the build so its installed and released to maven repositories like other build artifacts.");
    }

    public List<ImageConfiguration> resolveImages(ImageConfigResolver imageConfigResolver) throws IOException {
        RuntimeMode runtimeMode = this.kubernetesExtension.getRuntimeMode();
        Properties properties = this.kubernetesExtension.javaProject.getProperties();
        if (!properties.contains("jkube.image.user")) {
            String namespaceToBeUsed = Optional.ofNullable(this.kubernetesExtension.getNamespaceOrNull()).orElse(this.clusterAccess.getNamespace());
            this.kitLogger.info("Using container image name of namespace: " + namespaceToBeUsed, new Object[0]);
            properties.setProperty("jkube.image.user", namespaceToBeUsed);
        }
        if (!properties.contains("jkube.internal.effective.platform.mode")) {
            properties.setProperty("jkube.internal.effective.platform.mode", runtimeMode.toString());
        }
        return super.resolveImages(imageConfigResolver);
    }
}

