/**
 * File:    TransformationService.java
 * Created: 26.02.2008
 *
 *
/*******************************************************************************
 * Copyright (c) 2008  Open Wide (www.openwide.fr)
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Mickael Istria, Open Wide, Lyon, France
 *      - creation and implementation
 *******************************************************************************/
package org.eclipse.jwt.transformations.api;

import java.io.IOException;


/**
 * This class is intended to be implemented when one wants to provide
 * a transformation.
 * 
 * It is used by the extension point "org.eclipse.jwt.transformations"
 * @author mistria
 * @since 0.6
 */
public abstract class TransformationService {
	
	private String description;
	private String type; //import, export, null
	
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
	public void setType(String type) {
		this.type = type;
	}
	
	public String getTye() {
		return type;
	}

	public abstract void transform(String inFilePath, String outFilePath)
		throws IOException, TransformationException;
}
