/**
 * File:    TransformationImporterWizardPage.java
 * Created: 12.12.2008
 *
 *
/*******************************************************************************
 * Copyright (c) 2008  Open Wide (www.openwide.fr)
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Mickael Istria, Open Wide, Lyon, France
 *      - Creation and implementation
 *******************************************************************************/
package org.eclipse.jwt.transformations.importTransformations.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jwt.transformations.base.TransformationsMessages;
import org.eclipse.jwt.transformations.importTransformations.ImportJWTTransformationRequestDesc;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TransformationImportWizardPage extends WizardPage {

	private static final String PAGE_NAME = TransformationsMessages.importWizard_pageName;
	
	private ImportJWTTransformationRequestDesc importTransfoDesc;

	private String inFilePath;
	
	public TransformationImportWizardPage() {
		super(PAGE_NAME);
		this.setTitle(TransformationsMessages.importWizard_pageTitle);
        this.setDescription(TransformationsMessages.importWizard_pageDescription);
	}
	
	public void createControl(Composite parent) {
		if (this.getControl() == null) {
			importTransfoDesc = new ImportJWTTransformationRequestDesc(parent, new CompletedPageListener());
			if (this.inFilePath != null)
				importTransfoDesc.setInFilePath(inFilePath);
			setControl(importTransfoDesc.createControl());
			setPageComplete(importTransfoDesc.hasAllRequiredInfo());
		}
	}
	
	public boolean finish() {
		return importTransfoDesc.apply();
	}

	public void setInFilePath(String inFilePath) {
		this.inFilePath = inFilePath;
	}

	private class CompletedPageListener implements Listener {
		public void handleEvent(Event event) {
			TransformationImportWizardPage.this.setPageComplete(importTransfoDesc.hasAllRequiredInfo());
		}
	}
	
}
