/**
 * File:    StandardFigureFactory.java
 * Created: 10.07.2008
 *
 *
/*******************************************************************************
 * Copyright (c) 2005-2011
 * University of Augsburg, Germany <www.ds-lab.org>
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Christian Saad, Programming distributed Systems Lab, University of Augsburg 
 *    	- initial API and implementation
 *******************************************************************************/

package org.eclipse.jwt.we.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jwt.we.misc.logging.Logger;


/**
 * This is the standard implementation of IFigureFactory that returns the typical JWT
 * Draw2D figures (from the figures package) for model elements.
 * 
 * @version $Id: StandardFigureFactory.java,v 1.7 2009-11-26 12:41:49 chsaad Exp $
 * @author Christian Saad (csaad@gmx.net), Programming distributed Systems Lab, University
 *         of Augsburg, Germany, www.ds-lab.org
 */
public class StandardFigureFactory
		implements IFigureFactory
{

	/**
	 * A Logger.
	 */
	private static final Logger logger = Logger.getLogger(StandardFigureFactory.class);

	/**
	 * Package that contains the model elements.
	 */
	private static final String MODEL_ROOT_PACKAGE = "org.eclipse.jwt.we.model"; //$NON-NLS-1$

	private static final String MODEL_EXTERNAL_ROOT_PACKAGE = "org.eclipse.jwt.meta.model"; //$NON-NLS-1$

	/**
	 * Package that contains the figures.
	 */
	private static final String FIGURE_ROOT_PACKAGE = StandardFigureFactory.class
			.getPackage().getName();

	/**
	 * Postfix for figure class names.
	 */
	private static final String FIGURE_POSTFIX = "Figure"; //$NON-NLS-1$


	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.jwt.we.figures.factory.IFigureFactory#createFigure(java.lang.Class)
	 */
	public IFigure createFigure(Class modelType)
	{
		IFigure figure = null;

		String target = modelType.getName();

		if (target.startsWith(MODEL_EXTERNAL_ROOT_PACKAGE))
		{
			target = target.replace(MODEL_EXTERNAL_ROOT_PACKAGE, MODEL_ROOT_PACKAGE);
		}

		// only for model elements
		if (!target.startsWith(MODEL_ROOT_PACKAGE))
		{
			return null;
		}

		// the class name of the figure
		String figureClass = FIGURE_ROOT_PACKAGE
				+ target.substring(MODEL_ROOT_PACKAGE.length()) + FIGURE_POSTFIX;

		try
		{
			// instantiate the figure class
			figure = (IFigure) Class.forName(figureClass).newInstance();
		}
		catch (Exception e)
		{
			logger.debug("Can't find figure class for " + modelType); //$NON-NLS-1$

			return null;
		}

		return figure;
	}

}
