/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po;

import org.eclipse.keyple.calypso.command.po.PoRevision;
import org.eclipse.keyple.calypso.command.po.builder.AppendRecordCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.DecreaseCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.GetDataFciCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.IncreaseCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.ReadRecordsCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.SelectFileCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.UpdateRecordCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.session.CloseSessionCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.session.OpenSession10CmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.session.OpenSession24CmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.session.OpenSession31CmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.session.OpenSession32CmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.session.PoGetChallengeCmdBuild;
import org.eclipse.keyple.calypso.command.po.parser.AppendRecordRespPars;
import org.eclipse.keyple.calypso.command.po.parser.DecreaseRespPars;
import org.eclipse.keyple.calypso.command.po.parser.GetDataFciRespPars;
import org.eclipse.keyple.calypso.command.po.parser.IncreaseRespPars;
import org.eclipse.keyple.calypso.command.po.parser.ReadRecordsRespPars;
import org.eclipse.keyple.calypso.command.po.parser.SelectFileRespPars;
import org.eclipse.keyple.calypso.command.po.parser.UpdateRecordRespPars;
import org.eclipse.keyple.calypso.command.po.parser.session.CloseSessionRespPars;
import org.eclipse.keyple.calypso.command.po.parser.session.OpenSession10RespPars;
import org.eclipse.keyple.calypso.command.po.parser.session.OpenSession24RespPars;
import org.eclipse.keyple.calypso.command.po.parser.session.OpenSession31RespPars;
import org.eclipse.keyple.calypso.command.po.parser.session.OpenSession32RespPars;
import org.eclipse.keyple.calypso.command.po.parser.session.PoGetChallengeRespPars;
import org.eclipse.keyple.command.AbstractApduCommandBuilder;
import org.eclipse.keyple.command.AbstractApduResponseParser;
import org.eclipse.keyple.command.CommandsTable;

public enum CalypsoPoCommands implements CommandsTable
{
    GET_DATA_FCI("Get Data'FCI'", -54, GetDataFciCmdBuild.class, GetDataFciRespPars.class),
    OPEN_SESSION_10("Open Secure Session V1", -118, OpenSession10CmdBuild.class, OpenSession10RespPars.class),
    OPEN_SESSION_24("Open Secure Session V2.4", -118, OpenSession24CmdBuild.class, OpenSession24RespPars.class),
    OPEN_SESSION_31("Open Secure Session V3.1", -118, OpenSession31CmdBuild.class, OpenSession31RespPars.class),
    OPEN_SESSION_32("Open Secure Session V3.2", -118, OpenSession32CmdBuild.class, OpenSession32RespPars.class),
    CLOSE_SESSION("Close Secure Session", -114, CloseSessionCmdBuild.class, CloseSessionRespPars.class),
    READ_RECORDS("Read Records", -78, ReadRecordsCmdBuild.class, ReadRecordsRespPars.class),
    UPDATE_RECORD("Update Record", -36, UpdateRecordCmdBuild.class, UpdateRecordRespPars.class),
    APPEND_RECORD("Append Record", -30, AppendRecordCmdBuild.class, AppendRecordRespPars.class),
    GET_CHALLENGE("Get Challenge", -124, PoGetChallengeCmdBuild.class, PoGetChallengeRespPars.class),
    INCREASE("Increase", 50, IncreaseCmdBuild.class, IncreaseRespPars.class),
    DECREASE("Decrease", 48, DecreaseCmdBuild.class, DecreaseRespPars.class),
    SELECT_FILE("Select File", -92, SelectFileCmdBuild.class, SelectFileRespPars.class);

    private final String name;
    private final byte instructionbyte;
    private final Class<? extends AbstractApduCommandBuilder> commandBuilderClass;
    private final Class<? extends AbstractApduResponseParser> responseParserClass;

    private CalypsoPoCommands(String name, byte instructionByte, Class<? extends AbstractApduCommandBuilder> commandBuilderClass, Class<? extends AbstractApduResponseParser> responseParserClass) {
        this.name = name;
        this.instructionbyte = instructionByte;
        this.commandBuilderClass = commandBuilderClass;
        this.responseParserClass = responseParserClass;
    }

    public String getName() {
        return this.name;
    }

    public byte getInstructionByte() {
        return this.instructionbyte;
    }

    public Class<? extends AbstractApduCommandBuilder> getCommandBuilderClass() {
        return this.commandBuilderClass;
    }

    public Class<? extends AbstractApduResponseParser> getResponseParserClass() {
        return this.responseParserClass;
    }

    public static CalypsoPoCommands getOpenSessionForRev(PoRevision rev) {
        switch (rev) {
            case REV1_0: {
                return OPEN_SESSION_10;
            }
            case REV2_4: {
                return OPEN_SESSION_24;
            }
            case REV3_1: 
            case REV3_1_CLAP: {
                return OPEN_SESSION_31;
            }
            case REV3_2: {
                return OPEN_SESSION_32;
            }
        }
        throw new IllegalStateException("Any revision should have a matching command");
    }
}

