/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloud.app.command;

import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloud.Cloudlet;
import org.eclipse.kura.cloud.CloudletTopic;
import org.eclipse.kura.cloud.app.command.KuraCommandHandler;
import org.eclipse.kura.cloud.app.command.KuraCommandRequestPayload;
import org.eclipse.kura.cloud.app.command.KuraCommandResponsePayload;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraRequestPayload;
import org.eclipse.kura.message.KuraResponsePayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandCloudApp
extends Cloudlet {
    private static final Logger s_logger = LoggerFactory.getLogger(CommandCloudApp.class);
    public static final String APP_ID = "CMD-V1";
    public static final String RESOURCE_COMMAND = "command";

    public CommandCloudApp() {
        super(APP_ID);
    }

    protected void doExec(CloudletTopic reqTopic, KuraRequestPayload reqPayload, KuraResponsePayload respPayload) throws KuraException {
        String[] resources = reqTopic.getResources();
        if (resources == null || resources.length != 1) {
            s_logger.error("Bad request topic: {}", (Object)reqTopic.toString());
            s_logger.error("Expected one resource but found {}", resources != null ? Integer.valueOf(resources.length) : "none");
            respPayload.setResponseCode(400);
            return;
        }
        if (!resources[0].equals(RESOURCE_COMMAND)) {
            s_logger.error("Bad request topic: {}", (Object)reqTopic.toString());
            s_logger.error("Cannot find resource with name: {}", (Object)resources[0]);
            respPayload.setResponseCode(404);
            return;
        }
        s_logger.info("EXECuting resource: {}", (Object)RESOURCE_COMMAND);
        KuraCommandRequestPayload commandReq = new KuraCommandRequestPayload((KuraPayload)reqPayload);
        KuraCommandResponsePayload commandResp = new KuraCommandResponsePayload(200);
        KuraCommandHandler.handleRequest(commandReq, commandResp);
        for (String name : commandResp.metricNames()) {
            Object value = commandResp.getMetric(name);
            respPayload.addMetric(name, value);
        }
        respPayload.setBody(commandResp.getBody());
    }
}

