/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.ui.PlatformUI;

public class STPElementScanner
extends BufferedRuleBasedScanner {
    private String[] keywordList = new String[]{"probe", "for", "else", "foreach", "exit", "printf", "in", "return", "break", "global", "next", "while", "if", "delete", "#include", "function", "do", "print", "error", "log", "printd", "printdln", "println", "sprint", "sprintf", "system", "warn", "continue", "try", "catch"};

    public STPElementScanner() {
        ColorRegistry colorRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        Token defaultToken = new Token((Object)new TextAttribute(colorRegistry.get("org.eclipse.linuxtools.stap.editor.color.default")));
        Token keywordToken = new Token((Object)new TextAttribute(colorRegistry.get("org.eclipse.linuxtools.stap.editor.color.keyword"), null, 1));
        Token commentToken = new Token((Object)new TextAttribute(colorRegistry.get("org.eclipse.linuxtools.stap.editor.color.comment")));
        Token stringToken = new Token((Object)new TextAttribute(colorRegistry.get("org.eclipse.linuxtools.stap.editor.color.string")));
        WordRule keywordsRule = new WordRule(new IWordDetector(this){

            public boolean isWordStart(char c) {
                if (c == '.') {
                    return true;
                }
                return Character.isJavaIdentifierStart(c);
            }

            public boolean isWordPart(char c) {
                if (c == '.') {
                    return true;
                }
                return Character.isJavaIdentifierPart(c);
            }
        }, (IToken)defaultToken, true);
        for (int i = 0; i < this.keywordList.length; ++i) {
            keywordsRule.addWord(this.keywordList[i], (IToken)keywordToken);
        }
        this.setRules(new IRule[]{new MultiLineRule("/*", "*/", (IToken)commentToken), new EndOfLineRule("/*", (IToken)commentToken), new EndOfLineRule("#", (IToken)commentToken), new EndOfLineRule("//", (IToken)commentToken), new EndOfLineRule("#if", (IToken)defaultToken), new EndOfLineRule("#else", (IToken)defaultToken), new EndOfLineRule("#endif", (IToken)defaultToken), new EndOfLineRule("#define", (IToken)defaultToken), new SingleLineRule("\"", "\"", (IToken)stringToken, '\\'), new SingleLineRule("'", "'", (IToken)stringToken, '\\'), keywordsRule, new WhitespaceRule(c -> Character.isWhitespace(c))});
    }
}

