/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.ObjectMapperProvider;
import org.mandas.docker.client.messages.ContainerConfig;
import org.mandas.docker.client.messages.EndpointConfig;
import org.mandas.docker.client.messages.HostConfig;

final class ImmutableContainerConfig
implements ContainerConfig {
    @Nullable
    private final String hostname;
    @Nullable
    private final String domainname;
    @Nullable
    private final String user;
    @Nullable
    private final Boolean attachStdin;
    @Nullable
    private final Boolean attachStdout;
    @Nullable
    private final Boolean attachStderr;
    @Nullable
    private final List<String> portSpecs;
    @Nullable
    private final Set<String> exposedPorts;
    @Nullable
    private final Boolean tty;
    @Nullable
    private final Boolean openStdin;
    @Nullable
    private final Boolean stdinOnce;
    @Nullable
    private final List<String> env;
    @Nullable
    private final List<String> cmd;
    @Nullable
    private final String image;
    @Nullable
    private final Set<String> volumes;
    @Nullable
    private final String workingDir;
    @Nullable
    private final List<String> entrypoint;
    @Nullable
    private final Boolean networkDisabled;
    @Nullable
    private final List<String> onBuild;
    @Nullable
    private final Map<String, String> labels;
    @Nullable
    private final String macAddress;
    @Nullable
    private final HostConfig hostConfig;
    @Nullable
    private final String stopSignal;
    @Nullable
    private final ContainerConfig.Healthcheck healthcheck;
    @Nullable
    private final ContainerConfig.NetworkingConfig networkingConfig;
    private final transient ContainerConfig.Builder toBuilder;

    private ImmutableContainerConfig(@Nullable String hostname, @Nullable String domainname, @Nullable String user, @Nullable Boolean attachStdin, @Nullable Boolean attachStdout, @Nullable Boolean attachStderr, @Nullable List<String> portSpecs, @Nullable Set<String> exposedPorts, @Nullable Boolean tty, @Nullable Boolean openStdin, @Nullable Boolean stdinOnce, @Nullable List<String> env, @Nullable List<String> cmd, @Nullable String image, @Nullable Set<String> volumes, @Nullable String workingDir, @Nullable List<String> entrypoint, @Nullable Boolean networkDisabled, @Nullable List<String> onBuild, @Nullable Map<String, String> labels, @Nullable String macAddress, @Nullable HostConfig hostConfig, @Nullable String stopSignal, @Nullable ContainerConfig.Healthcheck healthcheck, @Nullable ContainerConfig.NetworkingConfig networkingConfig) {
        this.hostname = hostname;
        this.domainname = domainname;
        this.user = user;
        this.attachStdin = attachStdin;
        this.attachStdout = attachStdout;
        this.attachStderr = attachStderr;
        this.portSpecs = portSpecs;
        this.exposedPorts = exposedPorts;
        this.tty = tty;
        this.openStdin = openStdin;
        this.stdinOnce = stdinOnce;
        this.env = env;
        this.cmd = cmd;
        this.image = image;
        this.volumes = volumes;
        this.workingDir = workingDir;
        this.entrypoint = entrypoint;
        this.networkDisabled = networkDisabled;
        this.onBuild = onBuild;
        this.labels = labels;
        this.macAddress = macAddress;
        this.hostConfig = hostConfig;
        this.stopSignal = stopSignal;
        this.healthcheck = healthcheck;
        this.networkingConfig = networkingConfig;
        this.toBuilder = Objects.requireNonNull(ContainerConfig.super.toBuilder(), "toBuilder");
    }

    @Override
    @JsonProperty(value="Hostname")
    @Deprecated
    @Nullable
    public String hostname() {
        return this.hostname;
    }

    @Override
    @JsonProperty(value="Domainname")
    @Deprecated
    @Nullable
    public String domainname() {
        return this.domainname;
    }

    @Override
    @JsonProperty(value="User")
    @Nullable
    public String user() {
        return this.user;
    }

    @Override
    @JsonProperty(value="AttachStdin")
    @Deprecated
    @Nullable
    public Boolean attachStdin() {
        return this.attachStdin;
    }

    @Override
    @JsonProperty(value="AttachStdout")
    @Deprecated
    @Nullable
    public Boolean attachStdout() {
        return this.attachStdout;
    }

    @Override
    @JsonProperty(value="AttachStderr")
    @Deprecated
    @Nullable
    public Boolean attachStderr() {
        return this.attachStderr;
    }

    @Override
    @JsonProperty(value="PortSpecs")
    @Nullable
    public List<String> portSpecs() {
        return this.portSpecs;
    }

    @Override
    @JsonProperty(value="ExposedPorts")
    @JsonSerialize(using=ObjectMapperProvider.SetSerializer.class)
    @JsonDeserialize(using=ObjectMapperProvider.SetDeserializer.class)
    @Nullable
    public Set<String> exposedPorts() {
        return this.exposedPorts;
    }

    @Override
    @JsonProperty(value="Tty")
    @Deprecated
    @Nullable
    public Boolean tty() {
        return this.tty;
    }

    @Override
    @JsonProperty(value="OpenStdin")
    @Deprecated
    @Nullable
    public Boolean openStdin() {
        return this.openStdin;
    }

    @Override
    @JsonProperty(value="StdinOnce")
    @Deprecated
    @Nullable
    public Boolean stdinOnce() {
        return this.stdinOnce;
    }

    @Override
    @JsonProperty(value="Env")
    @Nullable
    public List<String> env() {
        return this.env;
    }

    @Override
    @JsonProperty(value="Cmd")
    @Nullable
    public List<String> cmd() {
        return this.cmd;
    }

    @Override
    @JsonProperty(value="Image")
    @Deprecated
    @Nullable
    public String image() {
        return this.image;
    }

    @Override
    @JsonProperty(value="Volumes")
    @JsonSerialize(using=ObjectMapperProvider.SetSerializer.class)
    @JsonDeserialize(using=ObjectMapperProvider.SetDeserializer.class)
    @Nullable
    public Set<String> volumes() {
        return this.volumes;
    }

    @Override
    @JsonProperty(value="WorkingDir")
    @Nullable
    public String workingDir() {
        return this.workingDir;
    }

    @Override
    @JsonProperty(value="Entrypoint")
    @Nullable
    public List<String> entrypoint() {
        return this.entrypoint;
    }

    @Override
    @JsonProperty(value="NetworkDisabled")
    @Deprecated
    @Nullable
    public Boolean networkDisabled() {
        return this.networkDisabled;
    }

    @Override
    @JsonProperty(value="OnBuild")
    @Nullable
    public List<String> onBuild() {
        return this.onBuild;
    }

    @Override
    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="MacAddress")
    @Deprecated
    @Nullable
    public String macAddress() {
        return this.macAddress;
    }

    @Override
    @JsonProperty(value="HostConfig")
    @Nullable
    public HostConfig hostConfig() {
        return this.hostConfig;
    }

    @Override
    @JsonProperty(value="StopSignal")
    @Nullable
    public String stopSignal() {
        return this.stopSignal;
    }

    @Override
    @JsonProperty(value="Healthcheck")
    @Nullable
    public ContainerConfig.Healthcheck healthcheck() {
        return this.healthcheck;
    }

    @Override
    @JsonProperty(value="NetworkingConfig")
    @Nullable
    public ContainerConfig.NetworkingConfig networkingConfig() {
        return this.networkingConfig;
    }

    @Override
    @JsonProperty(value="toBuilder")
    @JsonIgnore
    public ContainerConfig.Builder toBuilder() {
        return this.toBuilder;
    }

    @Deprecated
    public final ImmutableContainerConfig withHostname(@Nullable String value) {
        if (Objects.equals(this.hostname, value)) {
            return this;
        }
        return new ImmutableContainerConfig(value, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    @Deprecated
    public final ImmutableContainerConfig withDomainname(@Nullable String value) {
        if (Objects.equals(this.domainname, value)) {
            return this;
        }
        return new ImmutableContainerConfig(this.hostname, value, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withUser(@Nullable String value) {
        if (Objects.equals(this.user, value)) {
            return this;
        }
        return new ImmutableContainerConfig(this.hostname, this.domainname, value, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    @Deprecated
    public final ImmutableContainerConfig withAttachStdin(@Nullable Boolean value) {
        if (Objects.equals(this.attachStdin, value)) {
            return this;
        }
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, value, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    @Deprecated
    public final ImmutableContainerConfig withAttachStdout(@Nullable Boolean value) {
        if (Objects.equals(this.attachStdout, value)) {
            return this;
        }
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, value, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    @Deprecated
    public final ImmutableContainerConfig withAttachStderr(@Nullable Boolean value) {
        if (Objects.equals(this.attachStderr, value)) {
            return this;
        }
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, value, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withPortSpecs(String ... elements) {
        if (elements == null) {
            return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, null, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerConfig.createUnmodifiableList(false, ImmutableContainerConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, newValue, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withPortSpecs(@Nullable Iterable<String> elements) {
        if (this.portSpecs == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableContainerConfig.createUnmodifiableList(false, ImmutableContainerConfig.createSafeList(elements, true, false));
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, newValue, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withExposedPorts(String ... elements) {
        if (elements == null) {
            return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, null, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
        }
        Set<String> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerConfig.createUnmodifiableSet(ImmutableContainerConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, newValue, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withExposedPorts(@Nullable Iterable<String> elements) {
        if (this.exposedPorts == elements) {
            return this;
        }
        Set<String> newValue = elements == null ? null : ImmutableContainerConfig.createUnmodifiableSet(ImmutableContainerConfig.createSafeList(elements, true, false));
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, newValue, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    @Deprecated
    public final ImmutableContainerConfig withTty(@Nullable Boolean value) {
        if (Objects.equals(this.tty, value)) {
            return this;
        }
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, value, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    @Deprecated
    public final ImmutableContainerConfig withOpenStdin(@Nullable Boolean value) {
        if (Objects.equals(this.openStdin, value)) {
            return this;
        }
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, value, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    @Deprecated
    public final ImmutableContainerConfig withStdinOnce(@Nullable Boolean value) {
        if (Objects.equals(this.stdinOnce, value)) {
            return this;
        }
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, value, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withEnv(String ... elements) {
        if (elements == null) {
            return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, null, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerConfig.createUnmodifiableList(false, ImmutableContainerConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, newValue, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withEnv(@Nullable Iterable<String> elements) {
        if (this.env == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableContainerConfig.createUnmodifiableList(false, ImmutableContainerConfig.createSafeList(elements, true, false));
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, newValue, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withCmd(String ... elements) {
        if (elements == null) {
            return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, null, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerConfig.createUnmodifiableList(false, ImmutableContainerConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, newValue, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withCmd(@Nullable Iterable<String> elements) {
        if (this.cmd == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableContainerConfig.createUnmodifiableList(false, ImmutableContainerConfig.createSafeList(elements, true, false));
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, newValue, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    @Deprecated
    public final ImmutableContainerConfig withImage(@Nullable String value) {
        if (Objects.equals(this.image, value)) {
            return this;
        }
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, value, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withVolumes(String ... elements) {
        if (elements == null) {
            return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, null, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
        }
        Set<String> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerConfig.createUnmodifiableSet(ImmutableContainerConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, newValue, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withVolumes(@Nullable Iterable<String> elements) {
        if (this.volumes == elements) {
            return this;
        }
        Set<String> newValue = elements == null ? null : ImmutableContainerConfig.createUnmodifiableSet(ImmutableContainerConfig.createSafeList(elements, true, false));
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, newValue, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withWorkingDir(@Nullable String value) {
        if (Objects.equals(this.workingDir, value)) {
            return this;
        }
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, value, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withEntrypoint(String ... elements) {
        if (elements == null) {
            return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, null, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerConfig.createUnmodifiableList(false, ImmutableContainerConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, newValue, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withEntrypoint(@Nullable Iterable<String> elements) {
        if (this.entrypoint == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableContainerConfig.createUnmodifiableList(false, ImmutableContainerConfig.createSafeList(elements, true, false));
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, newValue, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    @Deprecated
    public final ImmutableContainerConfig withNetworkDisabled(@Nullable Boolean value) {
        if (Objects.equals(this.networkDisabled, value)) {
            return this;
        }
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, value, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withOnBuild(String ... elements) {
        if (elements == null) {
            return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, null, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerConfig.createUnmodifiableList(false, ImmutableContainerConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, newValue, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withOnBuild(@Nullable Iterable<String> elements) {
        if (this.onBuild == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableContainerConfig.createUnmodifiableList(false, ImmutableContainerConfig.createSafeList(elements, true, false));
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, newValue, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withLabels(@Nullable Map<String, ? extends String> entries) {
        if (this.labels == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableContainerConfig.createUnmodifiableMap(true, false, entries);
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, newValue, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    @Deprecated
    public final ImmutableContainerConfig withMacAddress(@Nullable String value) {
        if (Objects.equals(this.macAddress, value)) {
            return this;
        }
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, value, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withHostConfig(@Nullable HostConfig value) {
        if (this.hostConfig == value) {
            return this;
        }
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, value, this.stopSignal, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withStopSignal(@Nullable String value) {
        if (Objects.equals(this.stopSignal, value)) {
            return this;
        }
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, value, this.healthcheck, this.networkingConfig);
    }

    public final ImmutableContainerConfig withHealthcheck(@Nullable ContainerConfig.Healthcheck value) {
        if (this.healthcheck == value) {
            return this;
        }
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, value, this.networkingConfig);
    }

    public final ImmutableContainerConfig withNetworkingConfig(@Nullable ContainerConfig.NetworkingConfig value) {
        if (this.networkingConfig == value) {
            return this;
        }
        return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.image, this.volumes, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild, this.labels, this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContainerConfig && this.equalTo(0, (ImmutableContainerConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableContainerConfig another) {
        return Objects.equals(this.hostname, another.hostname) && Objects.equals(this.domainname, another.domainname) && Objects.equals(this.user, another.user) && Objects.equals(this.attachStdin, another.attachStdin) && Objects.equals(this.attachStdout, another.attachStdout) && Objects.equals(this.attachStderr, another.attachStderr) && Objects.equals(this.portSpecs, another.portSpecs) && Objects.equals(this.exposedPorts, another.exposedPorts) && Objects.equals(this.tty, another.tty) && Objects.equals(this.openStdin, another.openStdin) && Objects.equals(this.stdinOnce, another.stdinOnce) && Objects.equals(this.env, another.env) && Objects.equals(this.cmd, another.cmd) && Objects.equals(this.image, another.image) && Objects.equals(this.volumes, another.volumes) && Objects.equals(this.workingDir, another.workingDir) && Objects.equals(this.entrypoint, another.entrypoint) && Objects.equals(this.networkDisabled, another.networkDisabled) && Objects.equals(this.onBuild, another.onBuild) && Objects.equals(this.labels, another.labels) && Objects.equals(this.macAddress, another.macAddress) && Objects.equals(this.hostConfig, another.hostConfig) && Objects.equals(this.stopSignal, another.stopSignal) && Objects.equals(this.healthcheck, another.healthcheck) && Objects.equals(this.networkingConfig, another.networkingConfig);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.hostname);
        h += (h << 5) + Objects.hashCode(this.domainname);
        h += (h << 5) + Objects.hashCode(this.user);
        h += (h << 5) + Objects.hashCode(this.attachStdin);
        h += (h << 5) + Objects.hashCode(this.attachStdout);
        h += (h << 5) + Objects.hashCode(this.attachStderr);
        h += (h << 5) + Objects.hashCode(this.portSpecs);
        h += (h << 5) + Objects.hashCode(this.exposedPorts);
        h += (h << 5) + Objects.hashCode(this.tty);
        h += (h << 5) + Objects.hashCode(this.openStdin);
        h += (h << 5) + Objects.hashCode(this.stdinOnce);
        h += (h << 5) + Objects.hashCode(this.env);
        h += (h << 5) + Objects.hashCode(this.cmd);
        h += (h << 5) + Objects.hashCode(this.image);
        h += (h << 5) + Objects.hashCode(this.volumes);
        h += (h << 5) + Objects.hashCode(this.workingDir);
        h += (h << 5) + Objects.hashCode(this.entrypoint);
        h += (h << 5) + Objects.hashCode(this.networkDisabled);
        h += (h << 5) + Objects.hashCode(this.onBuild);
        h += (h << 5) + Objects.hashCode(this.labels);
        h += (h << 5) + Objects.hashCode(this.macAddress);
        h += (h << 5) + Objects.hashCode(this.hostConfig);
        h += (h << 5) + Objects.hashCode(this.stopSignal);
        h += (h << 5) + Objects.hashCode(this.healthcheck);
        h += (h << 5) + Objects.hashCode(this.networkingConfig);
        return h;
    }

    public String toString() {
        return "ContainerConfig{hostname=" + this.hostname + ", domainname=" + this.domainname + ", user=" + this.user + ", attachStdin=" + this.attachStdin + ", attachStdout=" + this.attachStdout + ", attachStderr=" + this.attachStderr + ", portSpecs=" + String.valueOf(this.portSpecs) + ", exposedPorts=" + String.valueOf(this.exposedPorts) + ", tty=" + this.tty + ", openStdin=" + this.openStdin + ", stdinOnce=" + this.stdinOnce + ", env=" + String.valueOf(this.env) + ", cmd=" + String.valueOf(this.cmd) + ", image=" + this.image + ", volumes=" + String.valueOf(this.volumes) + ", workingDir=" + this.workingDir + ", entrypoint=" + String.valueOf(this.entrypoint) + ", networkDisabled=" + this.networkDisabled + ", onBuild=" + String.valueOf(this.onBuild) + ", labels=" + String.valueOf(this.labels) + ", macAddress=" + this.macAddress + ", hostConfig=" + String.valueOf(this.hostConfig) + ", stopSignal=" + this.stopSignal + ", healthcheck=" + String.valueOf(this.healthcheck) + ", networkingConfig=" + String.valueOf(this.networkingConfig) + "}";
    }

    public static ImmutableContainerConfig copyOf(ContainerConfig instance) {
        if (instance instanceof ImmutableContainerConfig) {
            return (ImmutableContainerConfig)instance;
        }
        return ImmutableContainerConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder
    implements ContainerConfig.Builder {
        private String hostname;
        private String domainname;
        private String user;
        private Boolean attachStdin;
        private Boolean attachStdout;
        private Boolean attachStderr;
        private List<String> portSpecs = null;
        private List<String> exposedPorts = null;
        private Boolean tty;
        private Boolean openStdin;
        private Boolean stdinOnce;
        private List<String> env = null;
        private List<String> cmd = null;
        private String image;
        private List<String> volumes = null;
        private String workingDir;
        private List<String> entrypoint = null;
        private Boolean networkDisabled;
        private List<String> onBuild = null;
        private Map<String, String> labels = null;
        private String macAddress;
        private HostConfig hostConfig;
        private String stopSignal;
        private ContainerConfig.Healthcheck healthcheck;
        private ContainerConfig.NetworkingConfig networkingConfig;

        private Builder() {
        }

        public final Builder from(ContainerConfig instance) {
            ContainerConfig.NetworkingConfig networkingConfigValue;
            ContainerConfig.Healthcheck healthcheckValue;
            String stopSignalValue;
            HostConfig hostConfigValue;
            String macAddressValue;
            Map<String, String> labelsValue;
            List<String> onBuildValue;
            Boolean networkDisabledValue;
            List<String> entrypointValue;
            String workingDirValue;
            Set<String> volumesValue;
            String imageValue;
            List<String> cmdValue;
            List<String> envValue;
            Boolean stdinOnceValue;
            Boolean openStdinValue;
            Boolean ttyValue;
            Set<String> exposedPortsValue;
            List<String> portSpecsValue;
            Boolean attachStderrValue;
            Boolean attachStdoutValue;
            Boolean attachStdinValue;
            String userValue;
            String domainnameValue;
            Objects.requireNonNull(instance, "instance");
            String hostnameValue = instance.hostname();
            if (hostnameValue != null) {
                this.hostname(hostnameValue);
            }
            if ((domainnameValue = instance.domainname()) != null) {
                this.domainname(domainnameValue);
            }
            if ((userValue = instance.user()) != null) {
                this.user(userValue);
            }
            if ((attachStdinValue = instance.attachStdin()) != null) {
                this.attachStdin(attachStdinValue);
            }
            if ((attachStdoutValue = instance.attachStdout()) != null) {
                this.attachStdout(attachStdoutValue);
            }
            if ((attachStderrValue = instance.attachStderr()) != null) {
                this.attachStderr(attachStderrValue);
            }
            if ((portSpecsValue = instance.portSpecs()) != null) {
                this.addAllPortSpecs(portSpecsValue);
            }
            if ((exposedPortsValue = instance.exposedPorts()) != null) {
                this.addAllExposedPorts(exposedPortsValue);
            }
            if ((ttyValue = instance.tty()) != null) {
                this.tty(ttyValue);
            }
            if ((openStdinValue = instance.openStdin()) != null) {
                this.openStdin(openStdinValue);
            }
            if ((stdinOnceValue = instance.stdinOnce()) != null) {
                this.stdinOnce(stdinOnceValue);
            }
            if ((envValue = instance.env()) != null) {
                this.addAllEnv(envValue);
            }
            if ((cmdValue = instance.cmd()) != null) {
                this.addAllCmd(cmdValue);
            }
            if ((imageValue = instance.image()) != null) {
                this.image(imageValue);
            }
            if ((volumesValue = instance.volumes()) != null) {
                this.addAllVolumes(volumesValue);
            }
            if ((workingDirValue = instance.workingDir()) != null) {
                this.workingDir(workingDirValue);
            }
            if ((entrypointValue = instance.entrypoint()) != null) {
                this.addAllEntrypoint(entrypointValue);
            }
            if ((networkDisabledValue = instance.networkDisabled()) != null) {
                this.networkDisabled(networkDisabledValue);
            }
            if ((onBuildValue = instance.onBuild()) != null) {
                this.addAllOnBuild(onBuildValue);
            }
            if ((labelsValue = instance.labels()) != null) {
                this.putAllLabels(labelsValue);
            }
            if ((macAddressValue = instance.macAddress()) != null) {
                this.macAddress(macAddressValue);
            }
            if ((hostConfigValue = instance.hostConfig()) != null) {
                this.hostConfig(hostConfigValue);
            }
            if ((stopSignalValue = instance.stopSignal()) != null) {
                this.stopSignal(stopSignalValue);
            }
            if ((healthcheckValue = instance.healthcheck()) != null) {
                this.healthcheck(healthcheckValue);
            }
            if ((networkingConfigValue = instance.networkingConfig()) != null) {
                this.networkingConfig(networkingConfigValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Hostname")
        @Deprecated
        public final Builder hostname(@Nullable String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Override
        @JsonProperty(value="Domainname")
        @Deprecated
        public final Builder domainname(@Nullable String domainname) {
            this.domainname = domainname;
            return this;
        }

        @Override
        @JsonProperty(value="User")
        public final Builder user(@Nullable String user) {
            this.user = user;
            return this;
        }

        @Override
        @JsonProperty(value="AttachStdin")
        @Deprecated
        public final Builder attachStdin(@Nullable Boolean attachStdin) {
            this.attachStdin = attachStdin;
            return this;
        }

        @Override
        @JsonProperty(value="AttachStdout")
        @Deprecated
        public final Builder attachStdout(@Nullable Boolean attachStdout) {
            this.attachStdout = attachStdout;
            return this;
        }

        @Override
        @JsonProperty(value="AttachStderr")
        @Deprecated
        public final Builder attachStderr(@Nullable Boolean attachStderr) {
            this.attachStderr = attachStderr;
            return this;
        }

        public final Builder portSpec(String element) {
            if (this.portSpecs == null) {
                this.portSpecs = new ArrayList<String>();
            }
            this.portSpecs.add(Objects.requireNonNull(element, "portSpecs element"));
            return this;
        }

        @Override
        public final Builder portSpecs(String ... elements) {
            if (this.portSpecs == null) {
                this.portSpecs = new ArrayList<String>();
            }
            for (String element : elements) {
                this.portSpecs.add(Objects.requireNonNull(element, "portSpecs element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="PortSpecs")
        public final Builder portSpecs(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.portSpecs = null;
                return this;
            }
            this.portSpecs = new ArrayList<String>();
            return this.addAllPortSpecs(elements);
        }

        public final Builder addAllPortSpecs(Iterable<String> elements) {
            Objects.requireNonNull(elements, "portSpecs element");
            if (this.portSpecs == null) {
                this.portSpecs = new ArrayList<String>();
            }
            for (String element : elements) {
                this.portSpecs.add(Objects.requireNonNull(element, "portSpecs element"));
            }
            return this;
        }

        public final Builder exposedPort(String element) {
            if (this.exposedPorts == null) {
                this.exposedPorts = new ArrayList<String>();
            }
            this.exposedPorts.add(Objects.requireNonNull(element, "exposedPorts element"));
            return this;
        }

        @Override
        public final Builder exposedPorts(String ... elements) {
            if (this.exposedPorts == null) {
                this.exposedPorts = new ArrayList<String>();
            }
            for (String element : elements) {
                this.exposedPorts.add(Objects.requireNonNull(element, "exposedPorts element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="ExposedPorts")
        @JsonSerialize(using=ObjectMapperProvider.SetSerializer.class)
        @JsonDeserialize(using=ObjectMapperProvider.SetDeserializer.class)
        public final Builder exposedPorts(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.exposedPorts = null;
                return this;
            }
            this.exposedPorts = new ArrayList<String>();
            return this.addAllExposedPorts(elements);
        }

        public final Builder addAllExposedPorts(Iterable<String> elements) {
            Objects.requireNonNull(elements, "exposedPorts element");
            if (this.exposedPorts == null) {
                this.exposedPorts = new ArrayList<String>();
            }
            for (String element : elements) {
                this.exposedPorts.add(Objects.requireNonNull(element, "exposedPorts element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Tty")
        @Deprecated
        public final Builder tty(@Nullable Boolean tty) {
            this.tty = tty;
            return this;
        }

        @Override
        @JsonProperty(value="OpenStdin")
        @Deprecated
        public final Builder openStdin(@Nullable Boolean openStdin) {
            this.openStdin = openStdin;
            return this;
        }

        @Override
        @JsonProperty(value="StdinOnce")
        @Deprecated
        public final Builder stdinOnce(@Nullable Boolean stdinOnce) {
            this.stdinOnce = stdinOnce;
            return this;
        }

        public final Builder env(String element) {
            if (this.env == null) {
                this.env = new ArrayList<String>();
            }
            this.env.add(Objects.requireNonNull(element, "env element"));
            return this;
        }

        @Override
        public final Builder env(String ... elements) {
            if (this.env == null) {
                this.env = new ArrayList<String>();
            }
            for (String element : elements) {
                this.env.add(Objects.requireNonNull(element, "env element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Env")
        public final Builder env(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.env = null;
                return this;
            }
            this.env = new ArrayList<String>();
            return this.addAllEnv(elements);
        }

        public final Builder addAllEnv(Iterable<String> elements) {
            Objects.requireNonNull(elements, "env element");
            if (this.env == null) {
                this.env = new ArrayList<String>();
            }
            for (String element : elements) {
                this.env.add(Objects.requireNonNull(element, "env element"));
            }
            return this;
        }

        public final Builder cmd(String element) {
            if (this.cmd == null) {
                this.cmd = new ArrayList<String>();
            }
            this.cmd.add(Objects.requireNonNull(element, "cmd element"));
            return this;
        }

        @Override
        public final Builder cmd(String ... elements) {
            if (this.cmd == null) {
                this.cmd = new ArrayList<String>();
            }
            for (String element : elements) {
                this.cmd.add(Objects.requireNonNull(element, "cmd element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Cmd")
        public final Builder cmd(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.cmd = null;
                return this;
            }
            this.cmd = new ArrayList<String>();
            return this.addAllCmd(elements);
        }

        public final Builder addAllCmd(Iterable<String> elements) {
            Objects.requireNonNull(elements, "cmd element");
            if (this.cmd == null) {
                this.cmd = new ArrayList<String>();
            }
            for (String element : elements) {
                this.cmd.add(Objects.requireNonNull(element, "cmd element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Image")
        @Deprecated
        public final Builder image(@Nullable String image) {
            this.image = image;
            return this;
        }

        public final Builder volume(String element) {
            if (this.volumes == null) {
                this.volumes = new ArrayList<String>();
            }
            this.volumes.add(Objects.requireNonNull(element, "volumes element"));
            return this;
        }

        @Override
        public final Builder volumes(String ... elements) {
            if (this.volumes == null) {
                this.volumes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.volumes.add(Objects.requireNonNull(element, "volumes element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Volumes")
        @JsonSerialize(using=ObjectMapperProvider.SetSerializer.class)
        @JsonDeserialize(using=ObjectMapperProvider.SetDeserializer.class)
        public final Builder volumes(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.volumes = null;
                return this;
            }
            this.volumes = new ArrayList<String>();
            return this.addAllVolumes(elements);
        }

        public final Builder addAllVolumes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "volumes element");
            if (this.volumes == null) {
                this.volumes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.volumes.add(Objects.requireNonNull(element, "volumes element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="WorkingDir")
        public final Builder workingDir(@Nullable String workingDir) {
            this.workingDir = workingDir;
            return this;
        }

        public final Builder entrypoint(String element) {
            if (this.entrypoint == null) {
                this.entrypoint = new ArrayList<String>();
            }
            this.entrypoint.add(Objects.requireNonNull(element, "entrypoint element"));
            return this;
        }

        @Override
        public final Builder entrypoint(String ... elements) {
            if (this.entrypoint == null) {
                this.entrypoint = new ArrayList<String>();
            }
            for (String element : elements) {
                this.entrypoint.add(Objects.requireNonNull(element, "entrypoint element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Entrypoint")
        public final Builder entrypoint(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.entrypoint = null;
                return this;
            }
            this.entrypoint = new ArrayList<String>();
            return this.addAllEntrypoint(elements);
        }

        public final Builder addAllEntrypoint(Iterable<String> elements) {
            Objects.requireNonNull(elements, "entrypoint element");
            if (this.entrypoint == null) {
                this.entrypoint = new ArrayList<String>();
            }
            for (String element : elements) {
                this.entrypoint.add(Objects.requireNonNull(element, "entrypoint element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="NetworkDisabled")
        @Deprecated
        public final Builder networkDisabled(@Nullable Boolean networkDisabled) {
            this.networkDisabled = networkDisabled;
            return this;
        }

        public final Builder onBuild(String element) {
            if (this.onBuild == null) {
                this.onBuild = new ArrayList<String>();
            }
            this.onBuild.add(Objects.requireNonNull(element, "onBuild element"));
            return this;
        }

        @Override
        public final Builder onBuild(String ... elements) {
            if (this.onBuild == null) {
                this.onBuild = new ArrayList<String>();
            }
            for (String element : elements) {
                this.onBuild.add(Objects.requireNonNull(element, "onBuild element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="OnBuild")
        public final Builder onBuild(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.onBuild = null;
                return this;
            }
            this.onBuild = new ArrayList<String>();
            return this.addAllOnBuild(elements);
        }

        public final Builder addAllOnBuild(Iterable<String> elements) {
            Objects.requireNonNull(elements, "onBuild element");
            if (this.onBuild == null) {
                this.onBuild = new ArrayList<String>();
            }
            for (String element : elements) {
                this.onBuild.add(Objects.requireNonNull(element, "onBuild element"));
            }
            return this;
        }

        public final Builder addLabel(String key, String value) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            this.labels.put(Objects.requireNonNull(key, "labels key"), Objects.requireNonNull(value, value == null ? "labels value for key: " + key : null));
            return this;
        }

        public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
            String v;
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "labels value for key: " + k : null));
            return this;
        }

        @Override
        @JsonProperty(value="Labels")
        public final Builder labels(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.labels = null;
                return this;
            }
            this.labels = new LinkedHashMap<String, String>();
            return this.putAllLabels(entries);
        }

        public final Builder putAllLabels(Map<String, ? extends String> entries) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "labels value for key: " + k : null));
            }
            return this;
        }

        @Override
        @JsonProperty(value="MacAddress")
        @Deprecated
        public final Builder macAddress(@Nullable String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        @Override
        @JsonProperty(value="HostConfig")
        public final Builder hostConfig(@Nullable HostConfig hostConfig) {
            this.hostConfig = hostConfig;
            return this;
        }

        @Override
        @JsonProperty(value="StopSignal")
        public final Builder stopSignal(@Nullable String stopSignal) {
            this.stopSignal = stopSignal;
            return this;
        }

        @Override
        @JsonProperty(value="Healthcheck")
        public final Builder healthcheck(@Nullable ContainerConfig.Healthcheck healthcheck) {
            this.healthcheck = healthcheck;
            return this;
        }

        @Override
        @JsonProperty(value="NetworkingConfig")
        public final Builder networkingConfig(@Nullable ContainerConfig.NetworkingConfig networkingConfig) {
            this.networkingConfig = networkingConfig;
            return this;
        }

        @Override
        public ImmutableContainerConfig build() {
            return new ImmutableContainerConfig(this.hostname, this.domainname, this.user, this.attachStdin, this.attachStdout, this.attachStderr, this.portSpecs == null ? null : ImmutableContainerConfig.createUnmodifiableList(true, this.portSpecs), this.exposedPorts == null ? null : ImmutableContainerConfig.createUnmodifiableSet(this.exposedPorts), this.tty, this.openStdin, this.stdinOnce, this.env == null ? null : ImmutableContainerConfig.createUnmodifiableList(true, this.env), this.cmd == null ? null : ImmutableContainerConfig.createUnmodifiableList(true, this.cmd), this.image, this.volumes == null ? null : ImmutableContainerConfig.createUnmodifiableSet(this.volumes), this.workingDir, this.entrypoint == null ? null : ImmutableContainerConfig.createUnmodifiableList(true, this.entrypoint), this.networkDisabled, this.onBuild == null ? null : ImmutableContainerConfig.createUnmodifiableList(true, this.onBuild), this.labels == null ? null : ImmutableContainerConfig.createUnmodifiableMap(false, false, this.labels), this.macAddress, this.hostConfig, this.stopSignal, this.healthcheck, this.networkingConfig);
        }
    }

    static final class NetworkingConfig
    implements ContainerConfig.NetworkingConfig {
        private final Map<String, EndpointConfig> endpointsConfig;

        private NetworkingConfig(Map<String, EndpointConfig> endpointsConfig) {
            this.endpointsConfig = endpointsConfig;
        }

        @Override
        @JsonProperty(value="EndpointsConfig")
        public Map<String, EndpointConfig> endpointsConfig() {
            return this.endpointsConfig;
        }

        public final NetworkingConfig withEndpointsConfig(Map<String, ? extends EndpointConfig> entries) {
            if (this.endpointsConfig == entries) {
                return this;
            }
            Map<String, EndpointConfig> newValue = ImmutableContainerConfig.createUnmodifiableMap(true, false, entries);
            return new NetworkingConfig(newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof NetworkingConfig && this.equalTo(0, (NetworkingConfig)another);
        }

        private boolean equalTo(int synthetic, NetworkingConfig another) {
            return this.endpointsConfig.equals(another.endpointsConfig);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.endpointsConfig.hashCode();
            return h;
        }

        public String toString() {
            return "NetworkingConfig{endpointsConfig=" + String.valueOf(this.endpointsConfig) + "}";
        }

        public static NetworkingConfig copyOf(ContainerConfig.NetworkingConfig instance) {
            if (instance instanceof NetworkingConfig) {
                return (NetworkingConfig)instance;
            }
            return NetworkingConfig.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder
        implements ContainerConfig.NetworkingConfig.Builder {
            private Map<String, EndpointConfig> endpointsConfig = new LinkedHashMap<String, EndpointConfig>();

            private Builder() {
            }

            public final Builder from(ContainerConfig.NetworkingConfig instance) {
                Objects.requireNonNull(instance, "instance");
                this.putAllEndpointsConfig(instance.endpointsConfig());
                return this;
            }

            public final Builder addEndpointsConfig(String key, EndpointConfig value) {
                this.endpointsConfig.put(Objects.requireNonNull(key, "endpointsConfig key"), Objects.requireNonNull(value, value == null ? "endpointsConfig value for key: " + key : null));
                return this;
            }

            public final Builder addEndpointsConfig(Map.Entry<String, ? extends EndpointConfig> entry) {
                EndpointConfig v;
                String k = entry.getKey();
                this.endpointsConfig.put(Objects.requireNonNull(k, "endpointsConfig key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "endpointsConfig value for key: " + k : null));
                return this;
            }

            @Override
            @JsonProperty(value="EndpointsConfig")
            public final Builder endpointsConfig(Map<String, ? extends EndpointConfig> entries) {
                this.endpointsConfig.clear();
                return this.putAllEndpointsConfig(entries);
            }

            public final Builder putAllEndpointsConfig(Map<String, ? extends EndpointConfig> entries) {
                for (Map.Entry<String, ? extends EndpointConfig> e : entries.entrySet()) {
                    EndpointConfig v;
                    String k = e.getKey();
                    this.endpointsConfig.put(Objects.requireNonNull(k, "endpointsConfig key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "endpointsConfig value for key: " + k : null));
                }
                return this;
            }

            @Override
            public NetworkingConfig build() {
                return new NetworkingConfig(ImmutableContainerConfig.createUnmodifiableMap(false, false, this.endpointsConfig));
            }
        }
    }

    static final class Healthcheck
    implements ContainerConfig.Healthcheck {
        @Nullable
        private final List<String> test;
        @Nullable
        private final Long interval;
        @Nullable
        private final Long timeout;
        @Nullable
        private final Integer retries;
        @Nullable
        private final Long startPeriod;

        private Healthcheck(@Nullable List<String> test, @Nullable Long interval, @Nullable Long timeout, @Nullable Integer retries, @Nullable Long startPeriod) {
            this.test = test;
            this.interval = interval;
            this.timeout = timeout;
            this.retries = retries;
            this.startPeriod = startPeriod;
        }

        @Override
        @JsonProperty(value="Test")
        @Nullable
        public List<String> test() {
            return this.test;
        }

        @Override
        @JsonProperty(value="Interval")
        @Nullable
        public Long interval() {
            return this.interval;
        }

        @Override
        @JsonProperty(value="Timeout")
        @Nullable
        public Long timeout() {
            return this.timeout;
        }

        @Override
        @JsonProperty(value="Retries")
        @Nullable
        public Integer retries() {
            return this.retries;
        }

        @Override
        @JsonProperty(value="StartPeriod")
        @Nullable
        public Long startPeriod() {
            return this.startPeriod;
        }

        public final Healthcheck withTest(String ... elements) {
            if (elements == null) {
                return new Healthcheck(null, this.interval, this.timeout, this.retries, this.startPeriod);
            }
            List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerConfig.createUnmodifiableList(false, ImmutableContainerConfig.createSafeList(Arrays.asList(elements), true, false));
            return new Healthcheck(newValue, this.interval, this.timeout, this.retries, this.startPeriod);
        }

        public final Healthcheck withTest(@Nullable Iterable<String> elements) {
            if (this.test == elements) {
                return this;
            }
            List<String> newValue = elements == null ? null : ImmutableContainerConfig.createUnmodifiableList(false, ImmutableContainerConfig.createSafeList(elements, true, false));
            return new Healthcheck(newValue, this.interval, this.timeout, this.retries, this.startPeriod);
        }

        public final Healthcheck withInterval(@Nullable Long value) {
            if (Objects.equals(this.interval, value)) {
                return this;
            }
            return new Healthcheck(this.test, value, this.timeout, this.retries, this.startPeriod);
        }

        public final Healthcheck withTimeout(@Nullable Long value) {
            if (Objects.equals(this.timeout, value)) {
                return this;
            }
            return new Healthcheck(this.test, this.interval, value, this.retries, this.startPeriod);
        }

        public final Healthcheck withRetries(@Nullable Integer value) {
            if (Objects.equals(this.retries, value)) {
                return this;
            }
            return new Healthcheck(this.test, this.interval, this.timeout, value, this.startPeriod);
        }

        public final Healthcheck withStartPeriod(@Nullable Long value) {
            if (Objects.equals(this.startPeriod, value)) {
                return this;
            }
            return new Healthcheck(this.test, this.interval, this.timeout, this.retries, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Healthcheck && this.equalTo(0, (Healthcheck)another);
        }

        private boolean equalTo(int synthetic, Healthcheck another) {
            return Objects.equals(this.test, another.test) && Objects.equals(this.interval, another.interval) && Objects.equals(this.timeout, another.timeout) && Objects.equals(this.retries, another.retries) && Objects.equals(this.startPeriod, another.startPeriod);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.test);
            h += (h << 5) + Objects.hashCode(this.interval);
            h += (h << 5) + Objects.hashCode(this.timeout);
            h += (h << 5) + Objects.hashCode(this.retries);
            h += (h << 5) + Objects.hashCode(this.startPeriod);
            return h;
        }

        public String toString() {
            return "Healthcheck{test=" + String.valueOf(this.test) + ", interval=" + this.interval + ", timeout=" + this.timeout + ", retries=" + this.retries + ", startPeriod=" + this.startPeriod + "}";
        }

        public static Healthcheck copyOf(ContainerConfig.Healthcheck instance) {
            if (instance instanceof Healthcheck) {
                return (Healthcheck)instance;
            }
            return Healthcheck.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder
        implements ContainerConfig.Healthcheck.Builder {
            private List<String> test = null;
            private Long interval;
            private Long timeout;
            private Integer retries;
            private Long startPeriod;

            private Builder() {
            }

            public final Builder from(ContainerConfig.Healthcheck instance) {
                Long startPeriodValue;
                Integer retriesValue;
                Long timeoutValue;
                Long intervalValue;
                Objects.requireNonNull(instance, "instance");
                List<String> testValue = instance.test();
                if (testValue != null) {
                    this.addAllTest(testValue);
                }
                if ((intervalValue = instance.interval()) != null) {
                    this.interval(intervalValue);
                }
                if ((timeoutValue = instance.timeout()) != null) {
                    this.timeout(timeoutValue);
                }
                if ((retriesValue = instance.retries()) != null) {
                    this.retries(retriesValue);
                }
                if ((startPeriodValue = instance.startPeriod()) != null) {
                    this.startPeriod(startPeriodValue);
                }
                return this;
            }

            public final Builder test(String element) {
                if (this.test == null) {
                    this.test = new ArrayList<String>();
                }
                this.test.add(Objects.requireNonNull(element, "test element"));
                return this;
            }

            public final Builder test(String ... elements) {
                if (this.test == null) {
                    this.test = new ArrayList<String>();
                }
                for (String element : elements) {
                    this.test.add(Objects.requireNonNull(element, "test element"));
                }
                return this;
            }

            @Override
            @JsonProperty(value="Test")
            public final Builder test(@Nullable Iterable<String> elements) {
                if (elements == null) {
                    this.test = null;
                    return this;
                }
                this.test = new ArrayList<String>();
                return this.addAllTest(elements);
            }

            public final Builder addAllTest(Iterable<String> elements) {
                Objects.requireNonNull(elements, "test element");
                if (this.test == null) {
                    this.test = new ArrayList<String>();
                }
                for (String element : elements) {
                    this.test.add(Objects.requireNonNull(element, "test element"));
                }
                return this;
            }

            @Override
            @JsonProperty(value="Interval")
            public final Builder interval(@Nullable Long interval) {
                this.interval = interval;
                return this;
            }

            @Override
            @JsonProperty(value="Timeout")
            public final Builder timeout(@Nullable Long timeout) {
                this.timeout = timeout;
                return this;
            }

            @Override
            @JsonProperty(value="Retries")
            public final Builder retries(@Nullable Integer retries) {
                this.retries = retries;
                return this;
            }

            @Override
            @JsonProperty(value="StartPeriod")
            public final Builder startPeriod(@Nullable Long startPeriod) {
                this.startPeriod = startPeriod;
                return this;
            }

            @Override
            public Healthcheck build() {
                return new Healthcheck(this.test == null ? null : ImmutableContainerConfig.createUnmodifiableList(true, this.test), this.interval, this.timeout, this.retries, this.startPeriod);
            }
        }
    }
}

