/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ssh.proxy;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.Vector;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.ssh.proxy.Messages;
import org.eclipse.linuxtools.internal.ssh.proxy.ProgressMonitor;
import org.eclipse.linuxtools.internal.ssh.proxy.SSHFileProxy;

public class SSHFileStore
extends FileStore {
    private URI uri;
    private Path path;
    private SSHFileProxy proxy;
    private static final int USER_READ = 256;
    private static final int USER_WRITE = 128;
    private static final int USER_EXEC = 64;
    private static final int GROUP_READ = 32;
    private static final int GROUP_WRITE = 16;
    private static final int GROUP_EXEC = 8;
    private static final int OTHER_READ = 4;
    private static final int OTHER_WRITE = 2;
    private static final int OTHER_EXEC = 1;

    public SSHFileStore(URI uri, SSHFileProxy proxy) {
        this.uri = uri;
        this.proxy = proxy;
        this.path = new Path(uri.getPath());
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(Messages.SSHFileStore_childNamesMonitor, 100);
            ChannelSftp channel = this.proxy.getChannelSftp();
            monitor.worked(25);
            Vector v = channel.ls(this.uri.getPath());
            monitor.worked(50);
            LinkedList<String> childs = new LinkedList<String>();
            boolean isDir = false;
            for (int i = 0; i < v.size(); ++i) {
                ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)v.get(i);
                if (!entry.getFilename().equals(".") && !entry.getFilename().equals("..")) {
                    childs.add(entry.getFilename());
                    continue;
                }
                isDir = true;
            }
            if (!isDir) {
                throw new CoreException(Status.error((String)MessageFormat.format(Messages.SSHFileStore_childNamesFailedDirectory, this.getName())));
            }
            monitor.worked(100);
            monitor.done();
            return childs.toArray(new String[0]);
        }
        catch (SftpException e) {
            throw new CoreException(Status.error((String)(Messages.SSHFileStore_childNamesFailed + e.getMessage()), (Throwable)e));
        }
    }

    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(Messages.SSHFileStore_childInfoMonitor, 100);
            ChannelSftp channel = this.proxy.getChannelSftp();
            monitor.worked(25);
            Vector v = channel.ls(this.uri.getPath());
            monitor.worked(50);
            LinkedList<IFileInfo> childs = new LinkedList<IFileInfo>();
            boolean isDir = false;
            for (int i = 0; i < v.size(); ++i) {
                ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)v.get(i);
                if (!entry.getFilename().equals(".") && !entry.getFilename().equals("..")) {
                    childs.add(this.createFileInfo(entry.getAttrs()));
                    continue;
                }
                isDir = true;
            }
            if (!isDir) {
                throw new CoreException(Status.error((String)MessageFormat.format(Messages.SSHFileStore_childInfoFailedDirectory, this.getName())));
            }
            monitor.worked(100);
            monitor.done();
            return childs.toArray(new IFileInfo[0]);
        }
        catch (SftpException e) {
            throw new CoreException(Status.error((String)(Messages.SSHFileStore_childInfoFailed + e.getMessage()), (Throwable)e));
        }
    }

    public IFileInfo fetchInfo() {
        try {
            return this.fetchInfo(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            return null;
        }
    }

    public IFileStore[] childStores(int options, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(Messages.SSHFileStore_childStoresMonitor, 100);
            ChannelSftp channel = this.proxy.getChannelSftp();
            monitor.worked(25);
            Vector v = channel.ls(this.uri.getPath());
            monitor.worked(50);
            LinkedList<IFileStore> childs = new LinkedList<IFileStore>();
            boolean isDir = false;
            for (int i = 0; i < v.size(); ++i) {
                ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)v.get(i);
                if (!entry.getFilename().equals(".") && !entry.getFilename().equals("..")) {
                    childs.add(this.createFileStore(this.path.append(entry.getFilename()).toString()));
                    continue;
                }
                isDir = true;
            }
            if (!isDir) {
                throw new CoreException(Status.error((String)MessageFormat.format(Messages.SSHFileStore_childStoresFailedDirectory, this.getName())));
            }
            monitor.worked(100);
            monitor.done();
            return childs.toArray(new IFileStore[0]);
        }
        catch (SftpException e) {
            throw new CoreException(Status.error((String)(Messages.SSHFileStore_childStoresFailed + e.getMessage()), (Throwable)e));
        }
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(Messages.SSHFileStore_rmMonitor, 100);
            ChannelSftp channel = this.proxy.getChannelSftp();
            monitor.worked(25);
            if (channel.lstat(this.uri.getPath()).isDir()) {
                channel.rmdir(this.uri.getPath());
            } else {
                channel.rm(this.uri.getPath());
            }
            monitor.worked(100);
            monitor.done();
        }
        catch (SftpException e) {
            throw new CoreException(Status.error((String)(Messages.SSHFileStore_rmFailed + e.getMessage()), (Throwable)e));
        }
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(Messages.SSHFileStore_attrMonitor, 100);
            ChannelSftp channel = this.proxy.getChannelSftp();
            monitor.worked(25);
            SftpATTRS attrs = channel.stat(this.uri.getPath());
            monitor.worked(100);
            monitor.done();
            return this.createFileInfo(attrs);
        }
        catch (SftpException e) {
            throw new CoreException(Status.error((String)(Messages.SSHFileStore_attrFailed + e.getMessage()), (Throwable)e));
        }
    }

    public IFileStore getChild(String name) {
        String strPath = this.path.append(name).toString();
        return this.createFileStore(strPath);
    }

    public String getName() {
        String name = this.path.lastSegment();
        if (name == null) {
            name = "";
        }
        return name;
    }

    public IFileStore getParent() {
        if (this.path.isRoot()) {
            return null;
        }
        String strPath = this.path.removeLastSegments(1).toString();
        return this.createFileStore(strPath);
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.SSHFileStore_mkdirMonitor, 100);
        ChannelSftp channel = this.proxy.getChannelSftp();
        monitor.worked(25);
        Path new_path = Path.ROOT;
        if ((options & 4) == 0) {
            for (String segment : this.path.segments()) {
                new_path = new_path.append(segment);
                try {
                    channel.stat(new_path.toString());
                }
                catch (SftpException e) {
                    this.createDir(channel, new_path.toString());
                }
            }
        } else {
            this.createDir(channel, this.uri.getPath());
        }
        monitor.worked(100);
        monitor.done();
        return this;
    }

    private void createDir(ChannelSftp channel, String dir) throws CoreException {
        try {
            channel.mkdir(dir);
        }
        catch (SftpException e) {
            throw new CoreException(Status.error((String)(Messages.SSHFileStore_mkdirFailed + e.getMessage()), (Throwable)e));
        }
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        try {
            ChannelSftp channel = this.proxy.getChannelSftp();
            return channel.get(this.uri.getPath(), (SftpProgressMonitor)new ProgressMonitor(monitor, Messages.SSHFileStore_getInputStreamMonitor));
        }
        catch (SftpException e) {
            throw new CoreException(Status.error((String)(Messages.SSHFileStore_getInputStreamFailed + e.getMessage()), (Throwable)e));
        }
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        try {
            ChannelSftp channel = this.proxy.getChannelSftp();
            int mode = 0;
            if ((options & 1) != 0) {
                mode = 2;
            }
            return channel.put(this.uri.getPath(), (SftpProgressMonitor)new ProgressMonitor(monitor, Messages.SSHFileStore_getOutputStreamMonitor), mode);
        }
        catch (SftpException e) {
            throw new CoreException(Status.error((String)(Messages.SSHFileStore_getOutputStreamFailed + e.getMessage()), (Throwable)e));
        }
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(Messages.SSHFileStore_putInfoMonitor, 100);
            ChannelSftp channel = this.proxy.getChannelSftp();
            monitor.worked(25);
            SftpATTRS attrs = channel.stat(this.uri.getPath());
            this.updateSftpATTRS(info);
            channel.setStat(this.uri.getPath(), attrs);
            monitor.worked(100);
            monitor.done();
        }
        catch (SftpException e) {
            throw new CoreException(Status.error((String)(Messages.SSHFileStore_putInfoFailed + e.getMessage()), (Throwable)e));
        }
    }

    public URI toURI() {
        return this.uri;
    }

    private IFileStore createFileStore(String newPath) {
        try {
            return new SSHFileStore(new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), newPath, this.uri.getQuery(), this.uri.getFragment()), this.proxy);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private IFileInfo createFileInfo(SftpATTRS attrs) {
        FileInfo f = new FileInfo();
        f.setExists(true);
        f.setLastModified((long)attrs.getMTime());
        f.setLength(attrs.getSize());
        f.setName(this.getName());
        f.setDirectory(attrs.isDir());
        int p = attrs.getPermissions();
        if ((p & 0x100) != 0) {
            f.setAttribute(0x400000, true);
        }
        if ((p & 0x80) != 0) {
            f.setAttribute(0x800000, true);
        }
        if ((p & 0x40) != 0) {
            f.setAttribute(0x1000000, true);
        }
        if ((p & 0x20) != 0) {
            f.setAttribute(0x2000000, true);
        }
        if ((p & 0x10) != 0) {
            f.setAttribute(0x4000000, true);
        }
        if ((p & 8) != 0) {
            f.setAttribute(0x8000000, true);
        }
        if ((p & 4) != 0) {
            f.setAttribute(0x10000000, true);
        }
        if ((p & 2) != 0) {
            f.setAttribute(0x20000000, true);
        }
        if ((p & 1) != 0) {
            f.setAttribute(0x40000000, true);
        }
        return f;
    }

    private void updateSftpATTRS(IFileInfo f) {
        int p = 0;
        if (f.getAttribute(0x400000)) {
            p |= 0x100;
        }
        if (f.getAttribute(0x800000)) {
            p |= 0x80;
        }
        if (f.getAttribute(0x1000000)) {
            p |= 0x40;
        }
        if (f.getAttribute(0x2000000)) {
            p |= 0x20;
        }
        if (f.getAttribute(0x4000000)) {
            p |= 0x10;
        }
        if (f.getAttribute(0x8000000)) {
            p |= 8;
        }
        if (f.getAttribute(0x10000000)) {
            p |= 4;
        }
        if (f.getAttribute(0x20000000)) {
            p |= 2;
        }
        if (f.getAttribute(0x40000000)) {
            p |= 1;
        }
    }
}

