/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.ui.editor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.linuxtools.internal.valgrind.ui.editor.SuppressionKindRule;
import org.eclipse.linuxtools.internal.valgrind.ui.editor.SuppressionToolRule;
import org.eclipse.ui.PlatformUI;

public class SuppressionsElementScanner
extends BufferedRuleBasedScanner {
    public static final String MEMCHECK = "Memcheck";
    public static final String[] MEMCHECK_SUPP_TYPES = new String[]{"Value0", "Value1", "Value2", "Value4", "Value8", "Value16", "Cond", "Addr1", "Addr2", "Addr4", "Addr8", "Addr16", "Jump", "Param", "Free", "Overlap", "Leak"};
    public static final String[] CONTEXTS = new String[]{"obj", "fun"};

    public SuppressionsElementScanner() {
        ColorRegistry colorRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        String[] tools = new String[]{MEMCHECK};
        HashMap<String, List<String>> kinds = new HashMap<String, List<String>>();
        kinds.put(MEMCHECK, Arrays.asList(MEMCHECK_SUPP_TYPES));
        Token defaultToken = new Token((Object)new TextAttribute(colorRegistry.get("org.eclipse.linuxtools.valgrind.ediotr.color.default")));
        Token toolToken = new Token((Object)new TextAttribute(colorRegistry.get("org.eclipse.linuxtools.valgrind.editor.color.tool"), null, 1));
        Token suppKindToken = new Token((Object)new TextAttribute(colorRegistry.get("org.eclipse.linuxtools.valgrind.editor.color.supp_type")));
        Token contextToken = new Token((Object)new TextAttribute(colorRegistry.get("org.eclipse.linuxtools.valgrind.editor.color.context"), null, 1));
        Token commentToken = new Token((Object)new TextAttribute(colorRegistry.get("org.eclipse.linuxtools.valgrind.editor.color.comment")));
        this.setDefaultReturnToken((IToken)defaultToken);
        this.setRules(new IRule[]{new EndOfLineRule("#", (IToken)commentToken), new SuppressionToolRule(tools, (IToken)toolToken), new SuppressionKindRule(kinds, (IToken)suppKindToken), new SuppressionToolRule(CONTEXTS, (IToken)contextToken), new WhitespaceRule(c -> Character.isWhitespace(c))});
    }
}

