/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.ratio.solvers.policy;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.math3.fraction.Fraction;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Triple;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;
import org.eclipse.lsat.common.ludus.backend.games.StrategyVector;
import org.eclipse.lsat.common.ludus.backend.games.ratio.solvers.policy.RatioGamePolicyIteration;

public class PolicyIterationInt {
    private static final Fraction MINUS_INFTY = new Fraction(Integer.MIN_VALUE);

    private PolicyIterationInt() {
    }

    public static <V, E> Tuple<Map<V, Fraction>, StrategyVector<V, E>> solve(RatioGamePolicyIteration<V, E, Integer> game) {
        StrategyVector initialStrategy = new StrategyVector();
        initialStrategy.initializeRandomStrategy(game);
        return PolicyIterationInt.solve(game, initialStrategy);
    }

    public static <V, E> Tuple<Map<V, Fraction>, StrategyVector<V, E>> solve(RatioGamePolicyIteration<V, E, Integer> game, StrategyVector<V, E> initialStrategy) {
        Set vertices = game.getVertices();
        Map distVector = PolicyIterationInt.initializeVector(vertices, Fraction.ZERO);
        Map ratioVector = PolicyIterationInt.initializeVector(vertices, MINUS_INFTY);
        StrategyVector currentStrategy = initialStrategy;
        boolean improvement = true;
        while (improvement) {
            Triple<Map<V, Fraction>, Map<V, Fraction>, StrategyVector<V, E>> result = PolicyIterationInt.improveStrategyPlayer1(game, currentStrategy, distVector, ratioVector);
            distVector = result.getLeft();
            ratioVector = result.getMiddle();
            currentStrategy = result.getRight();
            improvement = false;
            for (Object v : game.getV0()) {
                for (Object e : game.outgoingEdgesOf(v)) {
                    Object u = game.getEdgeTarget(e);
                    Fraction mw = ratioVector.get(u);
                    Integer w1 = (Integer)game.getWeight1(e);
                    Integer w2 = (Integer)game.getWeight2(e);
                    Fraction reweighted = new Fraction(mw.getDenominator() * w1 - mw.getNumerator() * w2);
                    if (!PolicyIterationInt.isSmaller(ratioVector.get(v), ratioVector.get(u)) && (!ratioVector.get(v).equals((Object)ratioVector.get(u)) || !PolicyIterationInt.isSmaller(distVector.get(v), distVector.get(u).add(reweighted)))) continue;
                    currentStrategy.setSuccessor(v, u);
                    improvement = true;
                }
            }
        }
        return Tuple.of(ratioVector, currentStrategy);
    }

    private static <V, E> Triple<Map<V, Fraction>, Map<V, Fraction>, StrategyVector<V, E>> improveStrategyPlayer1(RatioGamePolicyIteration<V, E, Integer> game, StrategyVector<V, E> currentStrategy, Map<V, Fraction> d_prev, Map<V, Fraction> r_prev) {
        int t = -1;
        boolean improvement = true;
        Map<V, Fraction> d_i_t = new HashMap<V, Fraction>(d_prev);
        Map<V, Fraction> r_i_t = new HashMap<V, Fraction>(r_prev);
        StrategyVector s_i_t = new StrategyVector(currentStrategy);
        while (improvement) {
            ++t;
            Tuple<Map<V, Fraction>, Map<V, Fraction>> evalResult = PolicyIterationInt.evaluateStrategy(game, s_i_t, d_prev, r_prev);
            d_i_t = evalResult.getLeft();
            r_i_t = evalResult.getRight();
            improvement = false;
            for (Object v : game.getV1()) {
                for (Object e : game.outgoingEdgesOf(v)) {
                    Object u = game.getEdgeTarget(e);
                    Fraction cycleRatio = r_i_t.get(u);
                    Integer w1 = (Integer)game.getWeight1(e);
                    Integer w2 = (Integer)game.getWeight2(e);
                    Fraction reweighted = new Fraction(cycleRatio.getDenominator() * w1 - cycleRatio.getNumerator() * w2);
                    if (!PolicyIterationInt.isLarger(r_i_t.get(v), r_i_t.get(u)) && (!r_i_t.get(v).equals((Object)r_i_t.get(u)) || !PolicyIterationInt.isLarger(d_i_t.get(v), d_i_t.get(u).add(reweighted)))) continue;
                    s_i_t.setSuccessor(v, u);
                    improvement = true;
                }
            }
        }
        return Triple.of(d_i_t, r_i_t, s_i_t);
    }

    private static <V, E> Tuple<Map<V, Fraction>, Map<V, Fraction>> evaluateStrategy(RatioGamePolicyIteration<V, E, Integer> game, StrategyVector<V, E> strategy, Map<V, Fraction> distanceVector, Map<V, Fraction> ratioVector) {
        Tuple<Set<V>, Map<V, Fraction>> cycleResult = PolicyIterationInt.findCyclesInRestrictedGraph(game, strategy);
        Map<V, Fraction> r_i_t = cycleResult.getRight();
        Tuple<Map<V, Fraction>, Map<V, Fraction>> cd = PolicyIterationInt.computeDistances(game, strategy, (Collection)cycleResult.getLeft(), r_i_t, distanceVector, ratioVector);
        Map<V, Fraction> d_i_t = cd.getLeft();
        r_i_t = cd.getRight();
        return Tuple.of(d_i_t, r_i_t);
    }

    protected static <V, E> Tuple<Set<V>, Map<V, Fraction>> findCyclesInRestrictedGraph(RatioGamePolicyIteration<V, E, Integer> game, StrategyVector<V, E> currentStrategy) {
        Object BOTTOM_VERTEX = null;
        HashSet selectedVertices = new HashSet();
        Map visited = PolicyIterationInt.initializeVector(game.getVertices(), BOTTOM_VERTEX);
        HashMap r_i_t = new HashMap();
        for (Object v : game.getVertices()) {
            if (visited.get(v) != BOTTOM_VERTEX) continue;
            Object u = v;
            while (visited.get(u) == BOTTOM_VERTEX) {
                visited.put(u, v);
                u = currentStrategy.getSuccessor(u);
            }
            if (visited.get(u) != v) continue;
            Object v_s = u;
            V x = currentStrategy.getSuccessor(u);
            Object e = game.getEdge(u, currentStrategy.getSuccessor(u));
            Integer w1sum = (Integer)game.getWeight1(e);
            Integer w2sum = (Integer)game.getWeight2(e);
            while (x != u) {
                if (game.getId(x) < game.getId(v_s)) {
                    v_s = x;
                }
                Object x_sucx = game.getEdge(x, currentStrategy.getSuccessor(x));
                Integer w1 = (Integer)game.getWeight1(x_sucx);
                Integer w2 = (Integer)game.getWeight2(x_sucx);
                w1sum = w1sum + w1;
                w2sum = w2sum + w2;
                x = currentStrategy.getSuccessor(x);
            }
            r_i_t.put(v_s, new Fraction(w1sum.intValue(), w2sum.intValue()));
            selectedVertices.add(v_s);
        }
        return Tuple.of(selectedVertices, r_i_t);
    }

    private static <V, E> Tuple<Map<V, Fraction>, Map<V, Fraction>> computeDistances(RatioGamePolicyIteration<V, E, Integer> game, StrategyVector<V, E> currentStrategy, Collection<V> selectedVertices, Map<V, Fraction> r_i_t, Map<V, Fraction> d_prev, Map<V, Fraction> r_prev) {
        Stack<V> stack = new Stack<V>();
        Map<Boolean, Boolean> visited = PolicyIterationInt.initializeVector(game.getVertices(), false);
        HashMap<Object, Fraction> d_i_t = new HashMap<Object, Fraction>();
        for (V u : selectedVertices) {
            if (r_prev.get(u).equals((Object)r_i_t.get(u))) {
                d_i_t.put(u, d_prev.get(u));
            } else {
                d_i_t.put(u, Fraction.ZERO);
            }
            visited.put((Boolean)u, true);
        }
        for (V v : game.getVertices()) {
            if (visited.get(v).booleanValue()) continue;
            Object u = v;
            while (!visited.get(u).booleanValue()) {
                visited.put((Boolean)u, true);
                stack.push(u);
                u = currentStrategy.getSuccessor(u);
            }
            while (!stack.isEmpty()) {
                Object x = stack.pop();
                Object e = game.getEdge(x, u);
                Integer w1 = (Integer)game.getWeight1(e);
                Integer w2 = (Integer)game.getWeight2(e);
                Fraction cycleRatio = r_i_t.get(u);
                Fraction reweighted = new Fraction(cycleRatio.getDenominator() * w1 - cycleRatio.getNumerator() * w2);
                r_i_t.put((Fraction)x, cycleRatio);
                d_i_t.put(x, ((Fraction)d_i_t.get(u)).add(reweighted));
                u = x;
            }
        }
        return Tuple.of(d_i_t, r_i_t);
    }

    private static boolean isSmaller(Fraction frac1, Fraction frac2) {
        return frac1.compareTo(frac2) < 0;
    }

    private static boolean isLarger(Fraction frac1, Fraction frac2) {
        return frac1.compareTo(frac2) > 0;
    }

    private static <V, T> Map<V, T> initializeVector(Collection<V> vertices, T value) {
        HashMap vector = new HashMap();
        vertices.forEach(v -> {
            Object object2 = vector.put(v, value);
        });
        return vector;
    }

    private static <V, E> String printVector(RatioGamePolicyIteration<V, E, Integer> game, Map<V, Fraction> values) {
        StringBuilder output = new StringBuilder();
        for (V v : values.keySet()) {
            output.append(game.getId(v)).append(": ").append(values.get(v)).append(", ");
        }
        return output.toString();
    }

    private static <V, E> String printStrategy(RatioGamePolicyIteration<V, E, Integer> game, StrategyVector<V, E> strategy) {
        return strategy.getVertices().stream().map(v -> game.getId(v).toString() + "-->" + game.getId(strategy.getSuccessor(v)).toString()).collect(Collectors.joining(", ", "{", "}"));
    }
}

