/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.incremental;

import com.google.common.hash.HashCode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.persistence.SerializableEObjectDescription;
import org.eclipse.xtext.resource.persistence.SerializableReferenceDescription;
import org.eclipse.xtext.resource.persistence.SerializableResourceDescription;

public class ExtendedEObjectInputStream
extends BinaryResourceImpl.EObjectInputStream {
    private final byte[] hashBuffer;
    private final List<IPath> paths;
    private final List<char[][]> charchars;
    private final List<char[]> chars;

    public ExtendedEObjectInputStream(InputStream source, int hashBits) throws IOException {
        super(source, Collections.emptyMap());
        this.hashBuffer = new byte[hashBits / 8];
        this.paths = new ArrayList<IPath>();
        this.charchars = new ArrayList<char[][]>();
        this.chars = new ArrayList<char[]>();
    }

    public HashCode readHashCode() throws IOException {
        int i = 0;
        while (i < this.hashBuffer.length) {
            this.hashBuffer[i] = this.readByte();
            ++i;
        }
        return HashCode.fromBytes((byte[])this.hashBuffer);
    }

    public IPath readPath() throws IOException {
        int idx = this.readCompressedInt();
        if (idx < this.paths.size()) {
            return this.paths.get(idx);
        }
        IPath result = Path.fromPortableString((String)this.readSegmentedString());
        this.paths.add(result);
        return result;
    }

    public char[][] readCharCharArray() throws IOException {
        int idx = this.readCompressedInt();
        if (idx < this.charchars.size()) {
            return this.charchars.get(idx);
        }
        char[][] result = new char[this.readCompressedInt()][];
        int i = 0;
        while (i < result.length) {
            idx = this.readCompressedInt();
            if (idx < this.chars.size()) {
                result[i] = this.chars.get(idx);
            } else {
                char[] cs = this.readString().toCharArray();
                this.chars.add(cs);
                result[i] = cs;
            }
            ++i;
        }
        this.charchars.add(result);
        return result;
    }

    public SerializableResourceDescription readResourceDescription() throws IOException {
        SerializableResourceDescription result = new SerializableResourceDescription();
        result.setURI(this.readURI());
        result.setDescriptions(this.readEObjectDescriptions());
        result.setReferences(this.readReferenceDescriptions());
        result.setImportedNames(this.readImportedNames());
        return result;
    }

    protected List<SerializableEObjectDescription> readEObjectDescriptions() throws IOException {
        int size = this.readCompressedInt();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<SerializableEObjectDescription> result = new ArrayList<SerializableEObjectDescription>(size);
        while (size > 0) {
            --size;
            SerializableEObjectDescription object = new SerializableEObjectDescription();
            object.setEObjectURI(this.readURI());
            object.setEClass(this.readEClass().eClass);
            object.setQualifiedName(QualifiedName.createFromStream((BinaryResourceImpl.EObjectInputStream)this));
            int userDataSize = this.readCompressedInt();
            HashMap<String, String> userData = new HashMap<String, String>(userDataSize);
            while (userDataSize > 0) {
                --userDataSize;
                String key = this.readString();
                userData.put(key, this.readString());
            }
            object.setUserData(userData);
            result.add(object);
        }
        return result;
    }

    protected List<SerializableReferenceDescription> readReferenceDescriptions() throws IOException {
        int size = this.readCompressedInt();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<SerializableReferenceDescription> result = new ArrayList<SerializableReferenceDescription>(size);
        while (size > 0) {
            --size;
            SerializableReferenceDescription reference = new SerializableReferenceDescription();
            reference.setSourceEObjectUri(this.readURI());
            reference.setTargetEObjectUri(this.readURI());
            reference.setContainerEObjectURI(this.readURI());
            reference.setEReference((EReference)this.readEStructuralFeature().eStructuralFeature);
            reference.setIndexInList(this.readCompressedInt());
            result.add(reference);
        }
        return result;
    }

    protected List<QualifiedName> readImportedNames() throws IOException {
        int size = this.readCompressedInt();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<QualifiedName> result = new ArrayList<QualifiedName>(size);
        while (size > 0) {
            --size;
            result.add(QualifiedName.createFromStream((BinaryResourceImpl.EObjectInputStream)this));
        }
        return result;
    }
}

